/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enums.SourceTypeEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.service.ElsTaxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u7a0e\u7387\u7a0e\u7801"})
@RestController
@RequestMapping(value={"/system/elsTax"})
public class ElsTaxController
extends BaseController<ElsTax, ElsTaxService> {
    private static final String fixPreRedisKey = "tax_";
    private static final String fixPreRedisKeyTax = "sys:dict::";
    @Autowired
    private ElsTaxService elsTaxService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String elsAccount = StringUtils.isBlank((CharSequence)req.getParameter("elsAccount")) ? TenantContext.getTenant() : req.getParameter("elsAccount");
        QueryWrapper<ElsTax> queryWrapper = QueryGenerator.initQueryWrapper(elsTax, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> querySysPageList(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ElsTax> queryWrapper = QueryGenerator.initQueryWrapper(elsTax, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryTaxForTemplate"})
    public Result<?> queryTaxForTemplate(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String elsAccount = StringUtils.isBlank((CharSequence)req.getParameter("purchaseAccount")) ? TenantContext.getTenant() : req.getParameter("purchaseAccount");
        QueryWrapper<ElsTax> queryWrapper = QueryGenerator.initQueryWrapper(elsTax, req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            queryWrapper.clear();
            queryWrapper = QueryGenerator.initQueryWrapper(elsTax, req.getParameterMap());
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
            pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8", notes="\u67e5\u8be2\u5168\u90e8")
    @RequestMapping(value={"/listAll"}, method={RequestMethod.POST})
    public Result<List<ElsTax>> listAll(@RequestBody ElsTax elsTax) {
        String elsAccount = TenantContext.getTenant();
        String redisKey = fixPreRedisKey + elsAccount;
        Result<List<ElsTax>> result = new Result<List<ElsTax>>();
        List ls = null;
        if (StringUtils.isBlank((CharSequence)elsTax.getTaxCode())) {
            Object object = this.redisUtil.get(redisKey);
            if (object != null) {
                ls = (List)object;
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)elsAccount);
                ls = this.elsTaxService.list((Wrapper)queryWrapper);
                if (ls.isEmpty()) {
                    queryWrapper.clear();
                    queryWrapper.eq((Object)"els_account", (Object)"100000");
                    ls = this.elsTaxService.list((Wrapper)queryWrapper);
                    if (!ls.isEmpty()) {
                        this.redisUtil.set(redisKey, ls);
                    }
                }
            }
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"tax_code", (Object)elsTax.getTaxCode());
            ls = this.elsTaxService.list((Wrapper)queryWrapper);
            if (ls.isEmpty()) {
                queryWrapper.clear();
                queryWrapper.eq((Object)"els_account", (Object)"100000");
                queryWrapper.eq((Object)"tax_code", (Object)elsTax.getTaxCode());
                ls = this.elsTaxService.list((Wrapper)queryWrapper);
            }
        }
        result.setSuccess(true);
        result.setResult(ls);
        return result;
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsTax elsTax) {
        elsTax.setSourceType(SourceTypeEnum.SRM.getValue());
        this.elsTaxService.saveElsTax(elsTax);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        this.redisUtil.dels(fixPreRedisKeyTax + TenantContext.getTenant() + ":els_tax_code");
        return Result.ok(elsTax);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsTax elsTax) {
        this.elsTaxService.updateElsTax(elsTax);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        this.redisUtil.dels(fixPreRedisKeyTax + TenantContext.getTenant() + ":els_tax_code");
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsTaxService.delElsTax(id);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        this.redisUtil.dels(fixPreRedisKeyTax + TenantContext.getTenant() + ":els_tax_code");
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsTaxService.delBatchElsTax(idList);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        this.redisUtil.dels(fixPreRedisKeyTax + TenantContext.getTenant() + ":els_tax_code");
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsTax elsTax = (ElsTax)this.elsTaxService.getById((Serializable)((Object)id));
        return Result.ok(elsTax);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u5bfc\u51faExcel", logType=2, operateType=6)
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsTax elsTax, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        String elsAccount = TenantContext.getTenant();
        elsTax.setElsAccount(elsAccount);
        QueryWrapper<ElsTax> queryWrapper = QueryGenerator.initQueryWrapper(elsTax, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, elsTax);
            queryWrapper.in((Object)"id", selectionList);
        }
        List elsTaxList = this.elsTaxService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u7a0e\u7387\u7a0e\u7801");
        mv.addObject("entity", ElsTax.class);
        mv.addObject("params", (Object)new ExportParams("\u7a0e\u7387\u7a0e\u7801", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u7a0e\u7387\u7a0e\u7801", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)elsTaxList);
        return mv;
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ElsTax.class);
    }

    @GetMapping(path={"/getTaxRateData"})
    public Result<?> getTaxRateData() {
        this.elsTaxService.getErpData("getTaxRateData");
        return Result.ok();
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", operateType=2)
    @ApiOperation(value="\u7a0e\u7387\u7a0e\u7801-\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u5c06100000\u53f7\u7684\u7a0e\u7387\u7a0e\u7801\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.elsTaxService.addToEnterprise(id);
        return Result.ok(2);
    }
}

