/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.beust.jcommander.internal.Lists;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.enums.MenuAttributeEnum;
import com.els.modules.system.mapper.CompanyPermissionMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.rpc.service.InvokeSupplierRpcService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.PermissionVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionServiceImpl
extends ServiceImpl<PermissionMapper, Permission>
implements PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private DictService dictService;
    @Value(value="${rocketmq.report.initReport}")
    private String initReport;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${rocketmq.reBuildSaleMenu.destination}")
    private String reBuildSaleMenu;
    @Resource
    private CompanyPermissionMapper companyPermissionMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<TreeModel> queryListByParentId(String parentId) {
        return this.permissionMapper.queryListByParentId(parentId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void deletePermission(String id) throws ELSBootException {
        int count;
        Permission sysPermission = (Permission)this.getById((Serializable)((Object)id));
        if (sysPermission == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuntVH_24eb9383", "\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f"));
        }
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty(pid) && (count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)pid))) == 1) {
            this.permissionMapper.setMenuLeaf(pid, 1);
        }
        this.permissionMapper.deleteById((Serializable)((Object)id));
        this.removeChildrenBy(sysPermission.getId());
    }

    public void removeChildrenBy(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Permission::getParentId, (Object)parentId);
        List permissionList = this.list((Wrapper)query);
        if (permissionList != null && permissionList.size() > 0) {
            String id = "";
            int num = 0;
            this.remove((Wrapper)query);
            int len = permissionList.size();
            for (int i = 0; i < len; ++i) {
                id = ((Permission)permissionList.get(i)).getId();
                num = this.count((Wrapper)new LambdaQueryWrapper().eq(Permission::getParentId, (Object)id));
                if (num <= 0) continue;
                this.removeChildrenBy(id);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void addPermission(Permission sysPermission) throws ELSBootException {
        String pid;
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId(null);
        }
        if (!MenuAttributeEnum.SALE.getCode().equals(sysPermission.getMenuAttribute())) {
            sysPermission.setPurchasePermissionId("");
        }
        if (ConvertUtils.isNotEmpty(pid = sysPermission.getParentId())) {
            this.permissionMapper.setMenuLeaf(pid, 0);
        }
        sysPermission.setCreateTime(new Date());
        sysPermission.setDeleted(CommonConstant.DEL_FLAG_0);
        sysPermission.setLeaf(true);
        this.save(sysPermission);
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void editPermission(Permission sysPermission) throws ELSBootException {
        int count;
        Permission p = (Permission)this.getById((Serializable)((Object)sysPermission.getId()));
        if (p == null) {
            throw new ELSBootException(I18nUtil.translate("", "\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f"));
        }
        sysPermission.setUpdateTime(new Date());
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId("");
        }
        if ((count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)sysPermission.getId()))) == 0) {
            sysPermission.setLeaf(true);
        }
        if (!MenuAttributeEnum.SALE.getCode().equals(sysPermission.getMenuAttribute())) {
            sysPermission.setPurchasePermissionId("");
        }
        this.updateById(sysPermission);
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty(pid) && !pid.equals(p.getParentId()) || ConvertUtils.isEmpty(pid) && ConvertUtils.isNotEmpty(p.getParentId())) {
            this.permissionMapper.setMenuLeaf(pid, 0);
            int cc = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)p.getParentId()));
            if (cc == 0 && ConvertUtils.isNotEmpty(p.getParentId())) {
                this.permissionMapper.setMenuLeaf(p.getParentId(), 1);
            }
        }
    }

    @Override
    public List<PermissionVO> queryByAccount(String elsAccount, String subAccount, Integer mobile) {
        return this.permissionMapper.queryByAccount(elsAccount, subAccount, mobile);
    }

    @Override
    public List<PermissionVO> queryByUser(String username) {
        return this.permissionMapper.queryAllByUser(username);
    }

    @Override
    @Cacheable(value={"sys:cache:permission:datarules"})
    public List<String> queryPermissionUrlWithStar() {
        return ((PermissionMapper)this.baseMapper).queryPermissionUrlWithStar();
    }

    @Override
    public List<PermissionVO> getCompanyMenuList(String elsAccount) {
        return ((PermissionMapper)this.baseMapper).getCompanyMenuList(elsAccount);
    }

    @Override
    public void editCompanyPermission(Permission permission) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        permission.setUpdateBy(sysUser.getSubAccount());
        permission.setUpdateTime(new Date());
        ((PermissionMapper)this.baseMapper).updateCompanyMeun(permission);
    }

    @Override
    public void saveCompanyPermission(String elsAccount, String permissionIds, String lastPermissionIds) {
        List<String> delete;
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        Date currentDate = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String currentUser = sysUser.getSubAccount();
        if (add != null && add.size() > 0) {
            ArrayList<CompanyPermission> list = new ArrayList<CompanyPermission>();
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            TenantContext.setTenant(elsAccount);
            Role role = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty(p)) continue;
                CompanyPermission permission = new CompanyPermission();
                permission.setId(IdWorker.getIdStr());
                permission.setPermissionId(p);
                permission.setElsAccount(elsAccount);
                permission.setCreateTime(currentDate);
                permission.setUpdateTime(currentDate);
                permission.setCreateBy(currentUser);
                permission.setUpdateBy(currentUser);
                permission.setDeleted(CommonConstant.DEL_FLAG_0);
                list.add(permission);
                if (role == null) continue;
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setPermissionId(p);
                rolePermission.setRoleId(role.getId());
                rolePermissionList.add(rolePermission);
            }
            if (!list.isEmpty()) {
                this.permissionMapper.insertCompanyMeunBatch(list);
            }
            if (!rolePermissionList.isEmpty()) {
                this.rolePermissionService.saveBatch(rolePermissionList);
            }
        }
        if (CollUtil.isNotEmpty(delete = this.getDiff(permissionIds, lastPermissionIds))) {
            this.permissionMapper.deleteCompanyMeunByAccountAndPermissionIds(delete, elsAccount);
            this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).in(RolePermission::getPermissionId, delete));
        }
        this.rebuildSaleMenu(Collections.singletonList(elsAccount), add, delete, "modify", null, null);
        if (!"100000".equals(elsAccount)) {
            this.shareReportMenuData(elsAccount);
        }
    }

    void shareReportMenuData(String elsAccount) {
        List<DictModel> dictDTOList = this.dictService.queryDictItemsByCode("srmReportDataMenu", "100000");
        List<String> collect = dictDTOList.stream().map(DictModel::getText).distinct().collect(Collectors.toList());
        List<RolePermission> permissions = this.rolePermissionService.selectWithoutElsAccountOfRolePermission(collect, elsAccount);
        List shareReportId = permissions.stream().map(RolePermission::getPermissionId).distinct().collect(Collectors.toList());
        List reportIdList = dictDTOList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictModel::getValue).collect(Collectors.toList());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("elsAccount", Arrays.asList(elsAccount));
        jsonObject.put("reportId", reportIdList);
        jsonObject.put("shareType", (Object)"report");
        Message message = MessageBuilder.withPayload((Object)jsonObject.toJSONString()).build();
        this.rocketMQTemplate.send((Object)this.initReport, message);
        log.info("\u53d1\u9001\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty(diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty(main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!ConvertUtils.isNotEmpty(key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }

    @Override
    @Transactional
    public void initAccountPermission(String elsAccount, String role) {
        String userId;
        List list;
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_APeyBjbWtkW_413583d2", "\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        List itemList = null;
        itemList = "purchase".equals(role) ? this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"})) : this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LERdRAcntWtkKmW_fb0e9fa1", "\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (Permission permission : itemList) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
            companyPermission.setCreateTime(currentTime);
            companyPermissionList.add(companyPermission);
        }
        this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
        this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
        TenantContext.setTenant(elsAccount);
        List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
        if (roleList.isEmpty()) {
            Role saveRole = new Role();
            saveRole.setId(IdWorker.getIdStr());
            saveRole.setElsAccount(elsAccount);
            saveRole.setRoleCode("companyAdmin");
            saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
            this.roleService.save(saveRole);
            roleList.add(saveRole);
        } else {
            for (Object ro : roleList) {
                this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro).getId()));
            }
        }
        ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
        for (Permission permission : itemList) {
            for (Role ro : roleList) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(ro.getId());
                rolePermission.setPermissionId(permission.getId());
                rolePermissionList.add(rolePermission);
            }
        }
        this.rolePermissionService.saveBatch(rolePermissionList);
        ElsSubAccount subAccount = this.elsSubAccountService.getByAccount(elsAccount, "1001");
        if (subAccount != null && (list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) {
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
    }

    @Override
    public void initAccountPermissionList(List<String> elsAccountList, String role) {
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_APeyBjbWtkW_413583d2", "\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        Map<String, List<String>> oldMenuMap = null;
        List<Permission> itemList = null;
        if ("purchase".equals(role)) {
            itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"}));
            List<CompanyPermission> permissionList = this.companyPermissionMapper.selectWithoutElsAccountToListAccountOldMenu(elsAccountList);
            oldMenuMap = permissionList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount, Collectors.mapping(CompanyPermission::getPermissionId, Collectors.toList())));
        } else {
            itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        }
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LERdRAcntWtkKmW_fb0e9fa1", "\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        Map<String, Set<String>> salePurchaseMap = SpringContextUtils.getBean(InvokeSupplierRpcService.class).selectWithoutElsAccountToLoadAllPurchaseBySale(elsAccountList);
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (String elsAccount : elsAccountList) {
            String userId;
            List list;
            Object ro2;
            if ("sale".equals(role)) {
                Set<String> purchaseAccountList = salePurchaseMap.get(elsAccount);
                if (purchaseAccountList.contains("100000")) {
                    purchaseAccountList.remove("100000");
                }
                if (CollUtil.isNotEmpty((Collection)purchaseAccountList) && CollUtil.isNotEmpty(itemList = this.permissionMapper.selectWithoutElsAccountToLoadExistSalePermission(purchaseAccountList))) {
                    Set<String> permissionIdList = itemList.stream().map(Permission::getId).collect(Collectors.toSet());
                    itemList.addAll(this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(permissionIdList));
                }
            }
            companyPermissionList.clear();
            for (Permission permission : itemList) {
                CompanyPermission companyPermission = new CompanyPermission();
                companyPermission.setId(IdWorker.getIdStr());
                companyPermission.setElsAccount(elsAccount);
                companyPermission.setPermissionId(permission.getId());
                companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermission.setCreateTime(currentTime);
                companyPermissionList.add(companyPermission);
            }
            this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
            this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
            TenantContext.setTenant(elsAccount);
            List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            if (roleList.isEmpty()) {
                Role saveRole = new Role();
                saveRole.setId(IdWorker.getIdStr());
                saveRole.setElsAccount(elsAccount);
                saveRole.setRoleCode("companyAdmin");
                saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                this.roleService.save(saveRole);
                roleList.add(saveRole);
            } else {
                for (Object ro2 : roleList) {
                    this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro2).getId()));
                }
            }
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            ro2 = itemList.iterator();
            while (ro2.hasNext()) {
                Permission permission = (Permission)ro2.next();
                for (Role ro3 : roleList) {
                    RolePermission rolePermission = new RolePermission();
                    rolePermission.setId(IdWorker.getIdStr());
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(ro3.getId());
                    rolePermission.setPermissionId(permission.getId());
                    rolePermissionList.add(rolePermission);
                }
            }
            this.rolePermissionService.saveBatch(rolePermissionList);
            ElsSubAccount subAccount = this.elsSubAccountService.getByAccount(elsAccount, "1001");
            if (subAccount == null || !(list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) continue;
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
        if ("purchase".equals(role)) {
            this.shareReportMenuDataByRole(elsAccountList);
            if (CollUtil.isNotEmpty(oldMenuMap)) {
                this.rebuildSaleMenu(elsAccountList, null, null, "init", oldMenuMap, itemList.stream().map(Permission::getId).distinct().collect(Collectors.toList()));
            }
        }
    }

    void shareReportMenuDataByRole(List<String> elsAccountList) {
        String elsAccount = elsAccountList.get(0);
        List<DictModel> dictDTOList = this.dictService.queryDictItemsByCode("srmReportDataMenu", "100000");
        List collect = dictDTOList.stream().map(DictModel::getText).distinct().collect(Collectors.toList());
        List permissions = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rolePermissionService.lambdaQuery().eq(RolePermission::getElsAccount, (Object)elsAccount)).in(RolePermission::getPermissionId, collect)).list();
        List shareReportId = permissions.stream().map(RolePermission::getPermissionId).distinct().collect(Collectors.toList());
        List reportIdList = dictDTOList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictModel::getValue).collect(Collectors.toList());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("elsAccount", elsAccountList);
        jsonObject.put("reportId", reportIdList);
        jsonObject.put("shareType", (Object)"report");
        Message message = MessageBuilder.withPayload((Object)jsonObject.toJSONString()).build();
        this.rocketMQTemplate.send((Object)this.initReport, message);
        log.info("\u53d1\u9001\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
    }

    @Override
    public Set<String> getAllOptPermission() {
        List permissionList = ((PermissionMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)"100000")).eq((Object)"menu_type", (Object)"2"));
        List list = permissionList.stream().map(Permission::getPerms).collect(Collectors.toList());
        ArrayList<String> resultList = new ArrayList<String>();
        for (String str : list) {
            if (StringUtils.isBlank((CharSequence)str)) continue;
            if (str.contains(";")) {
                List<String> itemList = Arrays.asList(str.split(";"));
                resultList.addAll(itemList);
                continue;
            }
            resultList.add(str);
        }
        return new HashSet<String>(resultList);
    }

    @Override
    public List<Permission> selectDefaultWithPurchase(String account) {
        List<String> purchaseIds = ((PermissionMapper)this.baseMapper).getCompanyMenuIdList(account);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper2.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CollUtil.isNotEmpty((Collection)purchaseIds), Permission::getPurchasePermissionId, (Collection)purchaseIds)).eq(CollUtil.isNotEmpty((Collection)purchaseIds), Permission::getElsAccount, (Object)"100000")).eq(Permission::getMenuAttribute, (Object)MenuAttributeEnum.SALE.getCode());
        })).or(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Permission::getMenuAttribute, (Object)MenuAttributeEnum.COMMON.getCode())).eq(Permission::getElsAccount, (Object)"100000");
        });
        List saleMenus = this.list((Wrapper)queryWrapper2);
        List<String> parentIds = saleMenus.stream().map(Permission::getParentId).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List ids = saleMenus.stream().map(Permission::getId).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        parentIds.removeAll(ids);
        if (CollUtil.isNotEmpty(parentIds)) {
            ArrayList<Permission> result = new ArrayList<Permission>();
            this.findParent(parentIds, 1, result);
            List collect = result.stream().filter(x -> !ids.contains(x.getId())).collect(Collectors.toList());
            saleMenus.addAll(collect);
        }
        if (CollUtil.isNotEmpty(saleMenus = saleMenus.stream().filter(x -> !MenuAttributeEnum.PURCHASE.getCode().equals(x.getMenuAttribute())).collect(Collectors.toList()))) {
            Set<String> permissionIdList = saleMenus.stream().map(Permission::getId).collect(Collectors.toSet());
            saleMenus.addAll(this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(permissionIdList));
        }
        return saleMenus.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Permission>(Comparator.comparing(Permission::getId))), ArrayList::new));
    }

    private void findParent(List<String> parentIds, Integer level, List<Permission> result) {
        if (level > 6) {
            return;
        }
        if (CollUtil.isNotEmpty(parentIds)) {
            List permissions = this.listByIds(parentIds);
            result.addAll(permissions);
            List<String> temParentIds = permissions.stream().map(Permission::getParentId).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            this.findParent(temParentIds, level, result);
        }
    }

    private void rebuildSaleMenu(List<String> elsAccountList, List<String> add, List<String> delete, String type, Map<String, List<String>> oldMenuMap, List<String> newMenuList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("elsAccount", elsAccountList);
        jsonObject.put("add", add);
        jsonObject.put("delete", delete);
        jsonObject.put("type", (Object)type);
        jsonObject.put("oldMenuMap", oldMenuMap);
        jsonObject.put("newMenuList", newMenuList);
        jsonObject.put("level", (Object)1);
        this.rocketMQTemplate.syncSend(this.reBuildSaleMenu, MessageBuilder.withPayload((Object)jsonObject.toJSONString()).build());
    }

    private List<String> getDiffPermissionId(List<String> newPermissionList, List<String> oldPermissionList) {
        if (CollUtil.isEmpty(oldPermissionList)) {
            return newPermissionList;
        }
        if (CollUtil.isEmpty(newPermissionList)) {
            return Collections.emptyList();
        }
        List list = Lists.newArrayList(newPermissionList);
        list.removeAll(oldPermissionList);
        return list;
    }

    private void reBuildInitSaleMenu(JSONObject body) {
        List elsAccountList = body.getJSONArray("elsAccount").toJavaList(String.class);
        log.info(":::\u521d\u59cb\u5316\u91c7\u8d2d\u83dc\u5355,\u66f4\u6539\u5bf9\u5e94\u9500\u552e\u83dc\u5355:{}", (Object)elsAccountList);
        List newMenuListId = body.getJSONArray("newMenuList").toJavaList(String.class);
        JSONObject oldMenuMap = body.getJSONObject("oldMenuMap");
        elsAccountList.forEach(x -> oldMenuMap.putIfAbsent(x, Collections.emptyList()));
        for (String elsAccount : oldMenuMap.keySet()) {
            List oldMenuList = oldMenuMap.getJSONArray(elsAccount).toJavaList(String.class);
            this.buildSaleMenu(elsAccount, this.getDiffPermissionId(newMenuListId, oldMenuList), this.getDiffPermissionId(oldMenuList, newMenuListId));
        }
    }

    private void reBuildModifySaleMenu(JSONObject body) {
        List elsAccountList = body.getJSONArray("elsAccount").toJavaList(String.class);
        log.info(":::\u66f4\u6539\u5355\u4e2a\u91c7\u8d2d\u83dc\u5355,\u66f4\u6539\u5bf9\u5e94\u9500\u552e\u83dc\u5355:{}", (Object)elsAccountList);
        List addList = body.getJSONArray("add").toJavaList(String.class);
        List deleteList = body.getJSONArray("delete").toJavaList(String.class);
        String elsAccount = (String)elsAccountList.get(0);
        this.buildSaleMenu(elsAccount, addList, deleteList);
    }

    private void buildSaleMenu(String elsAccount, List<String> addList, List<String> deleteList) {
        List<String> addSaleMenuList;
        List<String> toElsAccountList = SpringContextUtils.getBean(InvokeSupplierRpcService.class).selectWithoutElsAccountToListSupplierMasterData(elsAccount);
        toElsAccountList.remove(elsAccount);
        if (toElsAccountList.isEmpty()) {
            return;
        }
        if (CollUtil.isNotEmpty(deleteList)) {
            Map<String, Set<String>> salePurchaseMap = SpringContextUtils.getBean(InvokeSupplierRpcService.class).selectWithoutElsAccountToLoadAllPurchaseBySale(toElsAccountList);
            List<String> deleteSaleMenuList = this.loadSalePermissionByPurchase(deleteList);
            List<Object> deleteSaleButtonList = new ArrayList();
            if (CollUtil.isNotEmpty(deleteSaleMenuList)) {
                List<Permission> permissionList = this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(new HashSet<String>(deleteSaleMenuList));
                deleteSaleButtonList = permissionList.stream().map(Permission::getId).distinct().collect(Collectors.toList());
            }
            if (!deleteSaleMenuList.isEmpty()) {
                ArrayList<Map<String, Object>> deleteMap = new ArrayList<Map<String, Object>>(toElsAccountList.size());
                for (String saleAccount : toElsAccountList) {
                    Set<String> purchaseAccountList = salePurchaseMap.get(saleAccount);
                    if (CollUtil.isEmpty(purchaseAccountList) || purchaseAccountList.size() == 1 && purchaseAccountList.contains(elsAccount)) {
                        HashMap<String, Object> map = new HashMap<String, Object>(2);
                        map.put("elsAccount", saleAccount);
                        deleteSaleMenuList.addAll(deleteSaleButtonList);
                        map.put("permissionIds", deleteSaleMenuList);
                        deleteMap.add(map);
                        continue;
                    }
                    purchaseAccountList.remove(elsAccount);
                    List<String> existSaleIds = this.permissionMapper.selectWithoutElsAccountToLoadExistSalePermissionId(purchaseAccountList);
                    List temDeleteList = Lists.newArrayList(deleteSaleMenuList);
                    temDeleteList.removeAll(existSaleIds);
                    if (temDeleteList.isEmpty()) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("elsAccount", saleAccount);
                    List<Permission> permissionList = this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(new HashSet<String>(temDeleteList));
                    temDeleteList.addAll(permissionList.stream().map(Permission::getId).distinct().collect(Collectors.toList()));
                    map.put("permissionIds", temDeleteList);
                    deleteMap.add(map);
                }
                if (CollUtil.isNotEmpty(deleteMap)) {
                    this.batchRemoveSalePermission(deleteMap);
                }
            }
        }
        if (CollUtil.isNotEmpty(addList) && !(addSaleMenuList = this.loadSalePermissionByPurchase(addList)).isEmpty()) {
            List<Object> addSaleButtonList = new ArrayList();
            List<Permission> permissionList = this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(new HashSet<String>(addSaleMenuList));
            addSaleButtonList = permissionList.stream().map(Permission::getId).distinct().collect(Collectors.toList());
            addSaleMenuList.addAll(addSaleButtonList);
            this.addSalePermission(toElsAccountList, addSaleMenuList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rebuildSaleMenuByMsg(JSONObject body) {
        log.info("::: \u51c6\u5907\u5f00\u59cb\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355...");
        String type = body.getString("type");
        if ("init".equals(type)) {
            this.reBuildInitSaleMenu(body);
        } else {
            this.reBuildModifySaleMenu(body);
        }
        log.info("::: \u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u7ed3\u675f...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadSalePermissionByPurchase(List<String> permissionId) {
        TenantContext.setTenant("100000");
        List partition = com.google.common.collect.Lists.partition(permissionId, (int)500);
        try {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{Permission::getId});
            for (List list : partition) {
                wrapper.or(i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Permission::getElsAccount, (Object)"100000")).in(Permission::getPurchasePermissionId, (Collection)list);
                });
            }
            List saleMenu = ((PermissionMapper)this.baseMapper).selectList((Wrapper)wrapper);
            List<String> list = saleMenu.stream().map(Permission::getId).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            TenantContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadExistCompanyPermission(String account, List<String> addList) {
        TenantContext.setTenant(account);
        try {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{CompanyPermission::getPermissionId});
            ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)account)).in(CompanyPermission::getPermissionId, addList);
            List permissions = this.companyPermissionMapper.selectList((Wrapper)wrapper);
            List<String> list = permissions.stream().map(CompanyPermission::getPermissionId).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            TenantContext.clear();
        }
    }

    private void batchRemoveSalePermission(List<Map<String, Object>> deleteMap) {
        log.info(":::\u5220\u9664\u9500\u552e\u83dc\u5355\u6743\u9650:{}", JSON.toJSON(deleteMap));
        List partition = com.google.common.collect.Lists.partition(deleteMap, (int)1500);
        for (List list : partition) {
            this.permissionMapper.batchDeleteCompanyMeunByAccountAndPermissionIds(list);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            for (Map map : list) {
                updateWrapper.or(i -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)i.eq(RolePermission::getElsAccount, map.get("elsAccount"))).in(RolePermission::getPermissionId, (Collection)((List)map.get("permissionIds")));
                });
            }
            this.rolePermissionService.remove((Wrapper)updateWrapper);
        }
    }

    private void removeSalePermission(String account, List<String> deleteSaleMenuList) {
        log.info(":::\u4f9b\u5e94\u5546{}\u5220\u9664\u9500\u552e\u83dc\u5355\u6743\u9650:{}", (Object)account, deleteSaleMenuList);
        this.permissionMapper.deleteCompanyMeunByAccountAndPermissionIds(deleteSaleMenuList, account);
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)deleteWrapper.eq(RolePermission::getElsAccount, (Object)account)).in(RolePermission::getPermissionId, deleteSaleMenuList);
        this.rolePermissionService.remove((Wrapper)deleteWrapper);
    }

    private void addSalePermission(List<String> toElsAccountList, List<String> addList) {
        log.info(":::\u4f9b\u5e94\u5546{}\u6dfb\u52a0\u9500\u552e\u83dc\u5355\u6743\u9650:{}", toElsAccountList, addList);
        Map<String, String> adminRoleMap = this.roleService.loadAdminRole(toElsAccountList);
        Date currentDate = new Date();
        ArrayList<CompanyPermission> temCpList = new ArrayList<CompanyPermission>();
        ArrayList<RolePermission> temRpList = new ArrayList<RolePermission>();
        for (String account : toElsAccountList) {
            List temMenu = Lists.newArrayList(addList);
            List<String> existPermissionIds = this.loadExistCompanyPermission(account, temMenu);
            temMenu.removeAll(existPermissionIds);
            if (temMenu.isEmpty()) continue;
            for (String permissionId : temMenu) {
                CompanyPermission permission = new CompanyPermission();
                permission.setId(IdWorker.getIdStr());
                permission.setPermissionId(permissionId);
                permission.setElsAccount(account);
                permission.setCreateTime(currentDate);
                permission.setUpdateTime(currentDate);
                permission.setCreateBy("admin");
                permission.setUpdateBy("admin");
                permission.setDeleted(CommonConstant.DEL_FLAG_0);
                temCpList.add(permission);
                if (!adminRoleMap.containsKey(account)) continue;
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setElsAccount(account);
                rolePermission.setPermissionId(permissionId);
                rolePermission.setRoleId(adminRoleMap.get(account));
                temRpList.add(rolePermission);
            }
        }
        if (!temCpList.isEmpty()) {
            this.permissionMapper.insertCompanyMeunBatch(temCpList);
        }
        if (!temRpList.isEmpty()) {
            this.rolePermissionService.saveBatch(temRpList);
        }
        if (CollUtil.isNotEmpty(adminRoleMap)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{UserRole::getUserId});
            wrapper.in(UserRole::getRoleId, adminRoleMap.values());
            List userRoleList = this.userRoleService.list((Wrapper)wrapper);
            userRoleList.forEach(r -> this.redisUtil.del("shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + r.getUserId()));
        }
    }
}

