/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.SysUserCacheInfo;
import com.els.common.util.ConvertUtils;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.entity.ElsPasswordRecord;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordRecordMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.AccountDeliverToService;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPwComplexityAndMinLenVo;
import com.els.modules.system.vo.PermissionVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsSubAccountServiceImpl
extends ServiceImpl<ElsSubAccountMapper, ElsSubAccount>
implements ElsSubAccountService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private ElsPasswordSecurityMapper pwSecurityMapper;
    @Resource
    private ElsPasswordRecordMapper pwRecordMapper;
    @Resource
    private ElsPasswordPolicyMapper pwPolicyMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ISysBaseAPI baseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CompanyInterfaceConfigItemService companyInterfaceConfigItemService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    private void pwComplexityAndLenVerify(String elsAccount, String pwString) {
        ElsPwComplexityAndMinLenVo complexityAndMinLenVo = this.pwSecurityMapper.getComplexityAndMinLen(elsAccount);
        if (complexityAndMinLenVo == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)complexityAndMinLenVo.getComplexity())) {
            PwVerifyUtil.pwComplexityVerify((Map)JSONObject.parseObject((String)complexityAndMinLenVo.getComplexity(), HashMap.class), pwString);
        }
        PwVerifyUtil.pwMinLengthVerify(pwString, complexityAndMinLenVo.getMinLength());
    }

    private void addPwUpdateRecord(String elsAccount, String elsSubAccount, String userName, String loginSubAccount) {
        ElsPasswordRecord elsPasswordRecord = new ElsPasswordRecord();
        Date now = new Date();
        elsPasswordRecord.setElsSubAccount(elsSubAccount).setUserName(userName).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setUpdateBy(loginSubAccount).setCreateTime(now).setUpdateTime(now);
        this.pwRecordMapper.insert(elsPasswordRecord);
    }

    private void updatePwPolicy(String elsAccount, String elsSubAccount, String userName, String loginSubAccount, Date pwCreateDate) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordPolicy::getElsSubAccount, (Object)elsSubAccount);
        ElsPasswordPolicy record = (ElsPasswordPolicy)this.pwPolicyMapper.selectOne((Wrapper)lambdaQueryWrapper);
        ElsPasswordPolicy elsPasswordPolicy = new ElsPasswordPolicy();
        Date now = new Date();
        if (record != null) {
            elsPasswordPolicy.setChangeTime((record.getChangeTime() == null ? 0 : record.getChangeTime()) + 1).setUpdateBy(loginSubAccount).setUpdateTime(now);
            this.pwPolicyMapper.update(elsPasswordPolicy, (Wrapper)lambdaQueryWrapper);
            return;
        }
        elsPasswordPolicy.setElsSubAccount(elsSubAccount).setUserName(userName).setPasswordCreateDate(pwCreateDate).setChangeTime(0).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setCreateTime(now).setUpdateBy(loginSubAccount).setUpdateTime(now);
        this.pwPolicyMapper.insert(elsPasswordPolicy);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> resetPassword(String subAccount, String oldpassword, String newpassword, String confirmpassword) {
        ElsSubAccount user = this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
        String passwordEncode = PasswordUtil.encrypt(TenantContext.getTenant() + "_" + subAccount, oldpassword, user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error(I18nUtil.translate("i18n_alert_OwoWNNSW_29bef277", "\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!"));
        }
        if (ConvertUtils.isEmpty(newpassword)) {
            return Result.error(I18nUtil.translate("i18n_alert_VwoxiTLVW_5c8c5208", "\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        }
        if (oldpassword.equals(newpassword)) {
            return Result.error(I18nUtil.translate("i18n_alert_VwoxOUOwoIRW_aaf98fe", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u4e00\u81f4!"));
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error(I18nUtil.translate("i18n_alert_RmWNwoxIR_5a67fad7", "\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!"));
        }
        this.pwComplexityAndLenVerify(TenantContext.getTenant(), newpassword);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.addPwUpdateRecord(TenantContext.getTenant(), subAccount, user.getRealname(), sysUser.getSubAccount());
        this.updatePwPolicy(TenantContext.getTenant(), subAccount, user.getRealname(), sysUser.getSubAccount(), user.getCreateTime());
        String password = PasswordUtil.encrypt(TenantContext.getTenant() + "_" + subAccount, newpassword, user.getSalt());
        this.userMapper.update(new ElsSubAccount().setPassword(password), (Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)user.getId()));
        return Result.ok(I18nUtil.translate("i18n_alert_wosRLRW_ca627356", "\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<?> changePassword(ElsSubAccount account) {
        this.pwComplexityAndLenVerify(TenantContext.getTenant(), account.getPassword());
        String salt = ConvertUtils.randomGen(8);
        account.setSalt(salt);
        String password = account.getPassword();
        String passwordEncode = PasswordUtil.encrypt(account.getElsAccount() + "_" + account.getSubAccount(), password, salt);
        account.setPassword(passwordEncode);
        this.userMapper.updateById(account);
        return Result.ok(I18nUtil.translate("i18n_alert_wocrLRW_1e3a7b4c", "\u5bc6\u7801\u4fee\u6539\u6210\u529f!"));
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public ElsSubAccount getUserBySubAccount(String subAccount) {
        return this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
    }

    @Override
    public ElsSubAccount getUserByAccount(String account) {
        return this.userMapper.getUserByAccount(account);
    }

    @Override
    @Transactional
    public ElsSubAccount addUserWithRole(ElsSubAccount user, String roles) {
        this.save(user);
        this.insertRole(user, roles);
        return user;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional
    public void editUserWithRole(ElsSubAccount user, String roles) {
        List roleList = this.roleService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Role::getElsAccount, (Object)user.getElsAccount())).eq(Role::getRoleCode, (Object)"companyAdmin"));
        Assert.notEmpty((Collection)roleList, (String)(I18nUtil.translate("i18n_alert_AEslTMKRvjWWWWWWKy_325f6a36", "\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272") + "companyAdmin"));
        String roleId = ((Role)roleList.get(0)).getId();
        if (!("," + roles + ",").contains("," + roleId + ",")) {
            List userRoles = this.userRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(UserRole::getRoleId, (Object)roleId));
            Assert.notEmpty((Collection)userRoles, (String)I18nUtil.translate("i18n_alert_AEslTMKRvjWWWWWWKy_325f6a36", "\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272"));
        }
        this.updateById(user);
        this.userRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)user.getId()));
        this.redisUtil.del("ELSACCOUNT_SUBACCOUNT" + user.getElsAccount() + user.getSubAccount());
        this.insertRole(user, roles);
    }

    private void insertRole(ElsSubAccount user, String roles) {
        if (ConvertUtils.isNotEmpty(roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                UserRole userRole = new UserRole(user.getId(), roleId);
                this.userRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        List<String> roles = this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------account\uff1a " + elsAccount + "_" + subAccount + ",Roles size: " + roles.size());
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String account) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<PermissionVO> permissionList = this.permissionMapper.queryByAccount(account.split("_")[0], account.split("_")[1], 0);
        for (PermissionVO po : permissionList) {
            if (!ConvertUtils.isNotEmpty(po.getPerms())) continue;
            if (po.getPerms().contains(";")) {
                List<String> itemList = Arrays.asList(po.getPerms().split(";"));
                permissionSet.addAll(itemList);
                continue;
            }
            permissionSet.add(po.getPerms());
        }
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u6743\u9650Perms------account\uff1a " + account + ",Perms size: " + permissionSet.size());
        return permissionSet;
    }

    @Override
    public SysUserCacheInfo getCacheUser(String account) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.baseAPI.getUserByAccount(account);
        if (user != null) {
            info.setSysUserCode(user.getSubAccount());
            info.setSysUserName(user.getRealname());
            info.setSysOrgCode(user.getOrgCode());
        }
        return info;
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepId(Page<ElsSubAccount> page, String departId, String username) {
        return this.userMapper.getUserByDepId(page, departId, username);
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepartIdAndQueryWrapper(Page<ElsSubAccount> page, String departId, QueryWrapper<ElsSubAccount> queryWrapper) {
        LambdaQueryWrapper lambdaQueryWrapper = queryWrapper.lambda();
        lambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        lambdaQueryWrapper.inSql(BaseEntity::getId, "SELECT user_id FROM sys_user_depart WHERE dep_id = '" + departId + "'");
        return this.userMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    @Override
    public IPage<ElsSubAccount> getUserByRoleId(Page<ElsSubAccount> page, String roleId, String username) {
        return this.userMapper.getUserByRoleId(page, roleId, username);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, key="#username")
    public void updateUserDepart(String username, String orgCode) {
        ((ElsSubAccountMapper)this.baseMapper).updateUserDepart(username, orgCode);
    }

    @Override
    public ElsSubAccount getUserByPhone(String phone) {
        return this.userMapper.getUserByPhone(phone);
    }

    @Override
    public ElsSubAccount getBindPhoneByPhoneAndAccount(String elsAccount, String subAccount, String phone) {
        return this.userMapper.getBindPhoneByPhoneAndAccount(elsAccount, subAccount, phone);
    }

    @Override
    public ElsSubAccount getUserByEmail(String email) {
        return this.userMapper.getUserByEmail(email);
    }

    @Override
    public ElsSubAccount getBindEmailByEmailAndAccount(String elsAccount, String subAccount, String email) {
        return this.userMapper.getBindEmailByEmailAndAccount(elsAccount, subAccount, email);
    }

    @Override
    public Result<?> checkUserIsEffective(ElsSubAccount account) {
        Result result = new Result();
        if (account == null) {
            result.error500(I18nUtil.translate("i18n_alert_rjDxMKWVdi_533e2538", "\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c"));
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", 1, null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(account.getDeleted())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u6ce8\u9500\uff01", 1, null);
            result.error500(I18nUtil.translate("i18n_alert_rjDIdXW_d3c8a06b", "\u8be5\u7528\u6237\u5df2\u6ce8\u9500"));
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u51bb\u7ed3\uff01", 1, null);
            result.error500(I18nUtil.translate("i18n_alert_rjDIOyW_d35fed0b", "\u8be5\u7528\u6237\u5df2\u6ce8\u9500"));
            return result;
        }
        if (null != account.getAccountValidityDate() && System.currentTimeMillis() > account.getAccountValidityDate().getTime()) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff01", 1, null);
            result.error500(I18nUtil.translate("i18n_alert_LjeDIRjXAWWdVVKHRvjW_2e44c8f3", "\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            return result;
        }
        return result;
    }

    @Override
    public ElsSubAccount getByAccount(String elsAccount, String subAccount) {
        return this.userMapper.getUserByAccount(elsAccount + "_" + subAccount);
    }

    @Override
    public Map<String, String> getLogoSetByElsAccount(String elsAccount) {
        return this.userMapper.getLogoSetByElsAccount(elsAccount);
    }

    @Override
    @Transactional
    public void deliverTo(String sourceAccountId, String targetAccountId) {
        String[] beans;
        ElsSubAccount sourceAccount = (ElsSubAccount)this.getById((Serializable)((Object)sourceAccountId));
        ElsSubAccount targetAccount = (ElsSubAccount)this.getById((Serializable)((Object)targetAccountId));
        for (String bean : beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AccountDeliverToService.class)) {
            AccountDeliverToService service = (AccountDeliverToService)SpringContextUtils.getBean(bean);
            service.deliverTo(sourceAccount, targetAccount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createUserIfNotExist(ElsSubAccount account) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant(account.getElsAccount());
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId});
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)account.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)account.getSubAccount())).last(" limit 1");
            ElsSubAccount elsSubAccount = (ElsSubAccount)((ElsSubAccountMapper)this.baseMapper).selectOne((Wrapper)wrapper);
            if (null != elsSubAccount) {
                account.setId(elsSubAccount.getId());
                boolean bl = true;
                return bl;
            }
            this.save(account);
            boolean bl = false;
            return bl;
        }
        finally {
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant(tenant);
            } else {
                TenantContext.clear();
            }
        }
    }

    @Override
    public List<ElsSubAccount> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return ((ElsSubAccountMapper)this.baseMapper).selectWithoutElsAccountByElsSubAccount(elsSubAccountList);
    }

    @Override
    public List<ElsSubAccount> getAccountList(String elsAccount, List<String> subAccounts) {
        return ((ElsSubAccountMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(ElsSubAccount::getSubAccount, subAccounts));
    }

    @Override
    public void getSubAccountFormERP() {
        String elsAccount = TenantContext.getTenant();
        List<String> codes = Arrays.asList("getAccount");
        ArrayList<CompanyInterfaceConfigItem> configItemList = new ArrayList<CompanyInterfaceConfigItem>();
        for (String code : codes) {
            configItemList.addAll(this.companyInterfaceConfigItemService.getConfig(elsAccount, code));
        }
        if (CollectionUtils.isEmpty(configItemList)) {
            return;
        }
        JSONObject custom = new JSONObject();
        custom.put("elsAccount", (Object)elsAccount);
        for (CompanyInterfaceConfigItem item : configItemList) {
            JSONObject param = new JSONObject();
            param.put("bus_account", (Object)elsAccount);
            param.put("srm_interface_code", (Object)item.getSrmInterfaceCode());
            this.interfaceUtil.callInterface(elsAccount, item.getCompanyCode(), param, (Object)custom);
        }
    }

    @Override
    public List<ElsSubAccount> findAccountByElsAccountId(String elsAccount, String sourceSystem) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        if (StringUtils.isBlank((CharSequence)sourceSystem)) {
            wrapper.isNotNull(ElsSubAccount::getSourceId);
            wrapper.ne(ElsSubAccount::getSourceId, (Object)"");
        } else {
            wrapper.eq(ElsSubAccount::getSourceSystem, (Object)sourceSystem);
        }
        return this.list((Wrapper)wrapper);
    }
}

