/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enums.SourceTypeEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.handler.ErrorExcelHandlerService;
import com.els.modules.system.service.ElsTaxService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ElsTaxService elsTaxService;

    @Override
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<ElsTax> datas = new ArrayList<ElsTax>();
        for (Map<String, Object> data : dataList) {
            ElsTax elsTax = (ElsTax)JSON.parseObject((String)JSON.toJSONString(data), ElsTax.class);
            datas.add(elsTax);
        }
        QueryWrapper wrapper1 = Wrappers.query();
        wrapper1.lambda().select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxRate});
        wrapper1.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List dbCodeList = this.elsTaxService.list((Wrapper)wrapper1).stream().map(x -> x.getTaxCode() + "_" + x.getTaxRate()).collect(Collectors.toList());
        for (int i = totalCount - 1; i >= 0; --i) {
            ElsTax entity = (ElsTax)datas.get(i);
            if (CharSequenceUtil.isEmpty((CharSequence)entity.getTaxCode())) {
                datas.remove(i);
                continue;
            }
            if (entity.getTaxRate() == null) {
                datas.remove(i);
                continue;
            }
            try {
                Integer.parseInt(Integer.toString(entity.getTaxRate()));
            }
            catch (Exception e) {
                datas.remove(i);
                continue;
            }
            if (dbCodeList.contains(entity.getTaxCode() + "_" + entity.getTaxRate())) {
                datas.remove(i);
                continue;
            }
            dbCodeList.add(entity.getTaxCode() + "_" + entity.getTaxRate());
            entity.setSourceType(SourceTypeEnum.EXCEL.getValue());
        }
        if (CollectionUtil.isNotEmpty(datas)) {
            this.elsTaxService.saveBatch(datas);
        }
        return dataList;
    }
}

