/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.system.handler.ErrorExcelHandler;
import com.els.modules.system.util.ExcelRedisKeyGenerateUtil;
import com.els.modules.system.util.I18nUtil;
import java.util.Map;

public class ErrorExcelHandlerService {
    public boolean errorHandle(boolean apply, ExcelImportDTO excelImportDTO, String elsAccount, int totalCount) {
        if (apply && !excelImportDTO.getErrorDataList().isEmpty()) {
            ErrorExcelHandler.handleData(excelImportDTO.getErrorExcelRunnerId(), excelImportDTO.getExcelBusinessOptType(), excelImportDTO.getExcelBusinessOptTypeName(), CharSequenceUtil.isBlank((CharSequence)elsAccount) ? TenantContext.getTenant() : elsAccount, excelImportDTO.getErrorTitleList(), excelImportDTO.getErrorDataList());
        }
        int successCount = totalCount - excelImportDTO.getErrorDataList().size();
        String key = ExcelRedisKeyGenerateUtil.generateImportSuccessCountKey(excelImportDTO.getExcelBusinessOptType(), excelImportDTO.getErrorExcelRunnerId());
        SpringContextUtils.getBean(RedisUtil.class).set(key, successCount, 3600L);
        return true;
    }

    public String getErrorTitle() {
        return I18nUtil.translate("i18n_alert_NSyRtH_5be59584", "\u9519\u8bef\u7ed3\u679c\u8bb0\u5f55");
    }

    public String getErrorStatus() {
        return I18nUtil.translate("i18n_alert_GvzE_2a38a70d", "\u5904\u7406\u72b6\u6001");
    }

    public void errorAdd(ExcelImportDTO excelImportDTO, String msg, Map<String, Object> data) {
        data.put(this.getErrorStatus(), "\u5bfc\u5165\u5931\u8d25");
        data.put(this.getErrorTitle(), msg);
        excelImportDTO.getErrorDataList().add(data);
    }

    @Deprecated
    public void errorAdd(ExcelImportDTO excelImportDTO, String msg, String errorTitle, Map<String, Object> data) {
        if (!excelImportDTO.getErrorTitleList().contains(this.getErrorTitle())) {
            excelImportDTO.getErrorTitleList().add(this.getErrorTitle());
            data.put(this.getErrorStatus(), "\u5bfc\u5165\u5931\u8d25");
        }
        if (!excelImportDTO.getErrorTitleList().contains(errorTitle)) {
            excelImportDTO.getErrorTitleList().add(errorTitle);
        }
        data.put(this.getErrorTitle(), msg);
        excelImportDTO.getErrorDataList().add(data);
    }
}

