/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.mapper.PersonalSettingMapper;
import com.els.modules.system.service.PersonalSettingService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonalSettingServiceImpl
extends ServiceImpl<PersonalSettingMapper, PersonalSetting>
implements PersonalSettingService {
    @Autowired
    private PersonalSettingMapper personalSettingMapper;

    @Override
    public boolean insert(PersonalSetting personalSetting) {
        return this.personalSettingMapper.insertPersonalSetting(personalSetting);
    }

    @Override
    public boolean deleteBySubAccount(String elsAccount, String subAccount, String receiveType) {
        return this.personalSettingMapper.deleteBySubAccount(elsAccount, subAccount, receiveType);
    }

    @Override
    public List<PersonalSetting> querySettingBySubAccount(String elsAccount, String subAccount) {
        return this.personalSettingMapper.querySettingBySubAccount(elsAccount, subAccount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNewSetting(String elsAccount, String subAccount, PersonalSetting personalSetting) {
        String receiveType = personalSetting.getReceiveType();
        this.personalSettingMapper.deleteBySubAccount(elsAccount, subAccount, receiveType);
        personalSetting.setId(IdWorker.getIdStr());
        personalSetting.setElsAccount(elsAccount);
        personalSetting.setSubAccount(subAccount);
        personalSetting.setCreateBy(subAccount);
        personalSetting.setCreateTime(new Date());
        personalSetting.setUpdateBy(subAccount);
        personalSetting.setUpdateTime(new Date());
        this.personalSettingMapper.insertPersonalSetting(personalSetting);
    }

    @Override
    public void saveSetting(String elsAccount, String subAccount) {
        List<PersonalSetting> personalSettingList = this.buildPersonalSetting(elsAccount, subAccount);
        LambdaQueryWrapper settingWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)settingWrapper.select(new SFunction[]{PersonalSetting::getReceiveType}).eq(PersonalSetting::getElsAccount, (Object)elsAccount)).eq(PersonalSetting::getSubAccount, (Object)subAccount)).groupBy(PersonalSetting::getReceiveType);
        List receiveTypeList = this.list((Wrapper)settingWrapper);
        if (CollUtil.isNotEmpty((Collection)receiveTypeList)) {
            List receiveTypeStr = receiveTypeList.stream().map(PersonalSetting::getReceiveType).distinct().collect(Collectors.toList());
            personalSettingList = personalSettingList.stream().filter(p -> !receiveTypeStr.contains(p.getReceiveType())).collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(personalSettingList)) {
            this.saveBatch(personalSettingList);
        }
    }

    public List<PersonalSetting> buildPersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "WECHAT_EP", "DINGTALK", "FEISHU");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        return personalSettings;
    }
}

