/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.export.base;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.Dict;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.dict.service.AutoPoiDictServiceI;
import com.els.framework.poi.excel.ExcelExportUtil;
import com.els.framework.poi.excel.annotation.Excel;
import com.els.framework.poi.excel.annotation.ExcelCollection;
import com.els.framework.poi.excel.annotation.ExcelEntity;
import com.els.framework.poi.excel.entity.ExportFieldAnalysisParams;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.handler.inter.IExcelDataHandler;
import com.els.framework.poi.util.PoiPublicUtil;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.UserColumnDefineService;
import com.els.modules.system.vo.UserColumnDefineVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;

public class ExportBase {
    protected IExcelDataHandler dataHanlder;
    protected List<String> needHanlderList;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    private ExcelExportEntity createExcelExportEntity(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(excel.type());
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfDefineColumn(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods, UserColumnDefineVO column) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        if (null != excel) {
            excelEntity.setType(excel.type());
            this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
            if (null != column && null != column.getSort()) {
                excelEntity.setOrderNum(column.getSort());
            }
            if (null != column && StrUtil.isNotBlank((CharSequence)column.getColumnName())) {
                excelEntity.setName(this.getExcelName(column.getColumnName(), targetId));
            }
        } else {
            excelEntity.setType(1);
            this.getExcelFieldWithoutExcelAnnotation(targetId, field, excelEntity, column, pojoClass);
        }
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        excelEntity.setFieldType(column.getFieldType());
        excelEntity.setDataFormat(column.getDataFormat());
        excelEntity.setDictCode(column.getDictCode());
        return excelEntity;
    }

    private void getExcelFieldWithoutExcelAnnotation(String targetId, Field field, ExcelExportEntity excelEntity, UserColumnDefineVO column, Class<?> pojoClass) throws Exception {
        Excel excel = ExcelAnnotation.class.getDeclaredField("excel").getAnnotation(Excel.class);
        excelEntity.setName(this.getExcelName(column.getColumnName(), targetId));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(column.getSort()), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        String format = excel.exportFormat();
        try {
            if (field.getType().newInstance() instanceof Date && StrUtil.isBlank((CharSequence)format)) {
                format = "yyyy-MM-dd HH:mm:ss";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        excelEntity.setFormat(format);
        excelEntity.setStatistics(excel.isStatistics());
        excelEntity.setMethod(PoiPublicUtil.getMethod(field.getName(), pojoClass, excel.exportConvert()));
        excelEntity.setMultiReplace(excel.multiReplace());
    }

    private Object formatValue(Object value, ExcelExportEntity entity) throws Exception {
        SimpleDateFormat format;
        Date temp = null;
        if (value instanceof String) {
            format = new SimpleDateFormat(entity.getDatabaseFormat());
            temp = format.parse(value.toString());
        } else if (value instanceof Date) {
            temp = (Date)value;
        }
        if (temp != null) {
            format = new SimpleDateFormat(entity.getFormat());
            value = format.format(temp);
        }
        return value;
    }

    public void getAllExcelField(String[] exclusions, String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        int i;
        boolean exist;
        List<String> exclusionsList = exclusions != null ? Arrays.asList(exclusions) : null;
        HashMap defineColumnList = Maps.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)fieldAnalysisParams.getDefineColumn())) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            if (StringUtils.isEmpty((String)TenantContext.getTenant())) {
                TenantContext.setTenant(sysUser.getElsAccount());
            }
            List<UserColumnDefineVO> userColumnDefine = SpringContextUtils.getBean(UserColumnDefineService.class).getUserColumnDefine(sysUser.getId(), fieldAnalysisParams.getDefineColumn());
            int size = userColumnDefine.size();
            for (int index = 0; index < size; ++index) {
                UserColumnDefineVO defineVO = userColumnDefine.get(index);
                if (defineVO.getHidden() != 0) continue;
                String columnCode = defineVO.getColumnCode();
                defineVO.setColumnCode(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
                defineVO.setSort(index - 1 - size);
                defineColumnList.put(defineVO.getColumnCode(), defineVO);
                exist = this.columnFilterCheck(fieldAnalysisParams, defineVO.getColumnName());
                if (!exist) continue;
                defineColumnList.remove(defineVO.getColumnCode());
            }
        }
        ArrayList collectionField = Lists.newArrayList();
        for (i = 0; i < fields.length; ++i) {
            String name;
            Excel annotation;
            Field field = fields[i];
            String fieldName = field.getName();
            if (defineColumnList.containsKey(fieldName)) {
                excelParams.add(this.createExcelExportEntityOfDefineColumn(field, targetId, pojoClass, getMethods, (UserColumnDefineVO)defineColumnList.get(fieldName)));
                continue;
            }
            if (PoiPublicUtil.isCollection(field.getType())) {
                collectionField.add(field);
                continue;
            }
            if (!StrUtil.isBlank((CharSequence)fieldAnalysisParams.getDefineColumn()) || defineColumnList.size() != 0 || null != (annotation = field.getAnnotation(Excel.class)) && (exist = this.columnFilterCheck(fieldAnalysisParams, name = annotation.name()))) continue;
            this.extractedOfExcelAnnotation(exclusions, targetId, excelParams, pojoClass, getMethods, exclusionsList, field, fieldAnalysisParams);
        }
        for (i = 0; i < collectionField.size(); ++i) {
            this.extractedOfExcelAnnotation(exclusions, targetId, excelParams, pojoClass, getMethods, exclusionsList, (Field)collectionField.get(i), fieldAnalysisParams);
        }
    }

    private boolean columnFilterCheck(ExportFieldAnalysisParams fieldAnalysisParams, String columnTitle) {
        boolean exist = false;
        if (StrUtil.isNotBlank((CharSequence)fieldAnalysisParams.getTargetTitleKey())) {
            Set defaultColumnTitle;
            Map columnFilterTitleMap = fieldAnalysisParams.getColumnFilterTitleMap();
            ExcelCollection excelCollection = fieldAnalysisParams.getExcelCollection();
            columnFilterTitleMap = (Map)ObjectUtil.defaultIfNull(columnFilterTitleMap, (Object)Maps.newHashMap());
            if (null == excelCollection) {
                String titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + "default-key";
                defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                exist = defaultColumnTitle.contains(columnTitle);
            } else {
                ExcelCollection.columnTitleFilterType titleFilterType = excelCollection.columnTitleFilterType();
                String titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + fieldAnalysisParams.getTargetTitleKey();
                switch (titleFilterType) {
                    case ALL: {
                        exist = columnFilterTitleMap.values().stream().flatMap(Collection::stream).anyMatch(x -> x.equals(columnTitle));
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        break;
                    }
                    case NEVER: {
                        titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + fieldAnalysisParams.getTargetTitleKey();
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        break;
                    }
                    case DIS_LEVEL: {
                        Set temColumnTitle = columnFilterTitleMap.computeIfAbsent("-default-key", k -> Sets.newHashSet());
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        exist = temColumnTitle.contains(columnTitle) && defaultColumnTitle.contains(columnTitle);
                        break;
                    }
                    default: {
                        defaultColumnTitle = Sets.newHashSet();
                    }
                }
            }
            if (!exist) {
                defaultColumnTitle.add(columnTitle);
            }
        }
        return exist;
    }

    private void extractedOfExcelAnnotation(String[] exclusions, String targetId, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods, List exclusionsList, Field field, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        ArrayList arrayList = exclusionsList = null == exclusions ? exclusionsList : Arrays.asList(exclusions);
        if (!PoiPublicUtil.isNotUserExcelUserThis(exclusionsList, field, targetId)) {
            if (field.getAnnotation(Excel.class) != null) {
                excelParams.add(this.createExcelExportEntity(field, targetId, pojoClass, getMethods));
            } else if (PoiPublicUtil.isCollection(field.getType())) {
                exclusionsList = Lists.newArrayList();
                ExcelCollection excel = field.getAnnotation(ExcelCollection.class);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                Field[] excelCollectionObjFields = PoiPublicUtil.getClassFields(clz);
                String[] ignorePres = excel.ignorePrefix();
                for (int i = 0; i < ignorePres.length; ++i) {
                    for (Field f : excelCollectionObjFields) {
                        if (!f.getName().startsWith(ignorePres[i])) continue;
                        exclusionsList.add(f.getName());
                        Excel annotation = f.getAnnotation(Excel.class);
                        if (null == annotation) continue;
                        String name = annotation.name();
                        exclusionsList.add(name);
                    }
                }
                if (StrUtil.isNotBlank((CharSequence)fieldAnalysisParams.getTargetTitleKey())) {
                    fieldAnalysisParams.setExcelCollection(excel);
                    fieldAnalysisParams.setDefineColumn(excel.defineColumn());
                    fieldAnalysisParams.setLastTargetTitleKey(fieldAnalysisParams.getLastTargetTitleKey() + "-" + fieldAnalysisParams.getTargetTitleKey());
                    fieldAnalysisParams.setTargetTitleKey(field.getName());
                }
                this.getAllExcelField(exclusionsList.toArray(new String[0]), StringUtils.isNotEmpty((String)excel.id()) ? excel.id() : targetId, excelCollectionObjFields, list, clz, null, fieldAnalysisParams);
                ExcelExportEntity excelEntity = new ExcelExportEntity();
                excelEntity.setName(this.getExcelName(excel.name(), targetId));
                excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
                excelEntity.setMethod(PoiPublicUtil.getMethod(field.getName(), pojoClass));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
            } else {
                ExportFieldAnalysisParams fieldAnalysisParams1 = new ExportFieldAnalysisParams();
                ArrayList<Method> newMethods = new ArrayList<Method>();
                if (getMethods != null) {
                    newMethods.addAll(getMethods);
                }
                newMethods.add(PoiPublicUtil.getMethod(field.getName(), pojoClass));
                ExcelEntity excel = field.getAnnotation(ExcelEntity.class);
                this.getAllExcelField(exclusions, StringUtils.isNotEmpty((String)excel.id()) ? excel.id() : targetId, PoiPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods, fieldAnalysisParams1);
            }
        }
    }

    public int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (this.isInteger(orderNum) && targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            String[] temp = str.split("_");
            if (temp.length <= 1 || !targetId.equals(temp[1])) continue;
            return Integer.valueOf(temp[0]);
        }
        return 0;
    }

    public Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value = null;
        if (obj instanceof Map) {
            value = ((Map)obj).get(entity.getKey());
        } else {
            Object entityValue = entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]);
            value = this.getDictFieldValue(entityValue, entity, obj);
        }
        if (StringUtils.isNotEmpty((String)entity.getFormat())) {
            value = this.formatValue(value, entity);
        }
        if (entity.getReplace() != null && entity.getReplace().length > 0) {
            if (value == null) {
                value = "";
            }
            value = entity.isMultiReplace() ? this.multiReplaceValue(entity.getReplace(), String.valueOf(value)) : this.replaceValue(entity.getReplace(), String.valueOf(value));
        }
        if (this.needHanlderList != null && this.needHanlderList.contains(entity.getName())) {
            value = this.dataHanlder.exportHandler(obj, entity.getName(), value);
        }
        if (StringUtils.isNotEmpty((String)entity.getSuffix()) && value != null) {
            value = value + entity.getSuffix();
        }
        return value == null ? "" : value.toString();
    }

    private Object getDictFieldValue(Object entityValue, ExcelExportEntity entity, Object obj) {
        try {
            String fieldName = StrUtil.lowerFirst((CharSequence)entity.getMethod().getName().substring(3));
            String code = null;
            String text = null;
            String table = null;
            ExcelExportUtil.initThreadDictMap();
            if (ExcelDataTypeEnum.DICT.getCode().equals(entity.getFieldType()) && StringUtils.isNotBlank((String)entity.getDictCode())) {
                code = entity.getDictCode();
            } else {
                Dict dictAnnotation = ExcelExportUtil.getThreadDictField(fieldName);
                if (null == dictAnnotation) {
                    Field declaredField = this.getObjField(obj, fieldName);
                    if (declaredField == null) {
                        return entityValue;
                    }
                    dictAnnotation = declaredField.getAnnotation(Dict.class);
                    if (null == dictAnnotation) {
                        return entityValue;
                    }
                }
                ExcelExportUtil.setThreadDictFieldMapValue(fieldName, dictAnnotation);
                code = dictAnnotation.dicCode();
                text = dictAnnotation.dicText();
                table = dictAnnotation.dictTable();
                String fieldNameValue = ExcelExportUtil.getThreadDictMapValue().get(fieldName + "_" + entityValue);
                if (null != fieldNameValue) {
                    return fieldNameValue;
                }
            }
            if (code.contains("#") || code.contains(",")) {
                String text1 = null;
                String table1 = null;
                String valueText = null;
                String[] dictCodeArray = code.contains("#") ? code.split("#") : code.split(",");
                table1 = dictCodeArray[0];
                text1 = dictCodeArray[1];
                valueText = dictCodeArray[2];
                String code1 = "";
                if (dictCodeArray.length > 3) {
                    code1 = dictCodeArray[3];
                }
                JSONObject item = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
                String busAccount = item.getString("busAccount");
                String key = String.valueOf(item.get((Object)fieldName));
                if ("null".equals(key) || key.trim().length() == 0) {
                    return "";
                }
                if (StrUtil.isBlank((CharSequence)busAccount)) {
                    busAccount = TenantContext.getTenant();
                }
                String[] keys = key.split(",");
                StringBuffer textValue = new StringBuffer();
                for (String k : keys) {
                    String tmpValue;
                    if (k.trim().length() == 0 || (tmpValue = this.translateSelect(table1, text1, valueText, code1, busAccount, k.trim())) == null) continue;
                    if (!"".equals(textValue.toString())) {
                        textValue.append(",");
                    }
                    textValue.append(tmpValue);
                }
                return textValue.toString();
            }
            JSONObject item = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
            String busAccount = item.getString("busAccount");
            if (StrUtil.isBlank((CharSequence)busAccount)) {
                busAccount = TenantContext.getTenant();
            }
            if (StrUtil.isBlank((CharSequence)busAccount)) {
                busAccount = item.getString("elsAccount");
            }
            boolean isFilterSql = false;
            if (code.contains("${")) {
                StringBuffer filterSql = new StringBuffer();
                Matcher matcher = this.pattern.matcher(code);
                isFilterSql = true;
                while (matcher.find()) {
                    matcher.appendReplacement(filterSql, item.get((Object)matcher.group(1)) + "");
                }
                matcher.appendTail(filterSql);
                code = filterSql.toString();
            }
            String key = String.valueOf(entityValue);
            String textValue = this.translateDictValue(code, text, table, key, isFilterSql, busAccount);
            ExcelExportUtil.setThreadDictMapValue(fieldName + "_" + entityValue, textValue);
            return textValue;
        }
        catch (Exception exception) {
            return entityValue;
        }
    }

    private String translateSelect(String table, String descText, String valueText, String where, String elsAccount, String value) {
        String tmpValue = "";
        List<DictModel> list = SpringContextUtils.getBean(DictService.class).queryTableDictItemsByCodeAndFilter(table, descText, valueText, where, elsAccount);
        for (DictModel model : list) {
            if (!model.getValue().equals(value)) continue;
            tmpValue = model.getText();
            break;
        }
        if (StrUtil.isBlank((CharSequence)tmpValue)) {
            return value;
        }
        return tmpValue;
    }

    private Field getObjField(Object obj, String fieldName) {
        Field field = null;
        for (Class<?> modalClass = obj.getClass(); modalClass != null && !modalClass.getName().toLowerCase().equals("java.lang.object"); modalClass = modalClass.getSuperclass()) {
            try {
                field = modalClass.getDeclaredField(fieldName);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return field;
    }

    private String translateDictValue(String code, String text, String table, String key, boolean isFilterSql, String busAccount) {
        String[] keys;
        if (ConvertUtils.isEmpty(key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String tmpValue = null;
            if (k.trim().length() == 0 || (tmpValue = isFilterSql ? SpringContextUtils.getBean(DictService.class).queryTableDictTextByFilterSql(table, text, code, busAccount) : SpringContextUtils.getBean(DictService.class).queryDictTextByKey(code, k.trim(), busAccount)) == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }

    public Collection<?> getListCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value = obj instanceof Map ? ((Map)obj).get(entity.getKey()) : (Collection)entity.getMethod().invoke(obj, new Object[0]);
        return (Collection)value;
    }

    private void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(this.getExcelName(excel.name(), targetId));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        if (StringUtils.isNotEmpty((String)excel.dicCode())) {
            AutoPoiDictServiceI ilsDictService = null;
            try {
                ilsDictService = SpringContextUtils.getBean(AutoPoiDictServiceI.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ilsDictService != null) {
                String[] dictReplace = ilsDictService.queryDict(excel.dictTable(), excel.dicCode(), excel.dicText());
                if (excelEntity.getReplace() != null && dictReplace != null && dictReplace.length != 0) {
                    excelEntity.setReplace(dictReplace);
                }
            }
        }
        excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setFormat(StringUtils.isNotEmpty((String)excel.exportFormat()) ? excel.exportFormat() : excel.format());
        excelEntity.setStatistics(excel.isStatistics());
        String fieldname = field.getName();
        excelEntity.setMethod(PoiPublicUtil.getMethod(fieldname, pojoClass, excel.exportConvert()));
        excelEntity.setMultiReplace(excel.multiReplace());
    }

    public String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0 || targetId == null) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    public Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    public short getRowHeight(List<ExcelExportEntity> excelParams) {
        double maxHeight = 0.0;
        for (int i = 0; i < excelParams.size(); ++i) {
            double d = maxHeight = maxHeight > excelParams.get(i).getHeight() ? maxHeight : excelParams.get(i).getHeight();
            if (excelParams.get(i).getList() == null) continue;
            for (int j = 0; j < excelParams.get(i).getList().size(); ++j) {
                maxHeight = maxHeight > excelParams.get(i).getList().get(j).getHeight() ? maxHeight : excelParams.get(i).getList().get(j).getHeight();
            }
        }
        return (short)(maxHeight * 50.0);
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private Object replaceValue(String[] replace, String value) {
        for (String str : replace) {
            String[] temp = str.split("_");
            if (!value.equals(temp[1])) continue;
            value = temp[0];
            break;
        }
        return value;
    }

    private Object multiReplaceValue(String[] replace, String value) {
        if (value.indexOf(",") > 0) {
            String[] radioVals = value.split(",");
            String result = "";
            block0: for (int i = 0; i < radioVals.length; ++i) {
                String radio = radioVals[i];
                for (String str : replace) {
                    String[] temp = str.split("_");
                    if (!radio.equals(temp[1])) continue;
                    result = result.concat(temp[0]) + ",";
                    continue block0;
                }
            }
            result = result.equals("") ? value : result.substring(0, result.length() - 1);
            return result;
        }
        return this.replaceValue(replace, value);
    }

    public void sortAllParams(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams);
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList());
        }
    }

    static class ExcelAnnotation {
        @Excel(width=20.0)
        private String excel;

        ExcelAnnotation() {
        }
    }
}

