/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ThirdAccountService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingtalkSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(DingtalkSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ArrayList busAccountList;
        log.info("enter into DingtalkSendMsgImpl.doSendMsg");
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        if (CollectionUtil.isEmpty(elsMsgConfigItem)) {
            log.warn("DingtalkSendMsgImpl \u7f3a\u5c11\u9489\u9489\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccount account = msg.getReceiveAccount();
        ThirdAccountService thirdAccountService = SpringContextUtils.getBean(ThirdAccountService.class);
        List<ThirdAccount> list = thirdAccountService.getThirdAccount(busAccountList = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])new String[]{"100000", msg.getBusAccount(), msg.getReceiveAccount().getElsAccount()})), account.getId(), "DINGTALK");
        if (list.isEmpty()) {
            log.warn("DingtalkSendMsgImpl receive not bind DINGTALK");
            return;
        }
        for (ThirdAccount accountDto : list) {
            List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(accountDto.getBusAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, accountDto.getBusAccount());
            String configAccount = accountDto.getBusAccount();
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)accountDto.getBusAccount(), (Object)"DINGTALK");
                continue;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
                configAccount = "100000";
                if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
                    log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)"100000", (Object)"DINGTALK");
                    continue;
                }
            }
            try {
                JustAuthConfig config = this.getJustConfig(configAccount, "DINGTALK");
                if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                    log.error(":::\u9489\u9489\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)configAccount);
                    continue;
                }
                ElsMsgConfigItem item = elsMsgConfigItems.get(0);
                msg.setMsgContent(item.getMsgContent());
                String token = ThirdTokenUtil.getDingtalkToken(configAccount, config);
                StringBuilder users = new StringBuilder();
                String unionId = accountDto.getThirdUserUuid();
                String userId = this.getUserIdByUnionId(unionId, token);
                if (StrUtil.isNotBlank((CharSequence)userId)) {
                    if (users.length() == 0) {
                        users.append(userId);
                    } else {
                        users.append(",").append(userId);
                    }
                }
                log.info("dingtalk_receive:" + users);
                String urlString = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=" + token;
                JSONObject body = new JSONObject();
                body.put("agent_id", (Object)config.getAgentId());
                body.put("userid_list", (Object)users.toString());
                JSONObject msgObj = new JSONObject();
                msgObj.put("msgtype", (Object)"action_card");
                JSONObject actionCard = new JSONObject();
                actionCard.put("title", (Object)item.getMsgTitle());
                actionCard.put("single_url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam(), configAccount));
                actionCard.put("single_title", (Object)"\u8be6\u60c5");
                if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON(msg.getParams());
                    String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                    String time = DateUtils.date2Str(new Date(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                    msgContent = msgContent + "<!--" + time + "-->";
                    actionCard.put("markdown", (Object)msgContent);
                }
                msgObj.put("action_card", (Object)actionCard);
                body.put("msg", (Object)msgObj);
                log.info(":::DingtalkSendMsgImpl msgBody:{}", (Object)body.toString());
                String result = HttpUtil.post((String)urlString, (String)body.toString());
                log.info(":::DingtalkSendMsgImpl send message result:{}", (Object)result);
            }
            catch (Exception e) {
                log.error("DingtalkSendMsgImpl.doSendMsg \u9489\u9489\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/dingtalk_account";
    }

    private String getUserIdByUnionId(String unionId, String token) {
        String result = HttpUtil.post((String)("https://oapi.dingtalk.com/topapi/user/getbyunionid?access_token=" + token), (String)("{\"unionid\":\"" + unionId + "\"}"));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (resultObj.containsKey((Object)"result")) {
            JSONObject obj = resultObj.getJSONObject("result");
            return obj.getString("userid");
        }
        return null;
    }
}

