/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/fileTask"})
@Api(tags={"Excel\u914d\u7f6e"})
public class BackgroundFileTaskController
extends BaseController<BackgroundFileTask, BackgroundFileTaskService> {
    private static final Logger log = LoggerFactory.getLogger(BackgroundFileTaskController.class);
    @Autowired
    private BackgroundFileTaskService backgroundFileTaskService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(BackgroundFileTask backgroundFileTask, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<BackgroundFileTask> queryWrapper = QueryGenerator.initQueryWrapper(backgroundFileTask, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return Result.ok(this.backgroundFileTaskService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u4e0b\u8f7d", notes="\u901a\u8fc7id\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/downTaskFile/{id}"})
    public void downTaskFile(@PathVariable(value="id") String id, HttpServletResponse response) throws MalformedURLException {
        BackgroundFileTask task = (BackgroundFileTask)this.backgroundFileTaskService.getById((Serializable)((Object)id));
        if (null == task) {
            throw new ELSBootException(I18nUtil.translate("", "\u6587\u4ef6\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        }
        if (TaskStatusEnum.RUNNING.getCode().equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate("", "\u6587\u4ef6\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        }
        if (TaskStatusEnum.FAIL.getCode().equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate("", "\u6587\u4ef6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u4efb\u52a1\u6587\u4ef6!"));
        }
        String path = this.uploadpath + File.separator + task.getTaskFilePath();
        File file = new File(path);
        Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate("i18n_alert_BIxMKSIqQG_748441c8", "\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        try (ServletOutputStream outputStream = response.getOutputStream();
             BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            int len;
            response.addHeader("Content-Disposition", "importFile;fileName=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }
}

