/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.vo.PermissionDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u8d26\u53f7\u6743\u9650"})
@RestController
@RequestMapping(value={"/system/permissionData"})
public class PermissionDataController
extends BaseController<PermissionData, PermissionDataService> {
    @Autowired
    private PermissionDataService permissionDataService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PermissionData permissionData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<PermissionData> queryWrapper = QueryGenerator.initQueryWrapper(permissionData, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.permissionDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u6dfb\u52a0\u6388\u6743", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"account:permission"})
    public Result<?> add(@RequestBody PermissionData permissionData) {
        this.permissionDataService.savePermissionData(permissionData);
        return Result.ok(permissionData);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u7f16\u8f91\u6388\u6743", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"account:permission"})
    public Result<?> edit(@RequestBody PermissionDataVO permissionDataVO) {
        this.permissionDataService.updatePermissionData(permissionDataVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u5220\u9664\u6388\u6743", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @RequiresPermissions(value={"system#permissionData:delete"})
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.permissionDataService.delPermissionData(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PermissionDataVO dataVO = new PermissionDataVO();
        ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
        BeanUtil.copyProperties((Object)account, (Object)dataVO, (String[])new String[0]);
        List list = this.permissionDataService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)account.getElsAccount())).eq((Object)"sub_account", (Object)account.getSubAccount()));
        dataVO.setPermissionDataList(list);
        return Result.ok(dataVO);
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u5bfc\u51faExcel", logType=2, operateType=6)
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"system#permissionData:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, PermissionData permissionData, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<PermissionData> queryWrapper = QueryGenerator.initQueryWrapper(permissionData, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, permissionData);
            queryWrapper.in((Object)"id", selectionList);
        }
        List permissionDataList = this.permissionDataService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u8d26\u53f7\u6743\u9650");
        mv.addObject("entity", PermissionData.class);
        mv.addObject("params", (Object)new ExportParams("\u8d26\u53f7\u6743\u9650", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u8d26\u53f7\u6743\u9650", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)permissionDataList);
        return mv;
    }

    @AutoLog(value="\u8d26\u53f7\u6743\u9650-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    @RequiresPermissions(value={"system#permissionData:importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PermissionData.class);
    }
}

