/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.handler;

import cn.hutool.core.collection.CollUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.ExcelRedisKeyGenerateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorExcelHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorExcelHandler.class);

    public static void handleData(String id, String optBusinessType, String optBusinessName, String elsAccount, List<String> errorTitleList, List<Map<String, Object>> dataList) {
        log.info("...excel\u5bfc\u5165type:{},name:{},elsAccount:{},taskId:{}\u9519\u8bef\u8bb0\u5f55\u4fdd\u5b58", new Object[]{optBusinessType, optBusinessName, elsAccount, id});
        RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);
        SpringContextUtils.getBean(BackgroundFileTaskService.class).saveImportTask(optBusinessType, optBusinessName, id, elsAccount);
        String key = ExcelRedisKeyGenerateUtil.generateImportKey(optBusinessType, elsAccount, id);
        ArrayList title = (ArrayList)redisUtil.hget(key, "title");
        if (CollUtil.isEmpty((Collection)title)) {
            title = new ArrayList();
        }
        if (CollUtil.isNotEmpty(errorTitleList)) {
            ArrayList finalTitle = title;
            errorTitleList.forEach(x -> {
                if (!finalTitle.contains(x)) {
                    finalTitle.add(x);
                }
            });
        }
        long mapLen = redisUtil.mapLen(key);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (int i = 0; i < dataList.size(); ++i) {
            result.put(String.valueOf((long)i + mapLen), dataList.get(i));
        }
        result.put("title", title);
        redisUtil.hmset(key, result);
    }
}

