/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.handler.ErrorExcelHandlerService;
import com.els.modules.system.service.BaseImGroupService;
import com.els.modules.system.service.ElsSubAccountOrgService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSubAccountExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRoleService userRoleService;

    @Override
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<ElsSubAccount> accountList = new ArrayList<ElsSubAccount>();
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        List roleList = this.roleService.list();
        Map<String, String> roleMap = roleList.stream().collect(Collectors.toMap(Role::getRoleCode, Role::getId));
        ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
        Map<String, String> deptMap = elsSubAccountOrgService.getDeptOrganization(elsAccount);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List checkList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        List subAccount = checkList.stream().map(ElsSubAccount::getSubAccount).collect(Collectors.toList());
        ArrayList<String> subAccountList = new ArrayList<String>();
        for (Map<String, Object> data : dataList) {
            String msg;
            ElsSubAccount account = (ElsSubAccount)JSON.parseObject((String)JSON.toJSONString(data), ElsSubAccount.class);
            if (subAccountList.contains(account.getSubAccount())) {
                msg = I18nUtil.translate("i18n_alert_uNjWFjVBjJey_a0e908ed", "\u5bfc\u5165\u7684\u6570\u636e\u6709\u91cd\u590d\u7684\u5b50\u8d26\u53f7");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (subAccount.contains(account.getSubAccount())) {
                msg = I18nUtil.translate("i18n_alert_HesMKdejJeyWWWWWW_dae4f254", "\u7cfb\u7edf\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b50\u8d26\u53f7\uff1a") + account.getSubAccount();
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            String roleCode = (String)data.get("roleCode");
            if (roleMap.get(roleCode) == null) {
                String msg2 = I18nUtil.translate("i18n_alert_KyAoNSWWWWWW_d2c467ab", "\u89d2\u8272\u7f16\u7801\u9519\u8bef\uff1a") + roleCode;
                this.errorAdd(excelImportDTO, msg2, data);
                continue;
            }
            String orgCode = account.getOrgCode();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(elsAccount);
            account.setOrgCode(deptMap.get(orgCode));
            String salt = ConvertUtils.randomGen(8);
            account.setSalt(salt);
            String password = StringUtils.isNotBlank((String)account.getPassword()) ? account.getPassword() : account.getPhone().trim().substring(account.getPhone().trim().length() - 6);
            String passwordEncode = PasswordUtil.encrypt(elsAccount + "_" + account.getSubAccount(), password, salt);
            account.setPassword(passwordEncode);
            account.setStatus(1);
            account.setDeleted(0);
            account.setSourceType("excel");
            accountList.add(account);
            subAccountList.add(account.getSubAccount());
            UserRole userRole = new UserRole(account.getId(), roleMap.get(roleCode));
            userRoleList.add(userRole);
        }
        if (CollectionUtils.isEmpty(accountList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        this.elsSubAccountService.saveBatch(accountList);
        this.userRoleService.saveBatch(userRoleList);
        BaseImGroupService baseImGroupService = (BaseImGroupService)SpringContextUtils.getBean("baseImGroupServiceImpl");
        List<String> userIdList = accountList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (baseImGroupService != null) {
            baseImGroupService.initGroupBatch(userIdList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

