/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.wp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.wp.WechatEnterpriseConfig;
import com.els.common.util.RedisUtil;
import com.els.common.util.RestUtil;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatEnterpriseApiUtil {
    private static final Logger log = LoggerFactory.getLogger(WechatEnterpriseApiUtil.class);
    @Autowired
    private RedisUtil redisUtil;

    public String getCustomizedAuthUrl(String corpId, String providerSecret, String state, List<String> templateIdList) {
        String qrcodeUrl;
        String key = "sys:third:webchat_enterprise_third:customized_auth_url:" + corpId + templateIdList;
        if (CollUtil.isNotEmpty(templateIdList)) {
            key = key + String.join((CharSequence)"_", templateIdList);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)(qrcodeUrl = (String)this.redisUtil.get(key)))) {
            return qrcodeUrl;
        }
        JSONObject param = new JSONObject();
        param.put("state", (Object)state);
        if (CollUtil.isNotEmpty(templateIdList)) {
            param.put("templateid_list", templateIdList);
        }
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_customized_auth_url?provider_access_token=" + this.getProviderToken(corpId, providerSecret), param);
        this.errorCheck(jsonObject, "getCustomizedAuthUrl");
        qrcodeUrl = jsonObject.getString("qrcode_url");
        this.redisUtil.set(key, qrcodeUrl, jsonObject.getInteger("expires_in").intValue());
        log.info(":::\u83b7\u53d6\u5230\u4f01\u4e1a\u5fae\u4fe1\u5546\u6237\u5e26\u53c2\u6388\u6743\u94fe\u63a5:{}", (Object)qrcodeUrl);
        return qrcodeUrl;
    }

    public String getProviderToken(String corpId, String providerSecret) {
        String key = "sys:third:webchat_enterprise_third:provider_token:" + corpId;
        String token = (String)this.redisUtil.get(key);
        if (CharSequenceUtil.isNotEmpty((CharSequence)token)) {
            return token;
        }
        JSONObject param = new JSONObject();
        param.put("corpid", (Object)corpId);
        param.put("provider_secret", (Object)providerSecret);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token", param);
        this.errorCheck(jsonObject, "getProviderToken");
        token = jsonObject.getString("provider_access_token");
        this.redisUtil.set(key, token, jsonObject.getInteger("expires_in").intValue());
        log.info(":::\u83b7\u53d6\u5230\u4f01\u4e1a\u5fae\u4fe1\u5546\u6237token:{}", (Object)token);
        return token;
    }

    public String getPermanentCode(String tempAuthCode, String authCorpId, String suiteId, String suiteSecret, JSONObject permanentData) {
        String key;
        if (CharSequenceUtil.isEmpty((CharSequence)authCorpId) && CharSequenceUtil.isEmpty((CharSequence)tempAuthCode)) {
            throw new ELSBootException("tempAuthCode and authCorpId is empty.");
        }
        String permanentCode = "";
        if (CharSequenceUtil.isNotEmpty((CharSequence)authCorpId) && CharSequenceUtil.isNotEmpty((CharSequence)(permanentCode = (String)this.redisUtil.get(key = "sys:third:webchat_enterprise_third:permanent_code:" + authCorpId)))) {
            return permanentCode;
        }
        JSONObject param = new JSONObject();
        param.put("auth_code", (Object)tempAuthCode);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=" + this.getSuiteToken(suiteId, suiteSecret), param);
        this.errorCheck(jsonObject, "getPermanentCode");
        permanentCode = jsonObject.getString("permanent_code");
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        if (permanentData != null) {
            permanentData.put("authCorpInfo", (Object)jsonObject);
        }
        String authCorpid = authCorpInfo.getString("corpid");
        String authcorpName = authCorpInfo.getString("corp_name");
        this.redisUtil.set("sys:third:webchat_enterprise_third:permanent_code:" + authCorpId, permanentCode);
        log.info(":::\u83b7\u53d6\u5230suiteId:{},\u4f01\u4e1acorpId(\u5bc6\u6587):{},\u4f01\u4e1aname:{},\u6c38\u4e45\u6388\u6743\u7801:{}", new Object[]{suiteId, authCorpid, authcorpName, permanentCode});
        return permanentCode;
    }

    public String getSuiteToken(String suiteId, String clientSecret) {
        String key = "sys:third:webchat_enterprise_third:suite_token:" + suiteId;
        String token = (String)this.redisUtil.get(key);
        if (CharSequenceUtil.isNotBlank((CharSequence)token)) {
            log.info(":::WechatEnterpriseApiUtil getSuiteToken:\u3010{}\u3011", (Object)token);
            return token;
        }
        JSONObject param = new JSONObject();
        param.put("suite_id", (Object)suiteId);
        param.put("suite_secret", (Object)clientSecret);
        String suiteTicket = (String)this.redisUtil.get("sys:third:webchat_enterprise_third:suite_ticket:" + suiteId);
        if (CharSequenceUtil.isEmpty((CharSequence)suiteTicket)) {
            log.error(":::\u4f01\u4e1a\u5fae\u4fe1Suite Ticket\u4e0d\u5b58\u5728\u6216\u672a\u6536\u5230\u63a8\u9001...");
            throw new ELSBootException("Suite Ticket is empty.");
        }
        param.put("suite_ticket", (Object)suiteTicket);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token", param);
        this.errorCheck(jsonObject, "getSuiteToken");
        token = jsonObject.getString("suite_access_token");
        this.redisUtil.set(key, token, jsonObject.getInteger("expires_in").intValue());
        log.info(":::\u83b7\u53d6\u5230\u4f01\u4e1asuiteToken:{}", (Object)token);
        return token;
    }

    public JSONObject getAuthInfo(String authCorpId, String tempAuthCode, String suiteId, String suiteSecret) {
        JSONObject param = new JSONObject();
        param.put("auth_corpid", (Object)authCorpId);
        param.put("permanent_code", (Object)this.getPermanentCode(tempAuthCode, authCorpId, suiteId, suiteSecret, null));
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token=" + this.getSuiteToken(suiteId, suiteSecret), param);
        this.errorCheck(jsonObject, "getAuthInfo");
        log.info(":::\u6210\u529f\u83b7\u53d6\u5230\u4f01\u4e1a{}\u6388\u6743\u4fe1\u606f:{}", (Object)authCorpId, (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    public JSONObject getAuthInfo(String authCorpId, String suiteId, String suiteSecret) {
        JSONObject param = new JSONObject();
        param.put("auth_corpid", (Object)authCorpId);
        String key = "sys:third:webchat_enterprise_third:permanent_code:" + authCorpId;
        String permanentCode = (String)this.redisUtil.get(key);
        if (null == permanentCode) {
            log.error(":::\u5fae\u4fe1\u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u672a\u83b7\u53d6\u5230\u6c38\u4e45\u6388\u6743\u7801");
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LVAEdjovhLSMujOlbo_b903dd3e", "\u5fae\u4fe1\u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u672a\u83b7\u53d6\u5230\u6c38\u4e45\u6388\u6743\u7801"));
        }
        param.put("permanent_code", (Object)permanentCode);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token=" + this.getSuiteToken(suiteId, suiteSecret), param);
        this.errorCheck(jsonObject, "getAuthInfo");
        log.info(":::\u6210\u529f\u83b7\u53d6\u5230\u4f01\u4e1a{}\u6388\u6743\u4fe1\u606f:{}", (Object)authCorpId, (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    public void setSessionInfo(Integer authType, List<String> appIds, String preAuthCode, String suiteId, String suiteSecret, String authCorpId) {
        JSONObject param = new JSONObject();
        param.put("pre_auth_code", (Object)preAuthCode);
        JSONObject sessionInfo = new JSONObject();
        sessionInfo.put("auth_type", (Object)authType);
        sessionInfo.put("appid", appIds);
        param.put("session_info", (Object)sessionInfo);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=" + this.getSuiteToken(suiteId, suiteSecret), param);
        this.errorCheck(jsonObject, "setSessionInfo");
        log.info(":::\u6210\u529f\u6388\u6743auth_type:{},appid:{}", (Object)suiteId, appIds);
    }

    public JSONObject resetPermanentCode(String suiteSecret, Map<String, String> dataMap) {
        log.info(":::resetPermanentCode\u91cd\u8bbe\u6c38\u4e45\u6388\u6743\u7801...");
        String suiteId = dataMap.get("SuiteId");
        String authCode = dataMap.get("AuthCode");
        JSONObject permanentData = new JSONObject();
        this.getPermanentCode(authCode, null, suiteId, suiteSecret, permanentData);
        JSONObject authCorpInfo = permanentData.getJSONObject("authCorpInfo");
        log.info("\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u4f01\u4e1a\u6388\u6743\u4fe1\u606f:{}", (Object)authCorpInfo.toJSONString());
        return authCorpInfo;
    }

    public JSONObject createAuth(String suiteSecret, Map<String, String> dataMap) {
        log.info(":::#createAuth\u6388\u6743\u6210\u529f\u901a\u77e5...");
        String suiteId = dataMap.get("SuiteId");
        String authCode = dataMap.get("AuthCode");
        JSONObject permanentData = new JSONObject();
        this.getPermanentCode(authCode, null, suiteId, suiteSecret, permanentData);
        JSONObject authCorpInfo = permanentData.getJSONObject("authCorpInfo");
        log.info("\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u4f01\u4e1a\u6388\u6743\u4fe1\u606f:{}", (Object)authCorpInfo.toJSONString());
        return authCorpInfo;
    }

    public void changeAuth(String suiteSecret, Map<String, String> dataMap) {
        String authCorpId = dataMap.get("AuthCorpId");
        log.info(":::changeAuth\u6388\u6743\u53d8\u66f4,authCorpId:{}", (Object)authCorpId);
        String suiteId = dataMap.get("SuiteId");
        this.redisUtil.del("sys:third:webchat_enterprise_third:permanent_code:" + authCorpId);
        String authCode = dataMap.get("AuthCode");
        this.getPermanentCode(authCode, authCorpId, suiteId, suiteSecret, null);
    }

    public void cancelAuth(Map<String, String> dataMap) {
        String authCorpId = dataMap.get("AuthCorpId");
        String SuiteId = dataMap.get("SuiteId");
        log.info(":::cancelAuth\u53d6\u6d88\u6388\u6743,authCorpId:{}", (Object)authCorpId);
        this.redisUtil.del("sys:third:webchat_enterprise_third:permanent_code:" + authCorpId);
        this.redisUtil.del("sys:third:webchat_enterprise_third:suite_token:" + authCorpId);
        this.redisUtil.del("sys:third:webchat_enterprise_third:suite_ticket:" + SuiteId);
        this.redisUtil.del("sys:third:webchat_enterprise_third:suite_token:" + SuiteId);
    }

    private void errorCheck(JSONObject jsonObject, String method) {
        if (!jsonObject.containsKey((Object)"errcode")) {
            return;
        }
        if (!WechatEnterpriseConfig.success.equals(jsonObject.getInteger("errcode"))) {
            log.error(":::WechatEnterpriseApiUtil {} error:{}", (Object)method, (Object)jsonObject.getString("errmsg"));
            throw new ELSBootException(jsonObject.getString("errmsg"));
        }
    }

    public void setSuiteTicket(Map<String, String> dataMap) {
        String suiteId = dataMap.get("SuiteId");
        log.info(":::\u66f4\u65b0suite_ticket\uff0csuiteId:{},suiteTicket:{}", (Object)suiteId, (Object)dataMap.get("SuiteTicket"));
        this.redisUtil.set("sys:third:webchat_enterprise_third:suite_ticket:" + suiteId, dataMap.get("SuiteTicket"));
    }

    public String corpIdToOpenCorpId(String authCropId, String customizedAuthCorpId, String providerSecret) {
        String key = "sys:third:webchat_enterprise_third:corpIdToOpenCorpId:" + authCropId;
        if (this.redisUtil.hasKey(key)) {
            return (String)this.redisUtil.get(key);
        }
        JSONObject param = new JSONObject();
        param.put("corpid", (Object)authCropId);
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/service/corpid_to_opencorpid?provider_access_token=" + this.getProviderToken(customizedAuthCorpId, providerSecret), param);
        this.errorCheck(jsonObject, "corpIdToOpenCorpId");
        String openCorpId = jsonObject.getString("open_corpid");
        log.info(":::corpIdToOpenCorpId#\u83b7\u53d6\u5230\u4f01\u4e1a\u52a0\u5bc6cropId:{}", (Object)openCorpId);
        this.redisUtil.set(key, authCropId);
        return openCorpId;
    }

    public String userIdToOpenUserId(String authUserId, String customizedAuthCorpId, String providerSecret) {
        String key = "sys:third:webchat_enterprise_third:userIdToOpenUserId:" + authUserId;
        if (this.redisUtil.hasKey(key)) {
            return (String)this.redisUtil.get(key);
        }
        JSONObject param = new JSONObject();
        param.put("userid_list", (Object)new String[]{authUserId});
        JSONObject jsonObject = RestUtil.post("https://qyapi.weixin.qq.com/cgi-bin/batch/userid_to_openuserid?access_token=access_token", param);
        this.errorCheck(jsonObject, "userIdToOpenUserId");
        JSONArray useridList = jsonObject.getJSONArray("open_userid_list");
        JSONObject object = useridList.getJSONObject(0);
        String openUserid = object.getString("open_userid");
        log.info(":::userIdToOpenUserId#\u83b7\u53d6\u5230\u4f01\u4e1a\u52a0\u5bc6userId:{}", (Object)openUserid);
        this.redisUtil.set(key, openUserid);
        return openUserid;
    }

    public void changeContact(String suitesSecret, Map<String, String> dataMap) {
        String changeType = dataMap.get("ChangeType");
        String authCropId = dataMap.get("AuthCorpId");
        switch (changeType) {
            case "create_user": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u521b\u5efa\u6210\u5458...", (Object)authCropId);
                break;
            }
            case "update_user": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u66f4\u65b0\u6210\u5458...", (Object)authCropId);
                break;
            }
            case "change_user": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u5220\u9664\u6210\u5458...", (Object)authCropId);
                break;
            }
            case "create_party": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u521b\u5efa\u90e8\u95e8...", (Object)authCropId);
                break;
            }
            case "update_party": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u66f4\u65b0\u90e8\u95e8...", (Object)authCropId);
                break;
            }
            case "change_contact": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u5220\u9664\u90e8\u95e8...", (Object)authCropId);
                break;
            }
            case "update_tag": {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u66f4\u65b0\u6807\u7b7e...", (Object)authCropId);
                break;
            }
            default: {
                log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u4e8b\u4ef6:{}...", (Object)authCropId, (Object)changeType);
            }
        }
    }

    public void shareAgentChange(String authCropId, String suitesSecret, Map<String, String> dataMap) {
        String CorpId = dataMap.get("CorpId");
        log.info(":::\u4f01\u4e1a:{}(\u52a0\u5bc6)\u5171\u4eab\u5e94\u7528\u4e8b\u4ef6...", (Object)CorpId);
    }
}

