/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.dashboard.entity.ChartConfig;
import com.els.modules.dashboard.service.ChartConfigService;
import com.els.modules.system.handler.ErrorExcelHandlerService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartConfigExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ChartConfigService chartConfigService;

    @Override
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        List<ChartConfig> chartConfigList = ((Stream)dataList.stream().parallel()).map(JSON::toJSONString).map(json -> {
            ChartConfig config = (ChartConfig)JSON.parseObject((String)json, ChartConfig.class);
            if (config.getRefreshInterval() == null) {
                config.setRefreshInterval(0);
            }
            return config;
        }).collect(Collectors.toList());
        ChartConfig one = (ChartConfig)((LambdaQueryChainWrapper)this.chartConfigService.lambdaQuery().in(ChartConfig::getChartCode, (Collection)chartConfigList.parallelStream().map(ChartConfig::getChartCode).collect(Collectors.toList()))).one();
        if (one != null) {
            throw new ELSBootException("\u5b58\u5728\u56fe\u8868\u914d\u7f6e\uff1a" + one.getChartCode());
        }
        chartConfigList.forEach(this.chartConfigService::saveChartConfig);
        return dataList;
    }
}

