/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.AuthSensitive;
import com.els.modules.system.service.AuthSensitiveService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.AuthSensitiveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sensitive/authSensitive"})
@Api(tags={"\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027"})
public class AuthSensitiveController
extends BaseController<AuthSensitive, AuthSensitiveService> {
    private static final Logger log = LoggerFactory.getLogger(AuthSensitiveController.class);
    @Autowired
    private AuthSensitiveService authSensitiveService;
    @Autowired
    private DictService dictService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2 srmAuthRoleStatus")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(AuthSensitive authSensitive, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        ArrayList ids = new ArrayList();
        String elsAccount = TenantContext.getTenant();
        String dictCode = "srmAuthRoleStatus";
        Result result = new Result();
        List<DictModel> ls = null;
        try {
            ls = this.dictService.queryDictItemsByCode(dictCode, elsAccount);
            ls.forEach(item -> {
                item.setKey(item.getValue());
                ids.add(item.getValue());
            });
            HashMap<String, List<DictModel>> resMap = new HashMap<String, List<DictModel>>();
            resMap.put("treeList", ls);
            resMap.put("ids", ids);
            result.setResult(resMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_tkKm_2f078e83", "\u64cd\u4f5c\u5931\u8d25"));
            return result;
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody AuthSensitiveVO authSensitivePage) {
        AuthSensitive authSensitive = new AuthSensitive();
        BeanUtils.copyProperties((Object)authSensitivePage, (Object)authSensitive);
        this.authSensitiveService.saveMain(authSensitive);
        return Result.ok(authSensitive);
    }

    @RequestMapping(value={"/saveauthSensitive"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"sensitive#authSensitive:saveauthSensitive"})
    public Result<String> saveRolePermission(@RequestBody JSONObject json) {
        Result<String> result = new Result<String>();
        try {
            String roleId = json.getString("roleId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.authSensitiveService.saveAuthSensitive(roleId, permissionIds, lastPermissionIds);
            result.success(I18nUtil.translate("i18n_alert_savaSuccess", "\u4fdd\u5b58\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            result.error500(I18nUtil.translate("i18n_alert_lbKm_2ecd8c0f", "\u6388\u6743\u5931\u8d25\uff01"));
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody AuthSensitiveVO authSensitivePage) {
        AuthSensitive authSensitive = new AuthSensitive();
        BeanUtils.copyProperties((Object)authSensitivePage, (Object)authSensitive);
        this.authSensitiveService.updateMain(authSensitive);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.authSensitiveService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.authSensitiveService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u901a\u8fc7id\u67e5\u8be2", logType=2, operateType=1)
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        AuthSensitive authSensitive = (AuthSensitive)this.authSensitiveService.getById((Serializable)((Object)id));
        AuthSensitiveVO authSensitiveVO = new AuthSensitiveVO();
        BeanUtils.copyProperties((Object)authSensitive, (Object)authSensitiveVO);
        return Result.ok(authSensitiveVO);
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u67e5\u8be2\u89d2\u8272\u6388\u6743", logType=2, operateType=1)
    @RequestMapping(value={"/queryAuthSensitive"}, method={RequestMethod.GET})
    public Result<List<String>> queryAuthSensitive(@RequestParam(name="roleId", required=true) String roleId) {
        Result<List<String>> result = new Result<List<String>>();
        try {
            List list = this.authSensitiveService.list((Wrapper)new QueryWrapper().lambda().eq(AuthSensitive::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(authSensitive -> String.valueOf(authSensitive.getAuthValue())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u5bfc\u51faExcel", logType=2, operateType=6)
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, AuthSensitive authSensitive, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<AuthSensitive> queryWrapper = QueryGenerator.initQueryWrapper(authSensitive, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, authSensitive);
            queryWrapper.in((Object)"id", selectionList);
        }
        ArrayList<AuthSensitiveVO> pageList = new ArrayList<AuthSensitiveVO>();
        List authSensitiveList = this.authSensitiveService.list((Wrapper)queryWrapper);
        for (AuthSensitive temp : authSensitiveList) {
            AuthSensitiveVO vo = new AuthSensitiveVO();
            BeanUtils.copyProperties((Object)temp, (Object)vo);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027");
        mv.addObject("entity", AuthSensitiveVO.class);
        mv.addObject("params", (Object)new ExportParams("\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u89d2\u8272\u654f\u611f\u5b57\u6bb5\u5c5e\u6027-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<AuthSensitiveVO> list = ExcelImportUtil.importExcel(file.getInputStream(), AuthSensitiveVO.class, params);
                for (AuthSensitiveVO page : list) {
                    AuthSensitive po = new AuthSensitive();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    this.authSensitiveService.saveMain(po);
                }
                Result<Object> result = Result.ok(I18nUtil.translate("i18n_alert_QIuNLRWWFcW_6e8a1fc", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", String.valueOf(list.size())));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }
}

