/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enums.SourceTypeEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.handler.ErrorExcelHandlerService;
import com.els.modules.system.service.ElsTaxService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private ElsTaxService elsTaxService;

    @Override
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<ElsTax> datas = new ArrayList<ElsTax>();
        QueryWrapper wrapper1 = Wrappers.query();
        wrapper1.lambda().select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxRate});
        wrapper1.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List dbCodeList = this.elsTaxService.list((Wrapper)wrapper1).stream().map(x -> x.getTaxCode() + "_" + x.getTaxRate()).collect(Collectors.toList());
        for (Map<String, Object> data : dataList) {
            String msg;
            ElsTax elsTax = (ElsTax)JSON.parseObject((String)JSON.toJSONString(data), ElsTax.class);
            if (CharSequenceUtil.isEmpty((CharSequence)elsTax.getTaxCode())) {
                msg = I18nUtil.translate("i18n_alert_foxOLV_79b3243", "\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (elsTax.getTaxRate() == null) {
                msg = I18nUtil.translate("i18n_alert_fIxOLV_c885fac9", "\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            try {
                Integer.parseInt(Integer.toString(elsTax.getTaxRate()));
            }
            catch (Exception e) {
                String msg2 = I18nUtil.translate("i18n_alert_fIROKiW_9b30f61f", "\u7a0e\u7387\u53ea\u80fd\u662f\u6574\u6570");
                this.errorAdd(excelImportDTO, msg2, data);
                continue;
            }
            if (dbCodeList.contains(elsTax.getTaxCode() + "_" + elsTax.getTaxRate())) {
                msg = I18nUtil.translate("i18n_alert_HesSuNjWFIMKIVjfIfo_bde68e23", "\u7cfb\u7edf\u4e2d\u6216\u5bfc\u5165\u7684\u6570\u636e\u5df2\u5b58\u5728\u4e00\u6837\u7684\u7a0e\u7387\u7a0e\u7801");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            dbCodeList.add(elsTax.getTaxCode() + "_" + elsTax.getTaxRate());
            elsTax.setSourceType(SourceTypeEnum.EXCEL.getValue());
            datas.add(elsTax);
        }
        if (CollectionUtils.isEmpty(datas)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        this.elsTaxService.saveBatch(datas);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

