/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.mapper.CompanyPermissionMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.service.CompanyPermissionService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.impl.RolePermissionServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyPermissionServiceImpl
extends ServiceImpl<CompanyPermissionMapper, CompanyPermission>
implements CompanyPermissionService {
    private static final Logger log = LoggerFactory.getLogger(CompanyPermissionServiceImpl.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionMapper permissionMapper;

    @Override
    public void saveCompanyPermission(CompanyPermission companyPermission) {
        ((CompanyPermissionMapper)this.baseMapper).insert(companyPermission);
    }

    @Override
    public void updateCompanyPermission(CompanyPermission companyPermission) {
        ((CompanyPermissionMapper)this.baseMapper).updateById(companyPermission);
    }

    @Override
    public void delCompanyPermission(String id) {
        ((CompanyPermissionMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchCompanyPermission(List<String> idList) {
        ((CompanyPermissionMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<String> selectWithoutElsAccountToListCompanyPermission(String toElsAccount) {
        return ((CompanyPermissionMapper)this.baseMapper).selectWithoutElsAccountToListCompanyPermission(toElsAccount);
    }

    @Override
    public void saveCompanyPermission(String sysCode, Role role, String elsAccount, List<String> getMenuAttribute, boolean clearAuth) {
        ArrayList companyPermissions = new ArrayList();
        List<Object> permissions = new ArrayList();
        TenantContext.setTenant("100000");
        if (null != sysCode) {
            Role roleAdmin = this.roleService.getRoleByElsAccountAndSysCode("100000", sysCode);
            permissions = this.permissionService.findByRoleId(roleAdmin.getId(), "100000");
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"is_default_menu", (Object)"1");
            queryWrapper.in((Object)"menu_attribute", getMenuAttribute);
            permissions = this.permissionMapper.selectList((Wrapper)queryWrapper);
        }
        if (clearAuth) {
            this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
        }
        TenantContext.setTenant(elsAccount);
        this.userAuthorization(permissions, elsAccount, role.getId());
    }

    @Override
    public void userAuthorization(List<Permission> permissions, String elsAccount, String roleId) {
        if (CollUtil.isEmpty(permissions)) {
            log.info("CompanyPermissionServiceImpl-->userAuthorization permissions \u4e3a\u7a7a");
            return;
        }
        ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
        for (Permission permission : permissions) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (CollUtil.isNotEmpty(companyPermissions)) {
            this.permissionMapper.insertCompanyMeunBatch(companyPermissions);
            ArrayList<RolePermission> RolePermissionList = new ArrayList<RolePermission>();
            for (CompanyPermission companyPermission : companyPermissions) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(roleId);
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                RolePermissionList.add(rolePermission);
            }
            RolePermissionServiceImpl rolePermissionServiceImpl = (RolePermissionServiceImpl)SpringUtil.getBean(RolePermissionServiceImpl.class);
            rolePermissionServiceImpl.saveBatch(RolePermissionList);
        }
    }
}

