/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.mail.MailUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.common.util.SysUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.util.DefaultUtils;
import com.els.modules.system.util.I18nUtil;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsTenantServiceImpl
extends BaseServiceImpl<ElsTenantMapper, ElsTenant>
implements ElsTenantService {
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Autowired
    private DictService dictService;

    @Override
    public void saveElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).insert(elsTenant);
    }

    @Override
    public void updateElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).updateById(elsTenant);
    }

    @Override
    public void delElsTenant(String id) {
        ((ElsTenantMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTenant(List<String> idList) {
        ((ElsTenantMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<JSONObject> checkTenantIsEffective(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        ElsTenant tenant = (ElsTenant)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        Result<JSONObject> result = new Result<JSONObject>();
        if (tenant == null) {
            result.error500(I18nUtil.translate("i18n_alert_rWWWeyxMKWVKHRvj_27123a7c", "\u8be5ELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", 1, null);
            return result;
        }
        if (AccountStatusEnum.FROZEN.getCode().equals(tenant.getAccountStatus())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u51bb\u7ed3\uff01", 1, null);
            result.error500(I18nUtil.translate("i18n_alert_rWWWeyIOyWVKHRvj_55c5118f", "\u8be5ELS\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            return result;
        }
        if (new Date().after(tenant.getExpiryDate())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u5931\u6548\uff01", 1, null);
            result.error500(I18nUtil.translate("i18n_alert_rWWWeyIRjXBAWVKHRvj_883acc3b", "\u8be5ELS\u8d26\u53f7\u5df2\u8fc7\u6709\u6548\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            return result;
        }
        return result;
    }

    @Override
    public ElsTenant findByElsAccount(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)"100000");
        ElsTenant elsTenant = (ElsTenant)this.getOne((Wrapper)wrapper);
        ElsTenant tenant = null;
        if (StringUtils.isNotEmpty((String)elsAccount)) {
            QueryWrapper wrapper1 = new QueryWrapper();
            wrapper1.eq((Object)"els_account", (Object)elsAccount);
            tenant = (ElsTenant)this.getOne((Wrapper)wrapper1);
        }
        if (tenant == null) {
            tenant = elsTenant;
        } else {
            if (StringUtils.isEmpty((String)tenant.getCompanyShortName())) {
                tenant.setCompanyShortName(elsTenant.getCompanyShortName());
            }
            if (StringUtils.isEmpty((String)tenant.getCompanyLogo())) {
                tenant.setCompanyLogo(elsTenant.getCompanyLogo());
            }
            if (StringUtils.isEmpty((String)tenant.getCompanyBackground())) {
                tenant.setCompanyBackground(elsTenant.getCompanyBackground());
                tenant.setFbk1(elsTenant.getFbk1());
            }
            if (StringUtils.isEmpty((String)tenant.getThemeUrl())) {
                tenant.setThemeUrl(elsTenant.getThemeUrl());
            }
        }
        if (StringUtils.isEmpty((String)tenant.getThemeEnable())) {
            tenant.setThemeEnable(StringUtils.isEmpty((String)elsTenant.getThemeEnable()) ? "1" : elsTenant.getThemeEnable());
        }
        if (StringUtils.isEmpty((String)tenant.getButtonEnable())) {
            tenant.setButtonEnable(StringUtils.isEmpty((String)elsTenant.getButtonEnable()) ? "1" : elsTenant.getButtonEnable());
        }
        return tenant;
    }

    @Override
    public List<ElsTenant> findUnFreeTenant(String status, DateTime date) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount});
        ((LambdaQueryWrapper)wrapper.eq(ElsTenant::getAccountStatus, (Object)status)).le(ElsTenant::getExpiryDate, (Object)date);
        return ((ElsTenantMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void changeAccountStatusForJob() {
        DateTime date = DateUtil.date();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"account_status", (Object)"1");
        queryWrapper.lt((Object)"expiry_date", (Object)date);
        List elsTenantList = this.list((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)"tenantManagerment")).eq(ElsMsgConfigHead::getOperateType, (Object)"tenantExpire")).eq(BaseEntity::getElsAccount, (Object)"100000");
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)wrapper);
        List configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId()).stream().filter(item -> SendMsgTypeEnum.EMAIL.getType().equals(item.getMsgType())).collect(Collectors.toList());
        ElsMsgConfigItem item2 = (ElsMsgConfigItem)configItemList.get(0);
        List<DictModel> publicCCMail = this.dictService.queryDictItemsByCode("public_cc_mail", "100000");
        String cc = "";
        if (!CollectionUtils.isEmpty(publicCCMail)) {
            List collect = publicCCMail.stream().map(DictModel::getValue).collect(Collectors.toList());
            cc = String.join((CharSequence)",", collect);
        }
        for (ElsTenant elsTenant : elsTenantList) {
            elsTenant.setAccountStatus(String.valueOf(CommonConstant.USER_FREEZE));
            super.sendMsg("100000", elsTenant.getElsAccount(), (Object)elsTenant, "tenantManagerment", "tenantExpire");
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cc)) continue;
            JSONObject obj = SysUtil.objectToJSON(elsTenant);
            String msgContent = TemplateParseUtil.getTemplateText("13654", item2.getMsgContent(), (Map<String, Object>)obj);
            MailUtil.send((String)cc, (String)"", null, (String)item2.getMsgTitle(), (String)msgContent, (boolean)true, (File[])new File[0]);
        }
        this.updateBatchById(elsTenantList);
    }

    @Override
    public ElsTenant createIfNotExistElsTenant(String elsAccount, String companyName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsTenant::getCompanyName, (Object)companyName)).last(" limit 1");
        ElsTenant elsTenant = (ElsTenant)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (null == elsTenant) {
            elsTenant = new ElsTenant();
            elsTenant.setAccountStatus("1");
            elsTenant.setElsAccount(elsAccount);
            elsTenant.setCompanyName(companyName);
            elsTenant.setSourceType("2");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            ElsTenant tenant = (ElsTenant)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
            elsTenant.setThemeEnable(tenant.getThemeEnable());
            elsTenant.setButtonEnable(tenant.getButtonEnable());
            try {
                elsTenant.setExpiryDate(DefaultUtils.getExpiryDate());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            ((ElsTenantMapper)this.baseMapper).insert(elsTenant);
        }
        return elsTenant;
    }
}

