/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.util.PmsUtil;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.modules.system.entity.Role;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.util.I18nUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements RoleService {
    @Override
    public Result importExcelCheckRoleCode(MultipartFile file, ImportParams params) throws Exception {
        int i;
        List listSysRoles = ExcelImportUtil.importExcel(file.getInputStream(), Role.class, params);
        int totalCount = listSysRoles.size();
        ArrayList<String> errorStrs = new ArrayList<String>();
        block3: for (i = 0; i < listSysRoles.size(); ++i) {
            String roleCodeI = ((Role)listSysRoles.get(i)).getRoleCode();
            for (int j = i + 1; j < listSysRoles.size(); ++j) {
                String roleCodeJ = ((Role)listSysRoles.get(j)).getRoleCode();
                if (!roleCodeI.equals(roleCodeJ)) continue;
                errorStrs.add("\u7b2c " + (j + 1) + " \u884c\u7684 roleCode \u503c\uff1a" + roleCodeI + " \u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165");
                listSysRoles.remove(j);
                continue block3;
            }
        }
        for (i = 0; i < listSysRoles.size(); ++i) {
            Role sysRoleExcel = (Role)listSysRoles.get(i);
            try {
                super.save((Object)sysRoleExcel);
                continue;
            }
            catch (DuplicateKeyException e) {
                errorStrs.add("\u7b2c " + (i + 1) + " \u884c\u7684 roleCode \u503c\uff1a" + sysRoleExcel.getRoleCode() + " \u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (errorStrs.size() == 0) {
            return Result.ok(I18nUtil.translate("i18n_alert_QIuNLRWkuNcWW_8b4c386c", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u603b\u5bfc\u5165\u884c\u6570\uff1a${0}", String.valueOf(totalCount)));
        }
        JSONObject result = new JSONObject(5);
        result.put("totalCount", (Object)totalCount);
        result.put("errorCount", (Object)errorStrs.size());
        result.put("successCount", (Object)(errorStrs.size() - totalCount));
        result.put("msg", (Object)("\u603b\u4e0a\u4f20\u884c\u6570\uff1a" + totalCount + "\uff0c\u5df2\u5bfc\u5165\u884c\u6570\uff1a" + (errorStrs.size() - totalCount) + "\uff0c\u9519\u8bef\u884c\u6570\uff1a" + errorStrs.size()));
        String fileUrl = PmsUtil.saveErrorTxtByList(errorStrs, "roleImportExcelErrorLog");
        int lastIndex = fileUrl.lastIndexOf(File.separator);
        String fileName = fileUrl.substring(lastIndex + 1);
        result.put("fileUrl", (Object)("/sys/common/download/" + fileUrl));
        result.put("fileName", (Object)fileName);
        Result<Object> res = Result.ok(result);
        res.setCode(201);
        res.setMessage(I18nUtil.translate("i18n_alert_QIuNLRWtjNS_fd7f9f1e", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff0c\u4f46\u6709\u9519\u8bef\u3002"));
        return res;
    }

    @Override
    public List<Role> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllRole(accountList);
    }

    @Override
    public Map<String, String> loadAdminRole(List<String> toElsAccountList) {
        List<Role> roleList = ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllAdminRole(toElsAccountList);
        return roleList.stream().collect(Collectors.toMap(Role::getElsAccount, Role::getId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role getElsAccountAdminRole(String toElsAccount) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant(toElsAccount);
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Role::getElsAccount, (Object)toElsAccount)).eq(Role::getRoleCode, (Object)"companyAdmin")).last(" limit 1");
            Role role = (Role)((RoleMapper)this.baseMapper).selectOne((Wrapper)wrapper);
            return role;
        }
        finally {
            TenantContext.clear();
            if (StrUtil.isNotEmpty((CharSequence)tenant)) {
                TenantContext.setTenant(tenant);
            }
        }
    }

    @Override
    public Role getRoleByElsAccountAndSysCode(String elsAccount, String code) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Role::getElsAccount, (Object)elsAccount)).eq(Role::getRoleCode, (Object)code)).last(" limit 1");
        Role role = (Role)((RoleMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createOrGetRole(String elsAccount) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant(elsAccount);
            Role role = this.getRoleByElsAccountAndSysCode(elsAccount, "companyAdmin");
            if (role == null) {
                role = new Role();
                role.setElsAccount(elsAccount);
                role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                role.setRoleCode("companyAdmin");
                this.save(role);
            }
            Role role2 = role;
            return role2;
        }
        finally {
            TenantContext.clear();
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant(tenant);
            }
        }
    }
}

