/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractCellStyleStrategy;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelErrorExportStyle
extends AbstractCellStyleStrategy {
    protected CellStyle commonCellStyle;
    protected CellStyle redCellStyle;
    protected Workbook workbook;
    private List<ExcelDetail> detailList;

    public ExcelErrorExportStyle(List<ExcelDetail> detailList) {
        this.detailList = detailList;
    }

    protected void initCellStyle(Workbook workbook) {
        this.workbook = workbook;
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        writeCellStyle.setWriteFont(headWriteFont);
        this.commonCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle);
        WriteCellStyle redWriteCellStyle = new WriteCellStyle();
        WriteFont redWriteFont = new WriteFont();
        redWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        redWriteFont.setColor(Short.valueOf((short)10));
        redWriteCellStyle.setWriteFont(redWriteFont);
        this.redCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)redWriteCellStyle);
        WriteCellStyle writeCellStyle1 = new WriteCellStyle();
        DataFormat dataFormat = this.workbook.createDataFormat();
        writeCellStyle1.setDataFormat(Short.valueOf(dataFormat.getFormat("@")));
        StyleUtil.buildContentCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle1);
    }

    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (relativeRowIndex > 0) {
            if (cell.getStringCellValue().contains("\u975e\u5fc5\u586b")) {
                cell.setCellStyle(this.commonCellStyle);
            } else {
                cell.setCellStyle(this.redCellStyle);
            }
            cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), cell.getStringCellValue().length() * 600);
        } else {
            if (relativeRowIndex == 0 && cell.getStringCellValue().contains(I18nUtil.translate("i18n_alert_NSyRtH_5be59584", "\u9519\u8bef\u7ed3\u679c\u8bb0\u5f55"))) {
                cell.setCellStyle(this.redCellStyle);
                cell.getCellStyle().setWrapText(true);
                cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), cell.getStringCellValue().length() * 1000);
                return;
            }
            if (cell.getStringCellValue().contains(I18nUtil.translate("i18n_alert_GvzE_2a38a70d", "\u5904\u7406\u72b6\u6001"))) {
                cell.setCellStyle(this.redCellStyle);
                return;
            }
            cell.setCellStyle(this.commonCellStyle);
        }
    }

    protected void setContentCellStyle(Cell cell, Head head, Integer integer) {
    }
}

