/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHeadHis;
import com.els.modules.template.entity.TemplateConfigItemHis;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHeadHis;
import com.els.modules.template.service.TemplateConfigHeadHisService;
import com.els.modules.template.service.TemplateConfigItemHisService;
import com.els.modules.template.service.TemplateGroupHisService;
import com.els.modules.template.service.TemplateHeadHisService;
import com.els.modules.template.vo.TemplateHeadHisVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/template/templateHeadHis"})
@Api(tags={"\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2"})
public class TemplateHeadHisController
extends BaseController<TemplateHeadHis, TemplateHeadHisService> {
    private static final Logger log = LoggerFactory.getLogger(TemplateHeadHisController.class);
    @Autowired
    private TemplateHeadHisService templateHeadHisService;
    @Autowired
    private TemplateGroupHisService templateGroupHisService;
    @Autowired
    private TemplateConfigHeadHisService templateConfigHeadHisService;
    @Autowired
    private TemplateConfigItemHisService templateConfigItemHisService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TemplateHeadHis templateHeadHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<TemplateHeadHis> queryWrapper = QueryGenerator.initQueryWrapper(templateHeadHis, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.templateHeadHisService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TemplateHeadHisVO templateHeadHisPage) {
        TemplateHeadHis templateHeadHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)templateHeadHisPage, (Object)templateHeadHis);
        this.templateHeadHisService.saveMain(templateHeadHis, templateHeadHisPage.getTemplateGroupHisList(), templateHeadHisPage.getTemplateConfigHeadHisList(), templateHeadHisPage.getTemplateConfigItemHisList());
        return Result.ok(templateHeadHis);
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TemplateHeadHisVO templateHeadHisPage) {
        TemplateHeadHis templateHeadHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)templateHeadHisPage, (Object)templateHeadHis);
        this.templateHeadHisService.updateMain(templateHeadHis, templateHeadHisPage.getTemplateGroupHisList(), templateHeadHisPage.getTemplateConfigHeadHisList(), templateHeadHisPage.getTemplateConfigItemHisList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.templateHeadHisService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.templateHeadHisService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        TemplateHeadHis templateHeadHis = (TemplateHeadHis)this.templateHeadHisService.getById((Serializable)((Object)id));
        TemplateHeadHisVO templateHeadHisVO = new TemplateHeadHisVO();
        BeanUtils.copyProperties((Object)templateHeadHis, (Object)templateHeadHisVO);
        List<TemplateGroupHis> templateGroupHisList = this.templateGroupHisService.selectByMainId(id);
        templateHeadHisVO.setTemplateGroupHisList(templateGroupHisList);
        List<TemplateConfigHeadHis> templateConfigHeadHisList = this.templateConfigHeadHisService.selectByMainId(id);
        templateHeadHisVO.setTemplateConfigHeadHisList(templateConfigHeadHisList);
        List<TemplateConfigItemHis> templateConfigItemHisList = this.templateConfigItemHisService.selectByMainId(id);
        templateHeadHisVO.setTemplateConfigItemHisList(templateConfigItemHisList);
        return Result.ok(templateHeadHisVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4\u5386\u53f2", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4\u5386\u53f2")
    @GetMapping(value={"/queryTemplateGroupHisByMainId"})
    public Result<?> queryTemplateGroupHisListByMainId(@RequestParam(name="id", required=true) String id) {
        List<TemplateGroupHis> templateGroupHisList = this.templateGroupHisService.selectByMainId(id);
        return Result.ok(templateGroupHisList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5934\u4fe1\u606f\u5386\u53f2", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5934\u4fe1\u606f\u5386\u53f2")
    @GetMapping(value={"/queryTemplateConfigHeadHisByMainId"})
    public Result<?> queryTemplateConfigHeadHisListByMainId(@RequestParam(name="id", required=true) String id) {
        List<TemplateConfigHeadHis> templateConfigHeadHisList = this.templateConfigHeadHisService.selectByMainId(id);
        return Result.ok(templateConfigHeadHisList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868\u5386\u53f2", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2id\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868\u5386\u53f2")
    @GetMapping(value={"/queryTemplateConfigItemHisByMainId"})
    public Result<?> queryTemplateConfigItemHisListByMainId(@RequestParam(name="id", required=true) String id) {
        List<TemplateConfigItemHis> templateConfigItemHisList = this.templateConfigItemHisService.selectByMainId(id);
        return Result.ok(templateConfigItemHisList);
    }

    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, TemplateHeadHis templateHeadHis, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<TemplateHeadHis> queryWrapper = QueryGenerator.initQueryWrapper(templateHeadHis, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, templateHeadHis);
            queryWrapper.in((Object)"id", selectionList);
        }
        ArrayList<TemplateHeadHisVO> pageList = new ArrayList<TemplateHeadHisVO>();
        List templateHeadHisList = this.templateHeadHisService.list((Wrapper)queryWrapper);
        for (TemplateHeadHis temp : templateHeadHisList) {
            TemplateHeadHisVO vo = new TemplateHeadHisVO();
            BeanUtils.copyProperties((Object)temp, (Object)vo);
            List<TemplateGroupHis> templateGroupHisList = this.templateGroupHisService.selectByMainId(temp.getId());
            vo.setTemplateGroupHisList(templateGroupHisList);
            List<TemplateConfigHeadHis> templateConfigHeadHisList = this.templateConfigHeadHisService.selectByMainId(temp.getId());
            vo.setTemplateConfigHeadHisList(templateConfigHeadHisList);
            List<TemplateConfigItemHis> templateConfigItemHisList = this.templateConfigItemHisService.selectByMainId(temp.getId());
            vo.setTemplateConfigItemHisList(templateConfigItemHisList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2");
        mv.addObject("entity", TemplateHeadHisVO.class);
        mv.addObject("params", (Object)new ExportParams("\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u5386\u53f2", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<TemplateHeadHisVO> list = ExcelImportUtil.importExcel(file.getInputStream(), TemplateHeadHisVO.class, params);
                for (TemplateHeadHisVO page : list) {
                    TemplateHeadHis po = new TemplateHeadHis();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    this.templateHeadHisService.saveMain(po, page.getTemplateGroupHisList(), page.getTemplateConfigHeadHisList(), page.getTemplateConfigItemHisList());
                }
                Result<Object> result = Result.ok(I18nUtil.translate("i18n_alert_QIuNLRWWFcW_6e8a1fc", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", String.valueOf(list.size())));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }
}

