/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.Log;
import com.els.modules.system.service.LogService;
import com.els.modules.system.vo.LogVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/log"})
@Api(tags={"\u7cfb\u7edf\u65e5\u5fd7"})
public class LogController
extends BaseController<Log, LogService> {
    private static final Logger log = LoggerFactory.getLogger(LogController.class);
    @Autowired
    private LogService logService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<Log>> queryPageList(Log syslog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String queryString;
        Result<IPage<Log>> result = new Result<IPage<Log>>();
        QueryWrapper<Log> queryWrapper = QueryGenerator.initQueryWrapper(syslog, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String keyWord = req.getParameter("keyWord");
        if (ConvertUtils.isNotEmpty(keyWord)) {
            queryWrapper.like((Object)"log_content", (Object)keyWord);
        }
        if (!(queryString = req.getQueryString()).contains("keyWord")) {
            String elsAccount = this.getTenantId();
            String subAccount = this.getCurrentUser().getSubAccount();
            ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)elsAccount)).eq((Object)"userid", (Object)subAccount);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.logService.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2")
    @GetMapping(value={"/queryOptHisList"})
    public Result<?> queryOptHisList(Log log, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<Log> queryWrapper = QueryGenerator.initQueryWrapper(log, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.orderByDesc((Object)"create_time");
        IPage pageList = this.logService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u4f9b\u5e94\u5546\u767b\u5f55\u7edf\u8ba1\u5217\u8868", notes="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u4f9b\u5e94\u5546\u767b\u5f55\u7edf\u8ba1\u5217\u8868")
    @GetMapping(value={"/querySupplierLoginList"})
    public Result<?> querySupplierLoginList(LogVO logVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        logVO.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        logVO.setPageSize(pageSize);
        logVO.setElsAccount(this.getTenantId());
        IPage<LogVO> pageList = this.logService.findSupplierLoginList(logVO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u6a21\u5757\u4f7f\u7528\u60c5\u51b5\u5217\u8868", notes="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u6a21\u5757\u4f7f\u7528\u60c5\u51b5\u5217\u8868")
    @GetMapping(value={"/findModuleOptList"})
    public Result<?> findModuleOptList(LogVO logVO, HttpServletRequest req) {
        logVO.setElsAccount(this.getTenantId());
        List<LogVO> pageList = this.logService.findModuleOptList(logVO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u7528\u6237\u767b\u5f55\u60c5\u51b5\u5217\u8868", notes="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u7528\u6237\u767b\u5f55\u60c5\u51b5\u5217\u8868")
    @GetMapping(value={"/findUserLoginList"})
    public Result<?> findUserLoginList(LogVO logVO, HttpServletRequest req) {
        logVO.setElsAccount(this.getTenantId());
        List<LogVO> pageList = this.logService.findUserLoginList(logVO);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u64cd\u4f5c\u65e5\u8bb0-\u5bfc\u51faExcel", logType=2, operateType=6)
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(Log log, HttpServletRequest request) {
        request.setAttribute("exportLimit", (Object)500000);
        return this.exportFilterXls(request, log, Log.class, "\u64cd\u4f5c\u65e5\u8bb0\u6570\u636e");
    }

    protected ModelAndView exportFilterXls(HttpServletRequest request, Log object, Class<Log> clazz, String title) {
        String queryString;
        QueryWrapper<Log> queryWrapper = QueryGenerator.initQueryWrapper(object, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String keyWord = request.getParameter("keyWord");
        if (ConvertUtils.isNotEmpty(keyWord)) {
            queryWrapper.like((Object)"log_content", (Object)keyWord);
        }
        if (!(queryString = request.getQueryString()).contains("keyWord")) {
            String elsAccount = this.getTenantId();
            String subAccount = this.getCurrentUser().getSubAccount();
            ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)elsAccount)).eq((Object)"userid", (Object)subAccount);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        this.exportSelectionsFilter(request, queryWrapper);
        if (null != request.getAttribute("exportLimit")) {
            queryWrapper.last(" limit " + (Integer)request.getAttribute("exportLimit"));
        }
        List exportList = ((LogService)this.service).list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)title);
        mv.addObject("entity", clazz);
        String defineColumn = request.getParameter("defineColumnCode");
        mv.addObject("params", (Object)new ExportParams(title + "\u62a5\u8868", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title, defineColumn));
        mv.addObject("data", (Object)exportList);
        return mv;
    }
}

