/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.export.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ColumnDefineExcelExportUtil;
import com.els.framework.poi.excel.DictEntity;
import com.els.framework.poi.excel.ExcelCollectionEntity;
import com.els.framework.poi.excel.ExcelEntity;
import com.els.framework.poi.excel.ExcelExportClassColumnDTO;
import com.els.framework.poi.excel.TemplateColumnEntity;
import com.els.framework.poi.excel.annotation.Excel;
import com.els.framework.poi.excel.entity.ExportFieldAnalysisParams;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateConfigHeadVO;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateConfigItemVO;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateGroupVO;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.framework.poi.excel.entity.vo.ExcelUserColumnDefineVO;
import com.els.framework.poi.handler.inter.IExcelDataHandler;
import com.els.framework.poi.util.PoiPublicUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ColumnDefineExportBase {
    protected IExcelDataHandler dataHanlder;
    protected List<String> needHanlderList;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    private ExcelExportEntity createExcelExportEntity(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(excel.type());
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfConfigHead(String targetId, ExcelExportClassColumnDTO fieldColumn, ExcelTemplateConfigHeadVO templateHead) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(excelEntity, fieldColumn);
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(templateHead.getSortOrder()), targetId));
        String format = this.dateFormat(templateHead.getDataFormat(), templateHead.getFieldType(), fieldColumn);
        excelEntity.setFormat(format);
        if (StrUtil.isNotBlank((CharSequence)templateHead.getFieldLabel())) {
            excelEntity.setName(this.getExcelName(templateHead.getFieldLabel(), targetId));
        }
        ExcelExportClassColumnDTO columnDTO = (ExcelExportClassColumnDTO)Convert.convert(ExcelExportClassColumnDTO.class, (Object)fieldColumn);
        TemplateColumnEntity templateColumnEntity = (TemplateColumnEntity)Convert.convert(TemplateColumnEntity.class, (Object)templateHead);
        columnDTO.setTemplateColumnEntity(templateColumnEntity);
        excelEntity.setFieldColumn(columnDTO);
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfConfigItem(String targetId, ExcelExportClassColumnDTO fieldColumn, ExcelTemplateConfigItemVO templateItem) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(excelEntity, fieldColumn);
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(templateItem.getSortOrder()), targetId));
        String format = this.dateFormat(templateItem.getDataFormat(), templateItem.getFieldType(), fieldColumn);
        excelEntity.setFormat(format);
        String name = templateItem.getFieldLabel();
        ExcelEntity excel = fieldColumn.getExcel();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            if (name.startsWith("class_field_name_")) {
                name = null != excel ? excelEntity.getName() : name.substring(name.indexOf("class_field_name_") + "class_field_name_".length());
            }
        } else {
            name = fieldColumn.getFileName();
        }
        excelEntity.setName(this.getExcelName(name, targetId));
        ExcelExportClassColumnDTO columnDTO = (ExcelExportClassColumnDTO)Convert.convert(ExcelExportClassColumnDTO.class, (Object)fieldColumn);
        TemplateColumnEntity templateColumnEntity = (TemplateColumnEntity)Convert.convert(TemplateColumnEntity.class, (Object)templateItem);
        columnDTO.setTemplateColumnEntity(templateColumnEntity);
        excelEntity.setFieldColumn(columnDTO);
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfDefineColumn(String targetId, ExcelExportClassColumnDTO fieldColumn, ExcelUserColumnDefineVO column) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(excelEntity, fieldColumn);
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(column.getSort()), targetId));
        String format = this.dateFormat(column.getDataFormat(), column.getFieldType(), fieldColumn);
        excelEntity.setFormat(format);
        if (StrUtil.isNotBlank((CharSequence)column.getColumnName())) {
            excelEntity.setName(this.getExcelName(column.getColumnName(), targetId));
        }
        excelEntity.setFieldColumn(fieldColumn);
        return excelEntity;
    }

    private String dateFormat(String format, String filetype, ExcelExportClassColumnDTO fieldColumn) {
        try {
            if (StrUtil.isNotBlank((CharSequence)format) && format.startsWith("yyyy-MM-dd")) {
                return format;
            }
            String columnFormat = fieldColumn.getFileType().toLowerCase();
            if (StrUtil.isNotBlank((CharSequence)filetype)) {
                if (filetype.toLowerCase().equals("date") || columnFormat.equals("date") && !filetype.toLowerCase().contains("datetime")) {
                    format = "yyyy-MM-dd";
                } else if (filetype.toLowerCase().contains("datetime") || columnFormat.contains("datetime")) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
            return format;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void getExcelFieldByColumnAndExcel(ExcelExportEntity excelEntity, ExcelExportClassColumnDTO fieldColumn) throws Exception {
        ExcelEntity excel = fieldColumn.getExcel();
        if (null == excel) {
            excel = new ExcelEntity();
            Excel ex = ExcelAnnotation.class.getDeclaredField("excel").getAnnotation(Excel.class);
            excel.buildExcelEntity(ex);
        }
        excelEntity.setWidth(excel.getWidth());
        excelEntity.setHeight(excel.getHeight());
        excelEntity.setNeedMerge(excel.isNeedMerge());
        excelEntity.setMergeVertical(excel.isMergeVertical());
        excelEntity.setMergeRely(excel.getMergeRely());
        excelEntity.setReplace(excel.getReplace());
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.getExportType());
        excelEntity.setSuffix(excel.getSuffix());
        excelEntity.setDatabaseFormat(excel.getDatabaseFormat());
        excelEntity.setStatistics(excel.isStatistics());
        excelEntity.setKey(fieldColumn.getFileName());
        excelEntity.setMultiReplace(excel.isMultiReplace());
        excelEntity.setName(excel.getName());
    }

    private Object formatValue(Object value, ExcelExportEntity entity, ExcelEntity excel, TemplateColumnEntity templateColumnEntity, ExcelExportClassColumnDTO fieldColumn) throws Exception {
        if (null == value) {
            return value;
        }
        try {
            String format;
            String string = format = null == excel ? "" : excel.getFormat();
            if (null != templateColumnEntity && StrUtil.isNotEmpty((CharSequence)templateColumnEntity.getDataFormat())) {
                format = templateColumnEntity.getDataFormat();
            }
            if (StrUtil.isEmpty((CharSequence)format)) {
                format = entity.getFormat();
            }
            if (value instanceof Date || fieldColumn.getFileType().contains("date")) {
                if (StrUtil.isEmpty((CharSequence)format)) {
                    format = entity.getDatabaseFormat();
                }
                Date d = null;
                d = value instanceof Long ? new Date((Long)value) : (Date)value;
                SimpleDateFormat formatData = new SimpleDateFormat(format);
                value = formatData.format(d);
            } else if (value instanceof BigDecimal) {
                if (StrUtil.isEmpty((CharSequence)format)) {
                    return value;
                }
                DecimalFormat df2 = new DecimalFormat(format);
                value = df2.format(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void filterExcelFieldByColumnDefine(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, List<ExcelUserColumnDefineVO> userColumnDefine, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        HashMap defineColumnList = Maps.newHashMap();
        int size = userColumnDefine.size();
        for (int index = 0; index < size; ++index) {
            ExcelUserColumnDefineVO defineVO = userColumnDefine.get(index);
            if (defineVO.getHidden() != 0) continue;
            String columnCode = defineVO.getColumnCode();
            defineVO.setColumnCode(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            defineVO.setColumnName(defineVO.getColumnName());
            defineVO.setSort(index - 1 - size);
            defineColumnList.put(defineVO.getColumnCode(), defineVO);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, defineVO.getColumnName());
            if (!exist) continue;
            defineColumnList.remove(defineVO.getColumnCode());
        }
        for (String c : defineColumnList.keySet()) {
            ExcelUserColumnDefineVO defineVO = (ExcelUserColumnDefineVO)defineColumnList.get(c);
            ExcelExportClassColumnDTO fieldColumn = classColumnList.get(defineVO.getColumnCode());
            if (null == fieldColumn) continue;
            excelParams.add(this.createExcelExportEntityOfDefineColumn(targetId, fieldColumn, defineVO));
        }
    }

    public void filterExcelFieldByTemplateHead(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, ExcelTemplateHeadVO templateHeadVO, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        List<ExcelTemplateConfigHeadVO> columnList = templateHeadVO.getTemplateConfigHeadList();
        HashMap defineColumnList = Maps.newHashMap();
        int size = columnList.size();
        for (int index = 0; index < size; ++index) {
            ExcelTemplateConfigHeadVO head = columnList.get(index);
            if ("0".equals(head.getPurchaseShow()) && "0".equals(head.getSaleShow())) continue;
            String columnCode = head.getFieldName();
            head.setFieldName(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            head.setFieldLabel(head.getFieldLabel());
            head.setSortOrder(index - 1 - size);
            defineColumnList.put(head.getFieldName(), head);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, head.getFieldName());
            if (!exist) continue;
            defineColumnList.remove(head.getFieldName());
        }
        ArrayList collectionField = Lists.newArrayList();
        for (ExcelTemplateConfigHeadVO c : columnList) {
            ExcelExportClassColumnDTO columnDTO;
            if (defineColumnList.containsKey(c.getFieldName())) {
                ExcelTemplateConfigHeadVO configHead = (ExcelTemplateConfigHeadVO)defineColumnList.get(c.getFieldName());
                ExcelExportClassColumnDTO fieldColumn = classColumnList.get(configHead.getFieldName());
                if (null == fieldColumn) continue;
                excelParams.add(this.createExcelExportEntityOfConfigHead(targetId, fieldColumn, configHead));
            }
            if (null == (columnDTO = classColumnList.get(c.getFieldName())) || !BooleanUtil.isTrue((Boolean)columnDTO.getCollection())) continue;
            collectionField.add(columnDTO);
        }
        List group = classColumnList.values().stream().filter(x -> BooleanUtil.isTrue((Boolean)x.getCollection())).collect(Collectors.toList());
        int gSize = group.size();
        for (int i = gSize - 1; i >= 0; --i) {
            this.filterCollectionColumn(targetId, (ExcelExportClassColumnDTO)group.get(i), excelParams, fieldAnalysisParams, templateHeadVO);
        }
    }

    public void filterExcelFieldByTemplateItem(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, List<ExcelTemplateConfigItemVO> columnList, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        if (CollUtil.isEmpty(columnList)) {
            return;
        }
        HashMap defineColumnList = Maps.newHashMap();
        columnList.sort(Comparator.nullsLast(Comparator.comparing(ExcelTemplateConfigItemVO::getSortOrder, Comparator.nullsLast(Integer::compareTo))));
        int size = columnList.size();
        for (int index = 0; index < size; ++index) {
            ExcelTemplateConfigItemVO head = (ExcelTemplateConfigItemVO)Convert.convert(ExcelTemplateConfigItemVO.class, (Object)columnList.get(index));
            if ("0".equals(head.getPurchaseShow()) && "0".equals(head.getSaleShow())) continue;
            String columnCode = head.getFieldName();
            head.setFieldName(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            head.setFieldLabel(head.getFieldLabel());
            head.setSortOrder(index - 1 - size);
            defineColumnList.put(head.getFieldName(), head);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, head.getFieldName());
            if (!exist) continue;
            defineColumnList.remove(head.getFieldName());
        }
        for (String key : defineColumnList.keySet()) {
            ExcelTemplateConfigItemVO templateConfigItem = (ExcelTemplateConfigItemVO)defineColumnList.get(key);
            ExcelExportClassColumnDTO fieldColumn = classColumnList.get(key);
            if (null == fieldColumn) continue;
            excelParams.add(this.createExcelExportEntityOfConfigItem(targetId, fieldColumn, templateConfigItem));
        }
    }

    private void filterCollectionColumn(String targetId, ExcelExportClassColumnDTO column, List<ExcelExportEntity> excelParams, ExportFieldAnalysisParams fieldAnalysisParams, ExcelTemplateHeadVO templateHeadVO) throws Exception {
        ExcelTemplateConfigItemVO item;
        int i;
        Map<String, ExcelExportClassColumnDTO> classColumnList;
        ExcelCollectionEntity excel = column.getExcelCollection();
        List<ExcelExportClassColumnDTO> childrenColumn = column.getChildren();
        List<ExcelTemplateGroupVO> templateGroupList = templateHeadVO.getTemplateGroupList();
        String fileName = column.getFileName();
        ExcelTemplateGroupVO g = null;
        boolean createGroup = false;
        for (ExcelTemplateGroupVO group : templateGroupList) {
            if (!fileName.equals(group.getGroupCode())) continue;
            g = group;
            break;
        }
        if (null == g) {
            createGroup = true;
            g = new ExcelTemplateGroupVO();
            g.setGroupName(column.getFileName());
            g.setGroupCode(column.getFileName());
            if (null != excel && CharSequenceUtil.isNotEmpty((CharSequence)excel.getName())) {
                g.setGroupName(excel.getName());
            }
            g.setSortOrder(null);
        }
        if (CollUtil.isEmpty(classColumnList = childrenColumn.stream().collect(Collectors.toMap(ExcelExportClassColumnDTO::getFileName, Function.identity(), (v1, v2) -> v2)))) {
            return;
        }
        List<String> removeKey = this.collectionColumnIgnore(createGroup, excel, classColumnList);
        List<ExcelTemplateConfigItemVO> templateConfigItemList = templateHeadVO.getTemplateConfigItemList();
        List<ExcelTemplateConfigItemVO> itemList = null;
        if (CollUtil.isNotEmpty(templateConfigItemList)) {
            itemList = templateConfigItemList.stream().filter(x -> column.getFileName().equals(x.getGroupCode())).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(itemList)) {
            itemList = childrenColumn.stream().filter(x -> null != x.getExcel() && !x.getExcel().isIgnore() && !BooleanUtil.isTrue((Boolean)x.getCollection())).map(x -> {
                ExcelTemplateConfigItemVO t = new ExcelTemplateConfigItemVO();
                ExcelEntity excel1 = x.getExcel();
                t.setFieldName(x.getFileName());
                t.setFieldType(x.getFileType());
                t.setSortOrder(CharSequenceUtil.isNotBlank((CharSequence)excel1.getOrderNum()) ? Integer.valueOf(Integer.parseInt(excel1.getOrderNum())) : null);
                t.setGroupCode(column.getFileName());
                t.setFieldLabel("class_field_name_" + CharSequenceUtil.blankToDefault((CharSequence)excel1.getName(), (String)x.getFileName()));
                return t;
            }).collect(Collectors.toList());
        }
        int size = itemList.size();
        for (i = size - 1; i >= 0; --i) {
            item = (ExcelTemplateConfigItemVO)itemList.get(i);
            if (!removeKey.contains(item.getFieldName())) continue;
            itemList.remove(i);
        }
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        for (i = 0; i < itemList.size(); ++i) {
            item.setSortOrder(null == (item = (ExcelTemplateConfigItemVO)itemList.get(i)).getSortOrder() ? i : item.getSortOrder());
        }
        ArrayList list = Lists.newArrayList();
        targetId = null != excel && StrUtil.isNotEmpty((CharSequence)excel.getId()) ? excel.getId() : targetId;
        fieldAnalysisParams.setExcelCollectionEntity(column.getExcelCollection());
        this.filterExcelFieldByTemplateItem(targetId, list, classColumnList, itemList, fieldAnalysisParams);
        if (CollUtil.isEmpty((Collection)list)) {
            return;
        }
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setName(this.getExcelName(g.getGroupName(), targetId));
        excelEntity.setOrderNum(this.getCellOrder(null == g.getSortOrder() ? "" : g.getSortOrder() + "", targetId));
        excelEntity.setKey(column.getFileName());
        excelEntity.setList(list);
        excelParams.add(excelEntity);
    }

    private List<String> collectionColumnIgnore(boolean createGroup, ExcelCollectionEntity excel, Map<String, ExcelExportClassColumnDTO> classColumnList) {
        ArrayList removeKey = Lists.newArrayList();
        if (null != excel && createGroup) {
            String[] ignorePres = excel.getIgnorePrefix();
            for (int i = 0; i < ignorePres.length; ++i) {
                Set<String> keyColumn = classColumnList.keySet();
                for (String f : keyColumn) {
                    if (!StrUtil.isNotBlank((CharSequence)f) || !f.startsWith(ignorePres[i])) continue;
                    removeKey.add(f);
                }
            }
        }
        return removeKey;
    }

    private boolean columnFilterCheck(ExportFieldAnalysisParams fieldAnalysisParams, String columnTitle) {
        boolean exist = false;
        if (StrUtil.isNotBlank((CharSequence)fieldAnalysisParams.getTargetTitleKey())) {
            Set defaultColumnTitle;
            Map columnFilterTitleMap = fieldAnalysisParams.getColumnFilterTitleMap();
            ExcelCollectionEntity excelCollection = fieldAnalysisParams.getExcelCollectionEntity();
            columnFilterTitleMap = (Map)ObjectUtil.defaultIfNull(columnFilterTitleMap, (Object)Maps.newHashMap());
            if (null == excelCollection) {
                String titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + "default-key";
                defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                exist = defaultColumnTitle.contains(columnTitle);
            } else {
                ExcelCollectionEntity.ColumnTitleFilterType titleFilterType = excelCollection.getColumnTitleFilterType();
                String titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + fieldAnalysisParams.getTargetTitleKey();
                switch (titleFilterType) {
                    case ALL: {
                        exist = columnFilterTitleMap.values().stream().flatMap(Collection::stream).anyMatch(x -> x.equals(columnTitle));
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        break;
                    }
                    case NEVER: {
                        titleKey = fieldAnalysisParams.getLastTargetTitleKey() + "-" + fieldAnalysisParams.getTargetTitleKey();
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        break;
                    }
                    case DIS_LEVEL: {
                        Set temColumnTitle = columnFilterTitleMap.computeIfAbsent("-default-key", k -> Sets.newHashSet());
                        defaultColumnTitle = columnFilterTitleMap.computeIfAbsent(titleKey, k -> Sets.newHashSet());
                        exist = temColumnTitle.contains(columnTitle) && defaultColumnTitle.contains(columnTitle);
                        break;
                    }
                    default: {
                        defaultColumnTitle = Sets.newHashSet();
                    }
                }
            }
            if (!exist) {
                defaultColumnTitle.add(columnTitle);
            }
        }
        return exist;
    }

    public int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (this.isInteger(orderNum) && targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            String[] temp = str.split("_");
            if (temp.length <= 1 || !targetId.equals(temp[1])) continue;
            return Integer.valueOf(temp[0]);
        }
        return 0;
    }

    public Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object entityValue;
        Object value = null;
        if (obj instanceof JSONObject) {
            entityValue = ((JSONObject)obj).get(entity.getKey());
            value = this.getDictFieldValue(entityValue, entity, obj);
        } else if (obj instanceof Map) {
            value = ((Map)obj).get(entity.getKey());
        } else {
            entityValue = ((JSONObject)obj).get(entity.getKey());
            value = this.getDictFieldValue(entityValue, entity, obj);
        }
        ExcelEntity excel = entity.getFieldColumn().getExcel();
        TemplateColumnEntity templateColumnEntity = entity.getFieldColumn().getTemplateColumnEntity();
        if (StrUtil.isNotEmpty((CharSequence)entity.getFormat()) || null != excel || null != templateColumnEntity) {
            value = this.formatValue(value, entity, excel, templateColumnEntity, entity.getFieldColumn());
        }
        if (entity.getReplace() != null && entity.getReplace().length > 0) {
            if (value == null) {
                value = "";
            }
            value = entity.isMultiReplace() ? this.multiReplaceValue(entity.getReplace(), String.valueOf(value)) : this.replaceValue(entity.getReplace(), String.valueOf(value));
        }
        if (this.needHanlderList != null && this.needHanlderList.contains(entity.getName())) {
            value = this.dataHanlder.exportHandler(obj, entity.getName(), value);
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getSuffix()) && value != null) {
            value = value + entity.getSuffix();
        }
        return value == null ? "" : value.toString();
    }

    private Object getDictFieldValue(Object entityValue, ExcelExportEntity entity, Object obj) {
        try {
            ExcelExportClassColumnDTO fieldColumn = entity.getFieldColumn();
            if (null == fieldColumn) {
                return entityValue;
            }
            TemplateColumnEntity templateColumnEntity = fieldColumn.getTemplateColumnEntity();
            if (null == fieldColumn.getDict() && (null == templateColumnEntity || CharSequenceUtil.isEmpty((CharSequence)templateColumnEntity.getDictCode()))) {
                return entityValue;
            }
            boolean config = true;
            DictEntity dictAnnotation = fieldColumn.getDict();
            String code = "";
            String text = "";
            String table = "";
            if (null != dictAnnotation) {
                code = dictAnnotation.getDicCode();
                text = dictAnnotation.getDicText();
                table = dictAnnotation.getDictTable();
                config = false;
            }
            ColumnDefineExcelExportUtil.initThreadDictMap();
            String fieldNameValue = ColumnDefineExcelExportUtil.getThreadDictMapValue().get(fieldColumn.getFileName() + "_" + entityValue);
            if (null != fieldNameValue) {
                return fieldNameValue;
            }
            JSONObject item = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
            String busAccount = item.getString("busAccount");
            if (StrUtil.isBlank((CharSequence)busAccount)) {
                busAccount = TenantContext.getTenant();
            }
            boolean isFilterSql = false;
            if (config) {
                String dictCodeText = StrUtil.emptyToDefault((CharSequence)templateColumnEntity.getDictCode(), (String)"");
                if (dictCodeText.contains("#") || dictCodeText.contains(",")) {
                    String[] params;
                    String[] stringArray = params = dictCodeText.contains("#") ? dictCodeText.split("#") : dictCodeText.split(",");
                    if (params.length >= 3) {
                        if (params.length == 4) {
                            isFilterSql = true;
                            code = params[2] + "='" + entityValue + "' and " + params[3];
                        }
                        SqlInjectionUtil.filterContent(new String[]{code, params[0], params[1], params[2]});
                        text = params[1];
                        table = params[0];
                        config = true;
                    }
                } else {
                    code = dictCodeText;
                }
            }
            if (!config && code.contains("${")) {
                StringBuffer filterSql = new StringBuffer();
                Matcher matcher = this.pattern.matcher(code);
                isFilterSql = true;
                while (matcher.find()) {
                    matcher.appendReplacement(filterSql, item.get((Object)matcher.group(1)) + "");
                }
                matcher.appendTail(filterSql);
                code = filterSql.toString();
            }
            String key = String.valueOf(entityValue);
            String textValue = this.translateDictValue(code, text, table, key, isFilterSql, busAccount);
            ColumnDefineExcelExportUtil.setThreadDictMapValue(fieldColumn.getFileName() + "_" + entityValue, textValue);
            return textValue;
        }
        catch (Exception exception) {
            return entityValue;
        }
    }

    private String translateDictValue(String code, String text, String table, String key, boolean isFilterSql, String busAccount) {
        String[] keys;
        if (StrUtil.isEmpty((CharSequence)key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String tmpValue = null;
            if (k.trim().length() == 0 || (tmpValue = isFilterSql ? SpringContextUtils.getBean(InvokeBaseRpcService.class).queryTableDictTextByFilterSqlForExcel(table, text, code, busAccount) : SpringContextUtils.getBean(InvokeBaseRpcService.class).queryDictTextByKey(code, k.trim(), busAccount)) == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }

    public Collection<?> getListCellValue(ExcelExportEntity entity, Object dataObj) throws Exception {
        Object value = dataObj instanceof Map ? ((Map)dataObj).get(entity.getKey()) : (Collection)entity.getMethod().invoke(dataObj, new Object[0]);
        return (Collection)value;
    }

    private void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(this.getExcelName(excel.name(), targetId));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        if (StrUtil.isNotEmpty((CharSequence)excel.dicCode())) {
            InvokeBaseRpcService ilsDictService = null;
            try {
                ilsDictService = SpringContextUtils.getBean(InvokeBaseRpcService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ilsDictService != null) {
                String[] dictReplace = ilsDictService.autoPoiQueryDict(excel.dictTable(), excel.dicCode(), excel.dicText());
                if (excelEntity.getReplace() != null && dictReplace != null && dictReplace.length != 0) {
                    excelEntity.setReplace(dictReplace);
                }
            }
        }
        excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setFormat(StrUtil.isNotEmpty((CharSequence)excel.exportFormat()) ? excel.exportFormat() : excel.format());
        excelEntity.setStatistics(excel.isStatistics());
        String fieldname = field.getName();
        excelEntity.setMethod(PoiPublicUtil.getMethod(fieldname, pojoClass, excel.exportConvert()));
        excelEntity.setMultiReplace(excel.multiReplace());
    }

    public String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0 || targetId == null) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    @Deprecated
    public Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    public short getRowHeight(List<ExcelExportEntity> excelParams) {
        double maxHeight = 0.0;
        for (int i = 0; i < excelParams.size(); ++i) {
            maxHeight = Math.max(maxHeight, excelParams.get(i).getHeight());
            if (excelParams.get(i).getList() == null) continue;
            for (int j = 0; j < excelParams.get(i).getList().size(); ++j) {
                maxHeight = Math.max(maxHeight, excelParams.get(i).getList().get(j).getHeight());
            }
        }
        return (short)(maxHeight * 50.0);
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private Object replaceValue(String[] replace, String value) {
        for (String str : replace) {
            String[] temp = str.split("_");
            if (!value.equals(temp[1])) continue;
            value = temp[0];
            break;
        }
        return value;
    }

    private Object multiReplaceValue(String[] replace, String value) {
        if (value.indexOf(",") > 0) {
            String[] radioVals = value.split(",");
            String result = "";
            block0: for (int i = 0; i < radioVals.length; ++i) {
                String radio = radioVals[i];
                for (String str : replace) {
                    String[] temp = str.split("_");
                    if (!radio.equals(temp[1])) continue;
                    result = result.concat(temp[0]) + ",";
                    continue block0;
                }
            }
            result = result.equals("") ? value : result.substring(0, result.length() - 1);
            return result;
        }
        return this.replaceValue(replace, value);
    }

    public void sortExportColumn(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams);
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList());
        }
    }

    static class ExcelAnnotation {
        @Excel(width=20.0)
        private String excel;

        ExcelAnnotation() {
        }
    }
}

