/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.dashboard.entity.ChartConfig;
import com.els.modules.dashboard.entity.Dashboard;
import com.els.modules.dashboard.entity.DashboardChart;
import com.els.modules.dashboard.mapper.ChartConfigMapper;
import com.els.modules.dashboard.mapper.DashboardChartMapper;
import com.els.modules.dashboard.mapper.DashboardMapper;
import com.els.modules.system.service.AbstractExcelHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardChartExcelHandler
extends AbstractExcelHandler {
    private static final Logger log = LoggerFactory.getLogger(DashboardChartExcelHandler.class);
    @Autowired
    DashboardMapper dashboardMapper;
    @Autowired
    DashboardChartMapper dashboardChartMapper;
    @Autowired
    ChartConfigMapper chartConfigMapper;

    @Override
    public void importExcel(List<Map<String, Object>> dataList) {
        Map<String, List<Map>> dashboardChartMap = ((Stream)dataList.stream().parallel()).collect(Collectors.groupingBy(data -> String.valueOf(data.get("dashboardCode"))));
        for (Map.Entry<String, List<Map>> e : dashboardChartMap.entrySet()) {
            String dashboardCode = e.getKey();
            String dashboardName = null;
            String dashboardDesc = null;
            try {
                Object obj1 = e.getValue().get(0).get("dashboardName");
                Object obj2 = e.getValue().get(0).get("dashboardDesc");
                dashboardName = obj1 != null ? String.valueOf(obj1) : null;
                dashboardDesc = obj2 != null ? String.valueOf(obj2) : null;
            }
            catch (IndexOutOfBoundsException err) {
                log.warn("dataList\u5206\u7ec4\u540e\uff0c\u6ca1\u6709\u627e\u5230\u503c\uff01");
            }
            catch (Exception err) {
                throw new ELSBootException(err.getMessage());
            }
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(Dashboard.class);
            ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(Dashboard::getDashboardCode, (Object)dashboardCode);
            Dashboard dashboard = (Dashboard)this.dashboardMapper.selectOne((Wrapper)wrapper);
            if (dashboard == null) {
                dashboard = new Dashboard();
                dashboard.setDashboardCode(dashboardCode);
                dashboard.setDashboardName(dashboardName);
                dashboard.setDashboardDesc(dashboardDesc);
            }
            LinkedList<DashboardChart> dashboardChartList = new LinkedList<DashboardChart>();
            for (Map map : e.getValue()) {
                DashboardChart dashboardChart = (DashboardChart)JSON.parseObject((String)JSON.toJSONString((Object)map), DashboardChart.class);
                String chartCode = String.valueOf(map.get("chartCode"));
                LambdaQueryWrapper chartConfigWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChartConfig.class).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ChartConfig::getChartCode, (Object)chartCode);
                ChartConfig chartConfig = (ChartConfig)Optional.ofNullable(this.chartConfigMapper.selectOne((Wrapper)chartConfigWrapper)).orElseThrow(() -> new ELSBootException("\u56fe\u8868\u914d\u7f6e\uff1a" + chartCode + "\u4e0d\u5b58\u5728\uff01"));
                dashboardChart.setChartId(chartConfig.getId());
                dashboardChartList.add(dashboardChart);
            }
            boolean newDashboardFlag = false;
            if (dashboard.getId() == null) {
                this.dashboardMapper.insert(dashboard);
                String id = ((Dashboard)Optional.ofNullable(this.dashboardMapper.selectOne((Wrapper)wrapper)).orElseThrow(() -> new ELSBootException("\u5de5\u4f5c\u53f0\u914d\u7f6e\u63d2\u5165\u51fa\u9519\uff01"))).getId();
                dashboard.setId(id);
                newDashboardFlag = true;
            }
            for (DashboardChart dashboardChart : dashboardChartList) {
                dashboardChart.setDashboardId(dashboard.getId());
            }
            if (!newDashboardFlag) {
                List chartIds = dashboardChartList.parallelStream().map(DashboardChart::getChartId).collect(Collectors.toList());
                Integer count = this.dashboardChartMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DashboardChart.class).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(DashboardChart::getDashboardId, (Object)dashboard.getId())).in(DashboardChart::getChartId, chartIds));
                if (count > 0) {
                    throw new ELSBootException("\u5bfc\u5165\u7684\u56fe\u8868\u914d\u7f6e\u6709\u91cd\u590d\uff01dashboard:" + dashboard.getDashboardCode());
                }
            }
            dashboardChartList.forEach(arg_0 -> ((DashboardChartMapper)this.dashboardChartMapper).insert(arg_0));
        }
    }
}

