/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.ThirdAccountMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.ThirdAccountService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdAccountServiceImpl
extends ServiceImpl<ThirdAccountMapper, ThirdAccount>
implements ThirdAccountService {
    @Autowired
    private ThirdAccountMapper thirdAccountMapper;
    @Autowired
    private ElsSubAccountMapper elsSubAccountMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    public void updateThirdUserId(ElsSubAccount subAccount, String thirdUserUuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        ThirdAccount account = (ThirdAccount)this.thirdAccountMapper.selectOne((Wrapper)query);
        ThirdAccount sysThirdAccount = new ThirdAccount();
        sysThirdAccount.setUserId(subAccount.getId());
        LambdaQueryWrapper thirdQuery = new LambdaQueryWrapper();
        thirdQuery.eq(ThirdAccount::getUserId, (Object)subAccount.getId());
        thirdQuery.eq(ThirdAccount::getThirdType, (Object)account.getThirdType());
        thirdQuery.eq(BaseEntity::getElsAccount, (Object)account.getElsAccount());
        ThirdAccount sysThirdAccounts = (ThirdAccount)this.thirdAccountMapper.selectOne((Wrapper)thirdQuery);
        if (sysThirdAccounts != null) {
            this.thirdAccountMapper.deleteById((Serializable)((Object)sysThirdAccounts.getId()));
        }
        this.thirdAccountMapper.update(sysThirdAccount, (Wrapper)query);
    }

    @Override
    public ElsSubAccount createUser(String phone, String thirdUserUuid, String subAccount) {
        String elsAccount = TenantContext.getTenant();
        if (StrUtil.isBlank((CharSequence)subAccount) && StrUtil.isBlank((CharSequence)(subAccount = phone))) {
            subAccount = "srm" + RandomUtil.randomNumbers((int)4);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        query.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        ThirdAccount account = (ThirdAccount)this.thirdAccountMapper.selectOne((Wrapper)query);
        ElsSubAccount user = new ElsSubAccount();
        user.setActivitiSync("0");
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setElsAccount(elsAccount);
        user.setSubAccount(subAccount);
        user.setPhone(phone);
        String salt = ConvertUtils.randomGen(8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt(elsAccount + "_" + subAccount, "123", salt);
        user.setPassword(passwordEncode);
        user.setRealname(account.getRealname());
        user.setAvatar(account.getAvatar());
        String id = this.saveThirdUser(user);
        ThirdAccount thirdAccount = new ThirdAccount();
        thirdAccount.setUserId(id);
        this.thirdAccountMapper.update(thirdAccount, (Wrapper)query);
        return user;
    }

    @Override
    public List<ThirdAccount> getThirdAccount(String busAccount, String accountId, String thirdType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdAccount::getUserId, (Object)accountId)).eq(ThirdAccount::getThirdType, (Object)thirdType)).eq(ThirdAccount::getBusAccount, (Object)busAccount);
        return ((ThirdAccountMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public ThirdAccount getThirdAccountByOpenId(String thirdUserUuid, String thirdType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdAccount::getThirdUserUuid, (Object)thirdUserUuid)).eq(ThirdAccount::getThirdType, (Object)thirdType)).last(" limit 1");
        return (ThirdAccount)((ThirdAccountMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    public String saveThirdUser(ElsSubAccount subAccount) {
        String userid = IdWorker.getIdStr();
        subAccount.setId(userid);
        this.elsSubAccountMapper.insert(subAccount);
        Role role = (Role)this.roleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(Role::getRoleCode, (Object)"thirdRole"));
        UserRole userRole = new UserRole();
        userRole.setRoleId(role.getId());
        userRole.setUserId(userid);
        this.userRoleMapper.insert(userRole);
        return userid;
    }
}

