/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.BaseService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.logic.rpc.service.SupplierContactsInfoRpcService;
import com.els.modules.logic.service.TemplateBeanService;
import com.els.modules.message.service.MsgService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class BaseServiceImpl<M extends BaseMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements BaseService<T> {
    protected MsgService getMsgService() {
        return SpringContextUtils.getBean(MsgService.class);
    }

    protected String getLoginSubAndName() {
        LoginUser user = SysUtil.getLoginUser();
        return user.getSubAccount() + "_" + user.getRealname();
    }

    protected void setHeadDefaultValue(T t) {
        Field[] fields;
        String busAccount;
        Map map = BeanUtil.beanToMap(t);
        String templateNumber = String.valueOf(map.get("templateNumber"));
        String templateVersion = String.valueOf(map.get("templateVersion"));
        String string = busAccount = map.get("templateAccount") == null ? String.valueOf(map.get("busAccount")) : String.valueOf(map.get("templateAccount"));
        if (StrUtil.isBlank((CharSequence)busAccount)) {
            busAccount = map.get("busAccount") == null ? String.valueOf(map.get("elsAccount")) : String.valueOf(map.get("busAccount"));
        }
        TemplateBeanService invokeBaseRpcService = SpringContextUtils.getBean(TemplateBeanService.class);
        Map<String, String> defaultMap = invokeBaseRpcService.getDefaultValueMap(busAccount, templateNumber, templateVersion);
        for (Field field : fields = ConvertUtils.getAllFields(t)) {
            try {
                field.setAccessible(true);
                Object value = field.get(t);
                if (value != null && !StrUtil.isBlank((CharSequence)value.toString()) || !defaultMap.containsKey(field.getName())) continue;
                field.set(t, defaultMap.get(field.getName()));
            }
            catch (Exception e) {
                this.log.error("\u53cd\u5c04\u5f02\u5e38" + e.getMessage());
            }
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, List<String> toElsAccountList, Object object, String url, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            if (loginUser == null) {
                loginUser = new LoginUser();
                String elsAccount = TenantContext.getTenant();
                ElsSubAccount userByAccount = SpringContextUtils.getBean(ElsSubAccountService.class).getUserByAccount(elsAccount);
                if (userByAccount != null) {
                    BeanUtils.copyProperties((Object)userByAccount, (Object)loginUser);
                }
            }
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getMsgContacts(toElsAccountList, businessType, operateType);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)url);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, Object object, String url, String businessType, String operateType) {
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(toElsAccount);
        this.sendMsg(purchaseElsAccount, toElsAccountList, object, url, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, Object object, String businessType, String operateType) {
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(toElsAccount);
        this.sendMsg(purchaseElsAccount, toElsAccountList, object, "", businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, Map<String, List<String>> receiveElsAccountMap, Object object, String urlParam, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            this.log.trace("::: \u53d1\u9001\u6d88\u606f:::loginUser is null : {}" + (null == loginUser));
            ArrayList<String> keys = new ArrayList<String>(receiveElsAccountMap.keySet());
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getSupplierContactsAccount(receiveElsAccountMap);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                List<String> stringList = receiveElsAccountMap.get(toElsAccount);
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                if (CollUtil.isNotEmpty(stringList)) {
                    toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                }
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)urlParam);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error(":::sendMsg failed:{}", (Throwable)e);
        }
    }

    @Override
    public void sendMsgToSubAccount(String purchaseElsAccount, Map<String, List<String>> receiveElsAccountMap, Object object, String urlParam, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            ArrayList<String> keys = new ArrayList<String>(receiveElsAccountMap.keySet());
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getMsgContacts(keys, businessType, operateType);
            Map<String, Object> receiveSubAccountMap = coreInvokeSupplierRpcService.getSupplierContactsAccount(receiveElsAccountMap);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                Object subAccountList = receiveSubAccountMap.get(toElsAccount);
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                if (null != subAccountList) {
                    toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)subAccountList));
                }
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)urlParam);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, String toElsSubAccount, Object object, String urlParam, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        if (CharSequenceUtil.isBlank((CharSequence)toElsSubAccount)) {
            toElsSubAccount = "1001";
        }
        if (toElsSubAccount.contains("_")) {
            toElsSubAccount = toElsSubAccount.split("_")[0];
        }
        toElsAccountList.add(toElsSubAccount);
        stringListHashMap.put(toElsAccount, toElsAccountList);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, urlParam, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, List<String> toElsSubAccount, Object object, String urlParam, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>();
        List collect = toElsSubAccount.parallelStream().map(item -> {
            if (item.contains("_")) {
                return item.split("_")[0];
            }
            return item;
        }).collect(Collectors.toList());
        stringListHashMap.put(toElsAccount, collect);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, urlParam, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, Map<String, List<String>> receiveElsAccountMap, Object object, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            List<String> keys = Arrays.asList(receiveElsAccountMap.keySet().toArray(new String[0]));
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getSupplierContactsAccount(receiveElsAccountMap);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                List<String> stringList = receiveElsAccountMap.get(toElsAccount);
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                if (CollUtil.isNotEmpty(stringList)) {
                    toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                }
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)"");
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, String toElsSubAccount, Object object, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(toElsSubAccount);
        stringListHashMap.put(toElsAccount, toElsAccountList);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, List<String> toElsSubAccount, Object object, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>();
        stringListHashMap.put(toElsAccount, toElsSubAccount);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, List<String> toElsAccountList, Object object, Map<String, JSONObject> receiveParamMap, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getMsgContacts(toElsAccountList, businessType, operateType);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)SysUtil.getUrlParamByJson(receiveParamMap.get(toElsAccount)));
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, Object object, Map<String, JSONObject> receiveParamMap, String businessType, String operateType) {
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(toElsAccount);
        this.sendMsg(purchaseElsAccount, toElsAccountList, object, receiveParamMap, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, Map<String, List<String>> receiveElsAccountMap, Object object, Map<String, JSONObject> receiveParamMap, String businessType, String operateType) {
        try {
            LoginUser loginUser = SysUtil.getLoginUser();
            ArrayList<String> keys = new ArrayList<String>(receiveElsAccountMap.keySet());
            SupplierContactsInfoRpcService coreInvokeSupplierRpcService = SpringContextUtils.getBean(SupplierContactsInfoRpcService.class);
            Map<String, Object> receiverMap = coreInvokeSupplierRpcService.getSupplierContactsAccount(receiveElsAccountMap);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiveElsAccountMap.keySet()) {
                List<String> stringList = receiveElsAccountMap.get(toElsAccount);
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString(stringList));
                if (CollUtil.isNotEmpty(stringList)) {
                    toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)));
                }
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)SysUtil.getUrlParamByJson(receiveParamMap.get(toElsAccount)));
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, String toElsSubAccount, Object object, Map<String, JSONObject> receiveParamMap, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>(1);
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        if (CharSequenceUtil.isBlank((CharSequence)toElsSubAccount)) {
            toElsSubAccount = "1001";
        }
        if (toElsSubAccount.contains("_")) {
            toElsSubAccount = toElsSubAccount.split("_")[0];
        }
        toElsAccountList.add(toElsSubAccount);
        stringListHashMap.put(toElsAccount, toElsAccountList);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, receiveParamMap, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, String toElsAccount, List<String> toElsSubAccount, Object object, Map<String, JSONObject> receiveParamMap, String businessType, String operateType) {
        HashMap<String, List<String>> stringListHashMap = new HashMap<String, List<String>>(1);
        List collect = toElsSubAccount.parallelStream().map(item -> {
            if (item.contains("_")) {
                return item.split("_")[0];
            }
            return item;
        }).collect(Collectors.toList());
        stringListHashMap.put(toElsAccount, collect);
        this.sendMsg(purchaseElsAccount, stringListHashMap, object, receiveParamMap, businessType, operateType);
    }

    @Override
    public void sendMsg(String purchaseElsAccount, ElsSubAccount subAccount, String urlParam, Object object, String businessType, String operateType) {
        try {
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON(object));
            msgObj.put("sendObj", (Object)SysUtil.getLoginUser());
            JSONArray array = new JSONArray();
            JSONArray toSubAccountArray = new JSONArray();
            JSONObject toSubAccount = new JSONObject();
            BeanUtil.copyProperties((Object)subAccount, (Object)toSubAccount, (String[])new String[0]);
            toSubAccountArray.add((Object)toSubAccount);
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("toElsAccount", (Object)subAccount.getElsAccount());
            receiveObj.put("urlParam", (Object)urlParam);
            receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
            array.add((Object)receiveObj);
            msgObj.put("receiveList", (Object)array);
            this.getMsgService().sendMsg(msgObj);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }
}

