/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.logic.service.AccountRpcService;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.ReceiveTypeEnum;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgParamsVO;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.util.I18nUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MsgServiceImpl
implements MsgService {
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Autowired
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Autowired
    private PersonalSettingService personalSettingService;
    @Resource
    private AccountRpcService accountRpcService;

    @Async
    @Deprecated
    public void sendMsg(List<ElsMsgConfigItem> configItemList, String businessType, String operateType, MsgParamsVO paramsVO) {
    }

    @Async
    @Deprecated
    public void sendMsg(String purchaseElsAccount, String businessType, String operateType, MsgParamsVO paramsVO) {
        try {
            List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(purchaseElsAccount, businessType, operateType);
            if (configItemList.isEmpty()) {
                return;
            }
            this.sendMsg(configItemList, businessType, operateType, paramsVO);
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Deprecated
    private List<ElsMsgConfigItem> getMsgConfigItemList(String purchaseElsAccount, String businessType, String operateType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)purchaseElsAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            queryWrapper.clear();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)"100000");
            configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        }
        Assert.notEmpty((Collection)configHeadList, (String)I18nUtil.translate("i18n_alert_LYuXHERW_44d10b7d", "\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e\uff01"));
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        ArrayList<ElsMsgConfigItem> resultList = new ArrayList<ElsMsgConfigItem>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add(item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }

    private List<String> processData(List<PersonalSetting> personalSettings) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SendMsgTypeEnum.IN_MSG.getType());
        for (PersonalSetting personalSetting : personalSettings) {
            if (ReceiveTypeEnum.EMAIL.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.EMAIL.getType());
                continue;
            }
            if (ReceiveTypeEnum.MSG.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.SMS.getType());
                continue;
            }
            if (ReceiveTypeEnum.NEWS.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.IN_MSG.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT_EP.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX_EP.getType());
                list.add(SendMsgTypeEnum.WX_EP_DEVELOP.getType());
                continue;
            }
            if (ReceiveTypeEnum.DINGTALK.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.DINGTALK.getType());
                continue;
            }
            if (!ReceiveTypeEnum.FEISHU.getValue().equals(personalSetting.getReceiveType())) continue;
            list.add(SendMsgTypeEnum.FEISHU.getType());
        }
        return list;
    }

    @Override
    public void sendMsg(JSONObject msg1) {
        JSONObject msg = JSONObject.parseObject((String)msg1.toJSONString());
        String busAccount = msg.getString("busAccount");
        String businessType = msg.getString("businessType");
        String operateType = msg.getString("operateType");
        String msgConfigHeadId = msg.getString("msgConfigHeadId");
        ArrayList busAccountList = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])new String[]{"100000", busAccount}));
        JSONObject businessObj = msg.getJSONObject("businessObj");
        ElsSubAccount sendAccount = (ElsSubAccount)msg.getObject("sendObj", ElsSubAccount.class);
        JSONArray receiveArray = msg.getJSONArray("receiveList");
        for (Object obj : receiveArray) {
            JSONObject receiveObj = (JSONObject)obj;
            String toElsAccount = receiveObj.getString("toElsAccount");
            String urlParam = receiveObj.getString("urlParam");
            JSONArray toSubAccountArray = receiveObj.getJSONArray("toSubAccountList");
            for (Object subObj : toSubAccountArray) {
                Object receiveAccountItemList;
                ElsSubAccount receive = (ElsSubAccount)JSONObject.parseObject((String)((JSONObject)subObj).toJSONString(), ElsSubAccount.class);
                List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(msgConfigHeadId, busAccountList, businessType, operateType);
                if (configItemList.isEmpty()) {
                    return;
                }
                ArrayList<ElsMsgConfigItem> currentConfigItemList = new ArrayList<ElsMsgConfigItem>(configItemList);
                if (CharSequenceUtil.isEmpty((CharSequence)msgConfigHeadId) && !busAccountList.contains(receive.getElsAccount()) && CollectionUtil.isNotEmpty((Collection)(receiveAccountItemList = this.getMsgConfigItemListByBusAccount(msgConfigHeadId, receive.getElsAccount(), businessType, operateType)))) {
                    currentConfigItemList.addAll((Collection<ElsMsgConfigItem>)receiveAccountItemList);
                }
                receiveAccountItemList = currentConfigItemList.iterator();
                while (receiveAccountItemList.hasNext()) {
                    ElsMsgConfigItem item = (ElsMsgConfigItem)receiveAccountItemList.next();
                    if (!StrUtil.isNotBlank((CharSequence)item.getLinkUrl()) || !item.getLinkUrl().contains(",")) continue;
                    if (busAccount.equals(toElsAccount)) {
                        item.setLinkUrl(item.getLinkUrl().split(",")[0]);
                        continue;
                    }
                    item.setLinkUrl(item.getLinkUrl().split(",")[1]);
                }
                List<PersonalSetting> personalSettings = this.accountRpcService.getPersonalSetting(toElsAccount, receive.getSubAccount());
                List<String> list = this.processData(personalSettings);
                Map itemTypeMap = currentConfigItemList.stream().collect(Collectors.groupingBy(ElsMsgConfigItem::getMsgType, Collectors.groupingBy(BaseEntity::getElsAccount, Collectors.toList())));
                if (itemTypeMap.containsKey(SendMsgTypeEnum.WX_EP.getType())) {
                    itemTypeMap.put(SendMsgTypeEnum.WX_EP_DEVELOP.getType(), itemTypeMap.get(SendMsgTypeEnum.WX_EP.getType()));
                }
                Map<String, List<ElsMsgConfigItem>> msgItemAccountMap = currentConfigItemList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
                for (String type : itemTypeMap.keySet()) {
                    if (!list.contains(type)) continue;
                    try {
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(type);
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(itemTypeMap.get(type));
                        msgVO.setMsgItemAccountMap(msgItemAccountMap);
                        msgVO.setReceiveAccount(receive);
                        msgVO.setSendAccount(sendAccount);
                        msgVO.setParams(businessObj);
                        msgVO.setUrlParam(urlParam);
                        msgVO.setBusinessType(businessType);
                        msgVO.setOperateType(operateType);
                        msgVO.setBusAccount(busAccount);
                        msgVO.setToElsAccount(toElsAccount);
                        msgVO.setMsgType(type);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                    catch (Exception e) {
                        log.error("MsgServiceImpl-sendMsg,type:{},data:{},error:{}", new Object[]{type, msg.toJSONString(), e.getMessage()});
                    }
                }
            }
        }
    }

    private List<ElsMsgConfigItem> getMsgConfigItemListByBusAccount(String headId, String busAccount, String businessType, String operateType) {
        List<Object> resultList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)busAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)configHeadList)) {
            return Lists.newArrayList();
        }
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add(item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }

    private List<ElsMsgConfigItem> getMsgConfigItemList(String headId, List<String> busAccountList, String businessType, String operateType) {
        List resultList;
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).in(BaseEntity::getElsAccount, busAccountList);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            return new ArrayList<ElsMsgConfigItem>();
        }
        List headIdList = configHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ElsMsgConfigItem::getHeadId, headIdList);
        resultList = this.elsMsgConfigItemService.list((Wrapper)wrapper);
        return resultList;
    }
}

