/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u79df\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system/elsTenant"})
public class ElsTenantController
extends BaseController<ElsTenant, ElsTenantService> {
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private PermissionService permissionService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsTenant elsTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ElsTenant> queryWrapper = QueryGenerator.initQueryWrapper(elsTenant, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTenantService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsTenant elsTenant) {
        elsTenant.setAccountStatus(AccountStatusEnum.NORMAL.getCode());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)"100000");
        ElsTenant tenant = (ElsTenant)this.elsTenantService.getOne((Wrapper)wrapper);
        elsTenant.setThemeEnable(tenant.getThemeEnable());
        elsTenant.setButtonEnable(tenant.getButtonEnable());
        this.elsTenantService.saveElsTenant(elsTenant);
        return Result.ok(elsTenant);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsTenant elsTenant) {
        this.elsTenantService.updateElsTenant(elsTenant);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsTenantService.delElsTenant(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsTenantService.delBatchElsTenant(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u521d\u59cb\u5316\u6743\u9650")
    @ApiOperation(value="\u521d\u59cb\u5316\u6743\u9650", notes="\u521d\u59cb\u5316\u6743\u9650")
    @PostMapping(value={"/initPermission"})
    public Result<?> initPermission(@RequestBody String param) {
        JSONObject jsonObject = JSONObject.parseObject((String)param);
        String role = jsonObject.getString("role");
        JSONArray jsonArray = jsonObject.getJSONArray("elsAccountList");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            arrayList.add(jsonArray.getString(i));
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            this.permissionService.initAccountPermissionList(arrayList, role);
        }
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsTenant elsTenant = (ElsTenant)this.elsTenantService.getById((Serializable)((Object)id));
        return Result.ok(elsTenant);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u51bb\u7ed3/\u89e3\u51bb", logType=2, operateType=3)
    @ApiOperation(value="\u51bb\u7ed3/\u89e3\u51bb", notes="\u51bb\u7ed3/\u89e3\u51bb")
    @GetMapping(value={"/frozenOpt"})
    public Result<?> frozenOpt(@RequestParam(name="id", required=true) String id) {
        ElsTenant elsTenant = (ElsTenant)this.elsTenantService.getById((Serializable)((Object)id));
        String accountStatus = AccountStatusEnum.NORMAL.getCode();
        if (accountStatus.equals(elsTenant.getAccountStatus())) {
            accountStatus = AccountStatusEnum.FROZEN.getCode();
        }
        this.elsTenantService.update(new ElsTenant().setAccountStatus(accountStatus), (Wrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)id));
        return Result.ok(elsTenant);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u5bfc\u51faExcel", logType=2, operateType=6)
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsTenant elsTenant, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<ElsTenant> queryWrapper = QueryGenerator.initQueryWrapper(elsTenant, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, elsTenant);
            queryWrapper.in((Object)"id", selectionList);
        }
        List elsTenantList = this.elsTenantService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u79df\u6237\u7ba1\u7406");
        mv.addObject("entity", ElsTenant.class);
        mv.addObject("params", (Object)new ExportParams("\u79df\u6237\u7ba1\u7406", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u79df\u6237\u7ba1\u7406", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)elsTenantList);
        return mv;
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ElsTenant.class);
    }

    @GetMapping(value={"/noToken/queryByParam"})
    public Result<?> queryByParam(String elsAccount) {
        ElsTenant tenant = this.elsTenantService.findByElsAccount(elsAccount);
        return Result.ok(tenant);
    }

    @AutoLog(value="\u79df\u6237\u7ba1\u7406-\u6574\u7406\u4f9b\u5e94\u5546\u6743\u9650")
    @ApiOperation(value="\u6574\u7406\u4f9b\u5e94\u5546\u6743\u9650", notes="\u6574\u7406\u4f9b\u5e94\u5546\u6743\u9650")
    @PostMapping(value={"/checkSalePermissionByPurchase"})
    public Result<?> checkSalePermissionByPurchase(@RequestBody String param) {
        JSONObject jsonObject = JSONObject.parseObject((String)param);
        String elsAccount = jsonObject.getString("elsAccount");
        this.permissionService.checkSalePermissionByPurchase(elsAccount);
        return this.commonSuccessResult(4);
    }
}

