/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.RolePermissionMapper;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.UserRoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolePermissionServiceImpl
extends ServiceImpl<RolePermissionMapper, RolePermission>
implements RolePermissionService {
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void saveRolePermission(String roleId, String permissionIds) {
        String[] arr;
        String elsAccount = TenantContext.getTenant();
        LambdaQueryWrapper query = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)roleId);
        this.remove((Wrapper)query);
        ArrayList<RolePermission> list = new ArrayList<RolePermission>();
        for (String p : arr = permissionIds.split(",")) {
            if (!ConvertUtils.isNotEmpty(p)) continue;
            RolePermission rolepms = new RolePermission(elsAccount, roleId, p);
            list.add(rolepms);
        }
        this.saveBatch(list);
    }

    @Override
    public void saveRolePermission(String roleId, String permissionIds, String lastPermissionIds) {
        List<String> delete;
        String elsAccount = TenantContext.getTenant();
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            ArrayList<RolePermission> list = new ArrayList<RolePermission>();
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty(p)) continue;
                RolePermission rolepms = new RolePermission(elsAccount, roleId, p);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(permissionIds, lastPermissionIds)) != null && delete.size() > 0) {
            for (String permissionId : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)roleId)).eq(RolePermission::getPermissionId, (Object)permissionId));
            }
        }
        List userRoleList = this.userRoleService.list((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)roleId));
        for (UserRole role : userRoleList) {
            this.redisUtil.del("shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + role.getUserId());
        }
    }

    @Override
    public void batchRemoveRolePermission(List<Map<String, Object>> deleteMap) {
        ((RolePermissionMapper)this.baseMapper).batchRemoveRolePermission(deleteMap);
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty(diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty(main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!ConvertUtils.isNotEmpty(key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }

    @Override
    public List<RolePermission> selectWithoutElsAccountOfRolePermission(List<String> permissionIds, String elsAccount) {
        return ((RolePermissionMapper)this.baseMapper).selectWithoutElsAccountOfRolePermission(permissionIds, elsAccount);
    }
}

