/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.trace.filter;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.context.BusAccountHolder;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceIdContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TraceIdContextFilter.class);
    private static final String TRACE_ID_KEY = "X-Request-Id";
    private static final String INIT_PARAMETER_KEY = "exclude-uri";
    private static Set<String> EXCLUDE_URI_SET;

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludeUri = filterConfig.getServletContext().getInitParameter(INIT_PARAMETER_KEY);
        Object[] excludeUris = StrUtil.isNotEmpty((CharSequence)excludeUri) ? excludeUri.split(",") : new String[]{};
        EXCLUDE_URI_SET = Sets.newHashSet((Object[])excludeUris);
        log.debug("[traceIdContextFilter]\u521d\u59cb\u5316");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String busAccount = ((HttpServletRequest)request).getHeader("bus-account");
        if (CharSequenceUtil.isNotBlank((CharSequence)busAccount)) {
            BusAccountHolder.set(busAccount);
        }
        if (EXCLUDE_URI_SET.contains(((HttpServletRequest)request).getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            String traceId = ((HttpServletRequest)request).getHeader(TRACE_ID_KEY);
            boolean need2GenerateTraceId = CharSequenceUtil.isEmpty((CharSequence)traceId);
            String source = request.getRemoteAddr();
            String target = ((HttpServletRequest)request).getRequestURI();
            if (need2GenerateTraceId) {
                traceId = target.contains("openApi/") ? TraceIdUtil.generateOutTraceId() : TraceIdUtil.generate(null);
                TraceIdHolder.set(traceId);
                log.info(":::\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb::: \u6765\u6e90\u5730\u5740: {}, \u76ee\u6807\u5730\u5740: {}, \u751f\u6210traceId: {}", new Object[]{source, target, traceId});
            } else {
                TraceIdHolder.set(traceId);
                log.info(":::\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb::: \u6765\u6e90\u5730\u5740: {}, \u76ee\u6807\u5730\u5740: {}", (Object)source, (Object)target);
            }
            HttpServletResponse res = (HttpServletResponse)response;
            res.setHeader(TRACE_ID_KEY, traceId);
            chain.doFilter(request, (ServletResponse)res);
            log.info(":::\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f::: \u76ee\u6807\u5730\u5740: {}, \u8017\u65f6: {} \u6beb\u79d2", (Object)target, (Object)(System.currentTimeMillis() - startTime));
        }
        finally {
            TraceIdHolder.remove();
            BusAccountHolder.remove();
        }
    }

    public void destroy() {
        log.debug("[traceIdContextFilter]\u9500\u6bc1");
    }
}

