/*
 * Decompiled with CFR 0.152.
 */
package com.els.config;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.RedisSessionDao;
import com.els.modules.shiro.authc.ShiroRealm;
import com.els.modules.shiro.authc.aop.JwtFilter;
import com.els.modules.shiro.authc.aop.OpenApiFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisClusterManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSentinelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@Configuration
public class ShiroConfig {
    private static final Logger log = LoggerFactory.getLogger(ShiroConfig.class);
    @Resource
    private LettuceConnectionFactory lettuceConnectionFactory;
    @Value(value="${els.shiro.excludeUrls}")
    private String excludeUrls;
    @Value(value="${els.shiro.jessionid}")
    private String jessionId;

    @Bean(value={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        if (ConvertUtils.isNotEmpty(this.excludeUrls)) {
            String[] permissionUrl;
            for (String url : permissionUrl = this.excludeUrls.split(",")) {
                filterChainDefinitionMap.put(url, "anon");
            }
        }
        filterChainDefinitionMap.put("/cas/client/validateLogin", "anon");
        filterChainDefinitionMap.put("/sys/getCheckCode", "anon");
        filterChainDefinitionMap.put("/account/thirdLogin/**", "anon");
        filterChainDefinitionMap.put("/i18n/getSysList/*", "anon");
        filterChainDefinitionMap.put("/sys/login", "anon");
        filterChainDefinitionMap.put("/sys/loginForMobile", "anon");
        filterChainDefinitionMap.put("/sys/mLogin", "anon");
        filterChainDefinitionMap.put("/logout", "anon");
        filterChainDefinitionMap.put("/sys/getEncryptedString", "anon");
        filterChainDefinitionMap.put("/sms/**", "anon");
        filterChainDefinitionMap.put("/esign/elsEnterpriseCertificationInfo/callback/*", "anon");
        filterChainDefinitionMap.put("/esign/elsSubaccountCertificationInfo/callback/person", "anon");
        filterChainDefinitionMap.put("/esign/esignOperation/callback/esign", "anon");
        filterChainDefinitionMap.put("/sys/phoneLogin", "anon");
        filterChainDefinitionMap.put("/system/thirdLogin/**", "anon");
        filterChainDefinitionMap.put("/oauth2/**", "anon");
        filterChainDefinitionMap.put("/supplier/supplierMaster/register", "anon");
        filterChainDefinitionMap.put("/supplier/supplierInvitationCode/getByCode", "anon");
        filterChainDefinitionMap.put("/supplier/supplierMaster/templateList", "anon");
        filterChainDefinitionMap.put("/sys/user/checkOnlyUser", "anon");
        filterChainDefinitionMap.put("/sys/user/register", "anon");
        filterChainDefinitionMap.put("/sys/user/querySysUser", "anon");
        filterChainDefinitionMap.put("/sys/user/phoneVerification", "anon");
        filterChainDefinitionMap.put("/sys/user/passwordChange", "anon");
        filterChainDefinitionMap.put("/auth/2step-code", "anon");
        filterChainDefinitionMap.put("/sys/common/view/**", "anon");
        filterChainDefinitionMap.put("/sys/common/download/**", "anon");
        filterChainDefinitionMap.put("/sys/common/pdf/**", "anon");
        filterChainDefinitionMap.put("/generic/**", "anon");
        filterChainDefinitionMap.put("/", "anon");
        filterChainDefinitionMap.put("/doc.html", "anon");
        filterChainDefinitionMap.put("/**/*.js", "anon");
        filterChainDefinitionMap.put("/**/*.css", "anon");
        filterChainDefinitionMap.put("/**/*.html", "anon");
        filterChainDefinitionMap.put("/**/*.svg", "anon");
        filterChainDefinitionMap.put("/**/*.pdf", "anon");
        filterChainDefinitionMap.put("/**/*.jpg", "anon");
        filterChainDefinitionMap.put("/**/*.png", "anon");
        filterChainDefinitionMap.put("/**/*.ico", "anon");
        filterChainDefinitionMap.put("/**/*.json", "anon");
        filterChainDefinitionMap.put("/login/**", "anon");
        filterChainDefinitionMap.put("/loginByToken", "anon");
        filterChainDefinitionMap.put("/app/**", "anon");
        filterChainDefinitionMap.put("/modeler/**", "anon");
        filterChainDefinitionMap.put("/**/*.ttf", "anon");
        filterChainDefinitionMap.put("/**/*.woff", "anon");
        filterChainDefinitionMap.put("/druid/**", "anon");
        filterChainDefinitionMap.put("/swagger-ui.html", "anon");
        filterChainDefinitionMap.put("/swagger**/**", "anon");
        filterChainDefinitionMap.put("/webjars/**", "anon");
        filterChainDefinitionMap.put("/v2/**", "anon");
        filterChainDefinitionMap.put("/jmreport/upload", "anon");
        filterChainDefinitionMap.put("/**/jmreport/**", "anon");
        filterChainDefinitionMap.put("/**/*.js.map", "anon");
        filterChainDefinitionMap.put("/**/*.css.map", "anon");
        filterChainDefinitionMap.put("/actuator/metrics/**", "anon");
        filterChainDefinitionMap.put("/actuator/httptrace/**", "anon");
        filterChainDefinitionMap.put("/actuator/redis/**", "anon");
        filterChainDefinitionMap.put("/test/elsDemo/html", "anon");
        filterChainDefinitionMap.put("/test/elsDemo/redis/**", "anon");
        filterChainDefinitionMap.put("/auto/cgform/**", "anon");
        filterChainDefinitionMap.put("/websocket/**", "anon");
        filterChainDefinitionMap.put("/uflo/**", "authc");
        filterChainDefinitionMap.put("/ureport/**", "authc");
        HashMap<String, BasicHttpAuthenticationFilter> filterMap = new HashMap<String, BasicHttpAuthenticationFilter>(1);
        filterMap.put("jwt", new JwtFilter());
        filterMap.put("openApi", new OpenApiFilter());
        shiroFilterFactoryBean.setFilters(filterMap);
        filterChainDefinitionMap.put("/**/openApi/**", "openApi");
        filterChainDefinitionMap.put("/**", "jwt");
        shiroFilterFactoryBean.setUnauthorizedUrl("/sys/common/403");
        shiroFilterFactoryBean.setLoginUrl("/user/login");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @DependsOn(value={"springContextUtils"})
    @Bean(value={"securityManager"})
    public DefaultWebSecurityManager securityManager(ShiroRealm myRealm) {
        String[] beans;
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)myRealm);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        securityManager.setCacheManager((CacheManager)this.redisCacheManager());
        securityManager.setSessionManager((SessionManager)this.defaultWebSessionManager());
        ModularRealmAuthenticator modularRealmAuthenticator = (ModularRealmAuthenticator)securityManager.getAuthenticator();
        for (String listener : beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AuthenticationListener.class)) {
            modularRealmAuthenticator.getAuthenticationListeners().add(SpringContextUtils.getBean(listener, AuthenticationListener.class));
        }
        return securityManager;
    }

    @Primary
    @Bean
    public ExecutorServiceSessionValidationScheduler sessionValidationScheduler() {
        return new ExecutorServiceSessionValidationScheduler();
    }

    @Primary
    @Bean(name={"sessionManager"})
    public DefaultWebSessionManager defaultWebSessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setGlobalSessionTimeout(43200000L);
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setSessionDAO((SessionDAO)this.getRedisSessionDao());
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setSessionIdCookie((Cookie)this.getSessionIdCookie());
        return sessionManager;
    }

    @Bean
    public RedisSessionDao getRedisSessionDao() {
        return new RedisSessionDao();
    }

    @Bean(name={"sessionIdCookie"})
    public SimpleCookie getSessionIdCookie() {
        if (StringUtils.isBlank((String)this.jessionId)) {
            this.jessionId = "jessionId";
        }
        SimpleCookie simpleCookie = new SimpleCookie(this.jessionId);
        return simpleCookie;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
        return defaultAdvisorAutoProxyCreator;
    }

    @Bean
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager((SecurityManager)securityManager);
        return advisor;
    }

    public RedisCacheManager redisCacheManager() {
        log.info("===============(1)\u521b\u5efa\u7f13\u5b58\u7ba1\u7406\u5668RedisCacheManager");
        RedisCacheManager redisCacheManager = new RedisCacheManager();
        redisCacheManager.setRedisManager(this.redisManager());
        redisCacheManager.setPrincipalIdFieldName("id");
        redisCacheManager.setExpire(14400);
        return redisCacheManager;
    }

    @Bean
    public IRedisManager redisManager() {
        RedisManager manager;
        if (this.lettuceConnectionFactory.getClusterConfiguration() != null && this.lettuceConnectionFactory.getClusterConfiguration().getClusterNodes().size() > 0) {
            RedisClusterManager redisManager = new RedisClusterManager();
            HashSet portSet = new HashSet();
            this.lettuceConnectionFactory.getClusterConfiguration().getClusterNodes().forEach(node -> portSet.add(new HostAndPort(node.getHost(), node.getPort().intValue())));
            if (StrUtil.isNotBlank((CharSequence)this.lettuceConnectionFactory.getPassword())) {
                JedisCluster jedisCluster = new JedisCluster(portSet, 2000, 2000, 5, this.lettuceConnectionFactory.getPassword(), new GenericObjectPoolConfig());
                redisManager.setPassword(this.lettuceConnectionFactory.getPassword());
                redisManager.setJedisCluster(jedisCluster);
            } else {
                JedisCluster jedisCluster = new JedisCluster(portSet);
                redisManager.setJedisCluster(jedisCluster);
            }
            manager = redisManager;
        } else if (this.lettuceConnectionFactory.getSentinelConfiguration() != null && this.lettuceConnectionFactory.getSentinelConfiguration().getSentinels().size() > 0) {
            RedisSentinelManager redisManager = new RedisSentinelManager();
            redisManager.setMasterName(this.lettuceConnectionFactory.getSentinelConfiguration().getMaster().getName());
            Set nodes = this.lettuceConnectionFactory.getSentinelConfiguration().getSentinels();
            StringBuilder host = new StringBuilder();
            for (RedisNode node2 : nodes) {
                if (host.length() == 0) {
                    host.append(node2.getHost()).append(":").append(node2.getPort());
                    continue;
                }
                host.append(",").append(node2.getHost()).append(":").append(node2.getPort());
            }
            redisManager.setHost(host.toString());
            redisManager.setPassword(this.lettuceConnectionFactory.getPassword());
            manager = redisManager;
        } else {
            RedisManager redisManager = new RedisManager();
            redisManager.setHost(this.lettuceConnectionFactory.getHostName());
            redisManager.setPort(this.lettuceConnectionFactory.getPort());
            redisManager.setDatabase(this.lettuceConnectionFactory.getDatabase());
            if (StrUtil.isNotBlank((CharSequence)this.lettuceConnectionFactory.getPassword())) {
                redisManager.setPassword(this.lettuceConnectionFactory.getPassword());
            }
            manager = redisManager;
        }
        return manager;
    }
}

