/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.dashboard.entity.ChartData;
import com.els.modules.dashboard.enums.ChartDataTypeEnum;
import com.els.modules.dashboard.mapper.ChartDataMapper;
import com.els.modules.dashboard.service.ChartDataService;
import com.els.modules.dashboard.vo.ChartDataVO;
import com.els.modules.system.util.I18nUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartDataServiceImpl
extends ServiceImpl<ChartDataMapper, ChartData>
implements ChartDataService {
    private static final Logger logger = LoggerFactory.getLogger(ChartDataServiceImpl.class);
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";
    private static final String DICT_CODE = ":els_chart_datadata_descidis_deleted=0";
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void saveChartData(ChartData chartData) {
        ((ChartDataMapper)this.baseMapper).insert(chartData);
        this.deleteRedis("els_chart_data");
    }

    @Override
    public void updateChartData(ChartData chartData) {
        ((ChartDataMapper)this.baseMapper).updateById(chartData);
        this.deleteRedis("els_chart_data");
    }

    @Override
    public void delChartData(String id) {
        ((ChartDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.deleteRedis("els_chart_data");
    }

    @Override
    public void delBatchChartData(List<String> idList) {
        ((ChartDataMapper)this.baseMapper).deleteBatchIds(idList);
        this.deleteRedis("els_chart_data");
    }

    private void deleteRedis(String table) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public ChartDataVO getDataById(String dataId, Map<String, Object> dataMap) {
        ChartData data = (ChartData)((ChartDataMapper)this.baseMapper).selectById((Serializable)((Object)dataId));
        if (data == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_PBWFxMK_5cb669f5", "\u56fe\u8868\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ChartDataVO dataVO = new ChartDataVO();
        BeanUtils.copyProperties((Object)data, (Object)dataVO);
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_27);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        configuration.setDefaultEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        boolean filterFlag = true;
        if (data.getDataSql().contains("${elsAccount}")) {
            filterFlag = false;
        }
        this.setSqlParam(data, dataMap);
        try {
            Template template = new Template(data.getDataCode(), data.getDataSql(), configuration);
            template.process(dataMap, (Writer)stringWriter);
        }
        catch (Exception e) {
            throw new ELSBootException("sql\u6a21\u677f\u6e32\u67d3\u5931\u8d25", e.getMessage());
        }
        if (ChartDataTypeEnum.NUMBER.getCode().equals(data.getDataType())) {
            if (filterFlag) {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectCountForXml(stringWriter.toString()));
            } else {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectWithoutElsAccountselectCountForXml(stringWriter.toString()));
            }
        } else if (ChartDataTypeEnum.LIST.getCode().equals(data.getDataType())) {
            if (filterFlag) {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectListForXml(stringWriter.toString()));
            } else {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectWithoutElsAccountselectListForXml(stringWriter.toString()));
            }
        } else if (ChartDataTypeEnum.SINGLE_RECORD.getCode().equals(data.getDataType())) {
            if (filterFlag) {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectOneForXml(stringWriter.toString()));
            } else {
                dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectWithoutElsAccountselectOneForXml(stringWriter.toString()));
            }
        }
        return dataVO;
    }

    private void setSqlParam(ChartData chartData, Map<String, Object> paramMap) {
        StringBuffer sqlBuf = new StringBuffer(chartData.getDataSql());
        Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
        Matcher matcher = pattern.matcher(chartData.getDataSql());
        while (matcher.find()) {
            int groupIndex = 0;
            String paramKey = matcher.group(groupIndex);
            Object param = paramMap.get(paramKey = paramKey.substring(2, paramKey.length() - 1));
            String strParam = param instanceof Integer ? Integer.toString((Integer)param) : "\"" + param.toString() + "\"";
            sqlBuf.replace(matcher.start(groupIndex), matcher.end(groupIndex), strParam);
            matcher = pattern.matcher(sqlBuf);
            logger.info(sqlBuf.toString());
            logger.info("\u53c2\u6570\u540d\uff1a" + paramKey + "\uff0c\u53c2\u6570\u503c\uff1a" + strParam);
        }
        chartData.setDataSql(sqlBuf.toString());
    }
}

