/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.vo.MsgParamsVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);

    private static MsgService getMsgService() {
        return SpringContextUtils.getBean(MsgService.class);
    }

    public static void sendLogMsg(JSONObject object) {
    }

    public static void sendLogMsg(String elsAccount, String logContent, Integer logType, Integer operateType) {
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)elsAccount);
        object.put("logContent", (Object)logContent);
        object.put("logType", (Object)logType);
        object.put("operateType", (Object)operateType);
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            object.put("ip", (Object)IPUtils.getIpAddr(request));
            LoginUser sysUser = SysUtil.getLoginUser();
            if (sysUser != null) {
                object.put("userid", (Object)sysUser.getSubAccount());
                object.put("username", (Object)sysUser.getRealname());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MessageUtil.sendLogMsg(object);
    }

    public static void sendBusMsg(JSONObject object) {
        MessageUtil.getMsgService().sendMsg(object);
    }

    public static void sendBusMsg(String purchaseAccount, String businessType, String optType, MsgParamsVO msgParamsVO) {
        MessageUtil.sendBusMsg(purchaseAccount, businessType, optType, msgParamsVO, SysUtil.getLoginUser());
    }

    public static void sendBusMsg(String purchaseAccount, String businessType, String optType, MsgParamsVO msgParamsVO, LoginUser loginUser) {
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)purchaseAccount);
        msgObj.put("businessType", (Object)businessType);
        msgObj.put("operateType", (Object)optType);
        msgObj.put("businessObj", (Object)SysUtil.objectToJSON(msgParamsVO.getParams()));
        msgObj.put("sendObj", (Object)loginUser);
        Map<String, List<ElsSubAccount>> accountMap = msgParamsVO.getReceiverMap();
        JSONArray array = new JSONArray();
        if (accountMap != null) {
            for (String elsAccount : accountMap.keySet()) {
                List<ElsSubAccount> list = accountMap.get(elsAccount);
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)elsAccount);
                JSONObject object = msgParamsVO.getReceiveParamMap() != null ? msgParamsVO.getReceiveParamMap().get(elsAccount) : null;
                String urlParam = object == null ? "" : SysUtil.getUrlParamByJson(object);
                receiveObj.put("urlParam", (Object)urlParam);
                receiveObj.put("toSubAccountList", list);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            MessageUtil.sendBusMsg(msgObj);
        }
    }

    public static Set<String> getFieldSet(Object ... obj) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (Object o : obj) {
            Field[] declaredFieldItems;
            for (Field field : declaredFieldItems = o.getClass().getDeclaredFields()) {
                String typeName = field.getType().getTypeName();
                if (!BigDecimal.class.getTypeName().equals(typeName)) continue;
                fieldSet.add(field.getName());
            }
        }
        return fieldSet;
    }

    public static JSONObject handleBigDecimalData(JSONObject obj, Set<String> fieldSet) {
        for (String key : obj.keySet()) {
            if (obj.get((Object)key) != null && ArrayList.class.getTypeName().equals(obj.get((Object)key).getClass().getTypeName())) {
                JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)obj.get((Object)key)));
                for (Object object : array) {
                    JSONObject o = (JSONObject)object;
                    for (String okey : o.keySet()) {
                        MessageUtil.handleJSONBigDecimal(okey, o, fieldSet);
                    }
                }
                obj.put(key, (Object)array);
            }
            MessageUtil.handleJSONBigDecimal(key, obj, fieldSet);
        }
        return obj;
    }

    private static JSONObject handleJSONBigDecimal(String key, JSONObject obj, Set<String> fieldSet) {
        if (fieldSet.contains(key)) {
            BigDecimal number = obj.get((Object)key) == null ? BigDecimal.ZERO : new BigDecimal(obj.get((Object)key).toString());
            String numb = number.stripTrailingZeros().toPlainString();
            obj.put(key, (Object)numb);
        }
        return obj;
    }
}

