/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.BigDecimalFormat;
import com.els.common.aspect.annotation.Dict;
import com.els.common.aspect.annotation.ReadConfig;
import com.els.common.aspect.annotation.ReadConfigType;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SensitiveField;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.SensitiveFieldService;
import com.els.modules.system.util.AdminFlagUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private SensitiveFieldService sensitiveFieldService;
    private final String OBJECT_CLASS = "java.lang.Object";
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    private Map<String, String> localCacheMap;
    private List<SensitiveField> sensitiveFieldList;

    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..))")
    public void executeService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="executeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        try {
            long start = System.currentTimeMillis();
            if (this.sensitiveFieldList != null) {
                this.sensitiveFieldList.clear();
            }
            String sensitiveFieldGroups = null;
            if (SysUtil.getLoginUser() != null) {
                sensitiveFieldGroups = SysUtil.getLoginUser().getSensitiveFieldGroups();
            }
            this.sensitiveFieldList = this.sensitiveFieldService.findSensitiveFieldByGroup(TenantContext.getTenant(), sensitiveFieldGroups);
            this.parseDictText(result);
            long end = System.currentTimeMillis();
            log.debug("\u89e3\u6790\u6ce8\u5165JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.error("DictAspect_parseDictText_failed:", (Throwable)e);
            Object object = result;
            return object;
        }
        finally {
            I18nUtil.clear();
            TenantContext.clear();
        }
    }

    public void parseDictText(Object result) {
        if (result instanceof Result) {
            Map<Object, Object> map = this.localCacheMap = this.localCacheMap == null ? new HashMap() : this.localCacheMap;
            if (((Result)result).getResult() instanceof IPage) {
                long start = System.currentTimeMillis();
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                for (Object record : ((IPage)((Result)result).getResult()).getRecords()) {
                    if (record == null) continue;
                    JSONObject item = this.parseJson(record);
                    items.add(item);
                }
                ((IPage)((Result)result).getResult()).setRecords(items);
                long end = System.currentTimeMillis();
                log.info("result_cost:{}ms", (Object)(end - start));
            } else if (((Result)result).getResult() instanceof BaseEntity || ((Result)result).getResult() instanceof BaseDTO) {
                Object record = ((Result)result).getResult();
                ((Result)result).setResult(this.parseJson(record));
            } else if (((Result)result).getResult() instanceof List) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                boolean flag = false;
                for (Object record : (List)((Result)result).getResult()) {
                    if (!(record instanceof BaseEntity)) continue;
                    items.add(this.parseJson(record));
                    flag = true;
                }
                if (flag) {
                    ((List)((Result)result).getResult()).clear();
                    ((List)((Result)result).getResult()).addAll(items);
                }
            }
        } else if (result instanceof ModelAndView) {
            ArrayList dataSet = (ArrayList)((ModelAndView)result).getModel().get("data");
            Iterator its = dataSet.iterator();
            ArrayList<JSONObject> newData = new ArrayList<JSONObject>();
            while (its.hasNext()) {
                JSONObject t = (JSONObject)its.next();
                this.optSensitiveField(t);
                newData.add(t);
            }
            ((ModelAndView)result).addObject("data", newData);
        }
    }

    private JSONObject parseJson(Object record) {
        return this.parseJson(record, null, null, null, null);
    }

    private JSONObject parseJson(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion) {
        ReadConfig readConfig;
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(record);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        JSONObject item = JSONObject.parseObject((String)json);
        if (item == null) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)templateAccount)) {
            templateAccount = item.getString("templateAccount");
        }
        if (StrUtil.isBlank((CharSequence)busAccount) && StrUtil.isBlank((CharSequence)(busAccount = item.getString("busAccount")))) {
            busAccount = TenantContext.getTenant();
        }
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            templateNumber = item.getString("templateNumber");
            templateVersion = item.getString("templateVersion");
        }
        if ((readConfig = record.getClass().getAnnotation(ReadConfig.class)) != null && !StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            String queryAccount;
            ReadConfigType type = readConfig.value();
            String string = queryAccount = StrUtil.isBlank((CharSequence)templateAccount) ? busAccount : templateAccount;
            if (StrUtil.isBlank((CharSequence)queryAccount)) {
                queryAccount = TenantContext.getTenant();
            }
            TemplateHeadVO headVO = this.templateHeadService.getAllConfig(queryAccount, templateNumber, templateVersion);
            Map<String, String> dictMap = ReadConfigType.HEAD.equals((Object)type) ? headVO.getTemplateConfigHeadList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDictCode, (newVal, oldVal) -> oldVal)) : headVO.getTemplateConfigItemList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigItem::getFieldName, TemplateConfigItem::getDictCode, (newVal, oldVal) -> oldVal));
            if (!CollectionUtils.isEmpty(dictMap)) {
                Iterator<Map.Entry<String, String>> iterator = dictMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String value = iterator.next().getValue();
                    if (!value.startsWith("/")) continue;
                    iterator.remove();
                }
            }
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, dictMap, true);
        } else {
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, new HashMap<String, String>(), false);
        }
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            this.optSensitiveField(item);
        }
        return item;
    }

    private void translate(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion, JSONObject item, Map<String, String> dictMap, boolean isConfig) {
        for (Field field : ConvertUtils.getAllFields(record)) {
            BigDecimalFormat annotation;
            Date date;
            String textValue;
            String code;
            String key;
            String table;
            String text;
            String dictCode = dictMap.get(field.getName());
            if (isConfig && StrUtil.isNotBlank((CharSequence)dictCode)) {
                text = null;
                table = null;
                String valueText = null;
                key = String.valueOf(item.get((Object)field.getName()));
                if (dictCode.contains(",") || dictCode.contains("#")) {
                    String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                    table = dictCodeArray[0];
                    text = dictCodeArray[1];
                    valueText = dictCodeArray[2];
                    code = "";
                    if (dictCodeArray.length > 3) {
                        code = dictCodeArray[3];
                    }
                } else {
                    code = dictCode;
                }
                textValue = this.translateDictValue(item, code, text, table, key, false, busAccount, valueText);
                if (null == textValue || !textValue.equals(key) || !CharSequenceUtil.isNotEmpty((CharSequence)item.getString(field.getName() + "_dictText"))) {
                    item.put(field.getName() + "_dictText", (Object)textValue);
                }
            } else {
                Dict dict = field.getAnnotation(Dict.class);
                if (dict != null) {
                    code = dict.dicCode();
                    text = dict.dicText();
                    table = dict.dictTable();
                    boolean isFilterSql = false;
                    key = String.valueOf(item.get((Object)field.getName()));
                    textValue = this.translateDictValue(item, code, text, table, key, isFilterSql, busAccount, null);
                    if (null == textValue || !textValue.equals(key) || !CharSequenceUtil.isNotEmpty((CharSequence)item.getString(field.getName() + "_dictText"))) {
                        item.put(field.getName() + "_dictText", (Object)textValue);
                    }
                } else if (field.getType().isAssignableFrom(List.class) && !field.getType().getName().equals("java.lang.Object")) {
                    List list = null;
                    try {
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), record.getClass());
                        Method getMethod = pd.getReadMethod();
                        list = (List)getMethod.invoke(record, new Object[0]);
                    }
                    catch (Exception pd) {
                        // empty catch block
                    }
                    if (null != list && !list.isEmpty() && (list.get(0) instanceof BaseEntity || list.get(0) instanceof BaseDTO)) {
                        ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                        for (Object obj : list) {
                            JSONObject itemObj = this.parseJson(obj, templateAccount, busAccount, templateNumber, templateVersion);
                            items.add(itemObj);
                        }
                        item.put(field.getName(), items);
                    }
                } else {
                    Class<?> superclass;
                    Class<?> type = field.getType();
                    for (superclass = type.getSuperclass(); superclass != null && !superclass.equals(BaseEntity.class) && !superclass.equals(BaseDTO.class); superclass = superclass.getSuperclass()) {
                    }
                    if (superclass != null) {
                        try {
                            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), record.getClass());
                            Method getMethod = pd.getReadMethod();
                            Object obj = getMethod.invoke(record, new Object[0]);
                            JSONObject itemObj = this.parseJson(obj, templateAccount, busAccount, templateNumber, templateVersion);
                            item.put(field.getName(), (Object)itemObj);
                        }
                        catch (Exception e) {
                            log.error(field.getName() + "\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25" + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (Date.class.equals(field.getType()) && field.getAnnotation(JsonFormat.class) == null && item.get((Object)field.getName()) != null) {
                SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                item.put(field.getName(), (Object)aDate.format(DateUtils.parseDate(item.get((Object)field.getName()))));
            }
            if (Date.class.equals(field.getType()) && item.get((Object)field.getName()) != null && null != (date = DateUtils.parseDate(item.get((Object)field.getName())))) {
                item.put(field.getName() + "_DateMaps", (Object)DateUtils.getMillis(date));
                item.put(field.getName() + "_timestamp", (Object)DateUtils.getMillis(date));
            }
            if (!field.getType().isAssignableFrom(BigDecimal.class) || null == (annotation = field.getAnnotation(BigDecimalFormat.class))) continue;
            try {
                BigDecimal v;
                int scale = annotation.scale();
                field.setAccessible(true);
                Object o = field.get(record);
                if (null == o && annotation.nullToZero()) {
                    o = BigDecimal.ZERO;
                }
                if ((v = (BigDecimal)o) == null) {
                    v = BigDecimal.ZERO;
                }
                String formatVal = String.format("%." + scale + "f", v.doubleValue());
                item.put(field.getName(), (Object)formatVal);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private String translateDictValue(JSONObject item, String code, String text, String table, String key, boolean isFilterSql, String busAccount, String valueText) {
        try {
            if (ConvertUtils.isEmpty(key)) {
                return null;
            }
            String language = I18nUtil.getCurrentLanguage();
            if (StrUtil.isBlank((CharSequence)language)) {
                language = "zh";
            }
            StringBuilder textValue = new StringBuilder();
            String[] keys = key.split(",");
            for (int i = 0; i < keys.length; ++i) {
                String tmpValue;
                String k = keys[i];
                if (k.trim().length() == 0) continue;
                String temCode = code;
                if (temCode.contains("${")) {
                    isFilterSql = true;
                    StringBuffer filterSql = new StringBuffer();
                    Matcher matcher = this.pattern.matcher(temCode);
                    while (matcher.find()) {
                        Object o = item.get((Object)matcher.group(1));
                        if (null == o) {
                            o = "";
                        }
                        matcher.appendReplacement(filterSql, o.toString().split(",")[i] + "");
                    }
                    matcher.appendTail(filterSql);
                    temCode = filterSql.toString();
                }
                if (StrUtil.isBlank((CharSequence)busAccount)) {
                    busAccount = "100000";
                }
                StringBuilder mapKey = new StringBuilder(busAccount);
                if (isFilterSql) {
                    mapKey.append("_").append(k.trim()).append("_").append(table).append("_").append(text).append("_").append(text).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictService.queryTableDictTextByFilterSql(busAccount, k.trim(), table, text, text, temCode);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                } else if (StrUtil.isNotBlank((CharSequence)valueText)) {
                    mapKey.append("_").append(k.trim()).append("_").append(table).append("_").append(text).append("_").append(valueText).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictService.queryTableDictTextByFilterSql(busAccount, k.trim(), table, text, valueText, temCode);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                } else {
                    mapKey.append("_").append(language).append("_").append(k.trim()).append("_").append(temCode);
                    if (this.localCacheMap.containsKey(mapKey.toString())) {
                        tmpValue = this.localCacheMap.get(mapKey.toString());
                    } else {
                        tmpValue = this.dictService.queryDictTextByKey(temCode, k.trim(), busAccount);
                        this.localCacheMap.put(mapKey.toString(), tmpValue);
                    }
                }
                if (tmpValue == null) continue;
                if (!"".equals(textValue.toString())) {
                    textValue.append(",");
                }
                textValue.append(tmpValue);
            }
            return textValue.length() == 0 ? key : textValue.toString();
        }
        catch (Exception e) {
            log.error("translateDictValue_failed:", (Throwable)e);
            throw e;
        }
    }

    private String translateSelect(String table, String descText, String valueText, String where, String elsAccount, String value) {
        String tmpValue = "";
        List<DictModel> list = this.dictService.queryTableDictItemsByCodeAndFilter(table, descText, valueText, where, elsAccount);
        for (DictModel model : list) {
            if (!model.getValue().equals(value)) continue;
            tmpValue = model.getText();
            break;
        }
        if (StrUtil.isBlank((CharSequence)tmpValue)) {
            return value;
        }
        return value + "_" + tmpValue;
    }

    private void optSensitiveField(JSONObject obj) {
        if (this.sensitiveFieldList != null) {
            try {
                for (SensitiveField field : this.sensitiveFieldList) {
                    String fieldCode = field.getFieldCode();
                    if ("id".equals(fieldCode)) continue;
                    String repalceType = field.getReplaceType();
                    String fieldValue = obj.getString(fieldCode);
                    if ("2".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt2(fieldValue));
                        continue;
                    }
                    if ("3".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt(fieldValue));
                        continue;
                    }
                    obj.put(fieldCode, (Object)"*");
                }
            }
            catch (Exception e) {
                log.error("optSensitiveField_failed:", (Throwable)e);
            }
        }
    }

    private String encrypt(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S(?=\\S{4})", "*");
    }

    private String encrypt2(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S", "*");
    }
}

