/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ElsSetVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e"})
@RestController
@RequestMapping(value={"/system/elsCompanySet"})
public class ElsCompanySetController
extends BaseController<ElsCompanySet, ElsCompanySetService> {
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired
    private DictService dictService;

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @GetMapping(value={"/findList"})
    public Result<?> findList() {
        ElsSetVO setVO = new ElsSetVO();
        setVO.setCompanySetList(this.elsCompanySetService.findList(this.getTenantId()));
        return Result.ok(setVO);
    }

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u4fdd\u5b58", operateType=3)
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @RequiresPermissions(value={"system#companySet:add"})
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody ElsSetVO setVO) {
        String message = this.elsCompanySetService.save(setVO.getCompanySetList());
        return Result.ok(message == null ? I18nUtil.translate("i18n_alert_tkLR_2f0866fe", "\u64cd\u4f5c\u6210\u529f") : message);
    }

    @ApiOperation(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u83b7\u53d6\u4f01\u4e1a\u5f00\u542f\u6743\u9650\u7684\u6a21\u5757\u5217\u8868")
    @RequiresPermissions(value={"system#companySet:queryById"})
    @GetMapping(value={"/findOpenbusinessType"})
    public Result<?> findOpenBusinessType() {
        List<DictItem> dictItems = this.dictService.findOpenbusinessType();
        return Result.ok(dictItems);
    }
}

