/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.PermissionVO;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/elsRole"})
public class ElsRoleController {
    private static final Logger log = LoggerFactory.getLogger(ElsRoleController.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<Role>> queryPageList(Role role, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<Role>> result = new Result<IPage<Role>>();
        QueryWrapper<Role> queryWrapper = QueryGenerator.initQueryWrapper(role, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.roleService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u6dfb\u52a0", logType=2, operateType=2)
    @RequiresPermissions(value={"els#role:add"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<Role> add(@RequestBody Role role) {
        Result<Role> result = new Result<Role>();
        try {
            if ("admin".equals(role.getRoleCode())) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_rAoxqjW_f0f8782b", "\u8be5\u7f16\u7801\u4e0d\u53ef\u7528\uff01"));
            }
            role.setCreateTime(new Date());
            this.roleService.save(role);
            result.success(I18nUtil.translate("i18n_alert_SuLRW_34dd402d", "\u6dfb\u52a0\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_tkKm_2f078e83", "\u64cd\u4f5c\u5931\u8d25"));
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u7f16\u8f91", logType=2, operateType=3)
    @RequiresPermissions(value={"els#role:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public Result<Role> edit(@RequestBody Role role) {
        Result<Role> result = new Result<Role>();
        Role sysrole = (Role)this.roleService.getById((Serializable)((Object)role.getId()));
        if (sysrole == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            role.setUpdateTime(new Date());
            boolean ok = this.roleService.updateById(role);
            if (ok) {
                result.success(I18nUtil.translate("i18n_alert_crLR_25ddaeda", "\u4fee\u6539\u6210\u529f!"));
            }
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @RequiresPermissions(value={"els#role:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public Result<Role> delete(@RequestParam(name="id", required=true) String id) {
        Result<Role> result = new Result<Role>();
        Role sysrole = (Role)this.roleService.getById((Serializable)((Object)id));
        if (sysrole == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            String roleId = sysrole.getId();
            LambdaQueryWrapper ur = Wrappers.lambdaQuery();
            ur.select(new SFunction[]{UserRole::getRoleId});
            ur.eq(UserRole::getRoleId, (Object)roleId);
            int count = this.userRoleMapper.selectCount((Wrapper)ur);
            if (count > 0) {
                result.error500(I18nUtil.translate("i18n_alert_rKyIlUjDKjWVSQG_34428933", "\u8be5\u89d2\u8272\u5df2\u6388\u4e88\u7528\u6237\u4f7f\u7528\uff0c\u8bf7\u52ff\u5220\u9664\uff01"));
                return result;
            }
            if ("companyAdmin".equals(sysrole.getRoleCode()) || "admin".equals(sysrole.getRoleCode())) {
                result.error500("admin/companyAdmin" + I18nUtil.translate("i18n_alert_KyxOQG_81e65bb4", "\u89d2\u8272\u4e0d\u80fd\u5220\u9664\uff01"));
            } else {
                boolean ok = this.roleService.removeById((Serializable)((Object)id));
                if (ok) {
                    result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
                }
            }
        }
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    public Result<Role> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<Role> result = new Result<Role>();
        if (ids == null || "".equals(ids.trim())) {
            result.error500(I18nUtil.translate("i18n_alert_sWxKqW_a84a623d", "\u53c2\u6570\u4e0d\u8bc6\u522b\uff01"));
        } else {
            this.roleService.removeByIds(Arrays.asList(ids.split(",")));
            result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<Role> queryById(@RequestParam(name="id", required=true) String id) {
        Result<Role> result = new Result<Role>();
        Role sysrole = (Role)this.roleService.getById((Serializable)((Object)id));
        if (sysrole == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            result.setResult(sysrole);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryall"}, method={RequestMethod.GET})
    public Result<List<Role>> queryall() {
        Result<List<Role>> result = new Result<List<Role>>();
        List list = this.roleService.list();
        if (list == null || list.size() <= 0) {
            result.error500(I18nUtil.translate("i18n_alert_LYuKyVH_28521daa", "\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f"));
        } else {
            result.setResult(list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryalls"}, method={RequestMethod.GET})
    public Result<List<Role>> queryalls() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Result<List<Role>> result = new Result<List<Role>>();
        List list = new ArrayList();
        if (!"1001".equals(sysUser.getSubAccount()) && !"admin".equals(sysUser.getSubAccount())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)sysUser.getElsAccount());
            queryWrapper.ne((Object)"role_code", (Object)"companyAdmin");
            list = this.roleService.list((Wrapper)queryWrapper);
        } else {
            list = this.roleService.list();
        }
        if (list == null || list.size() <= 0) {
            result.error500(I18nUtil.translate("i18n_alert_LYuKyVH_28521daa", "\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f"));
        } else {
            result.setResult(list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/checkRoleCode"}, method={RequestMethod.GET})
    public Result<Boolean> checkUsername(String id, String roleCode) {
        Result<Boolean> result = new Result<Boolean>();
        result.setResult(true);
        log.info("--\u9a8c\u8bc1\u89d2\u8272\u7f16\u7801\u662f\u5426\u552f\u4e00---id:" + id + "--roleCode:" + roleCode);
        try {
            Role newRole;
            Role role = null;
            if (ConvertUtils.isNotEmpty(id)) {
                role = (Role)this.roleService.getById((Serializable)((Object)id));
            }
            if ((newRole = (Role)this.roleService.getOne((Wrapper)new QueryWrapper().lambda().eq(Role::getRoleCode, (Object)roleCode))) != null) {
                if (role == null) {
                    result.setSuccess(false);
                    result.setMessage(I18nUtil.translate("i18n_alert_KyAoIMK_69f3a9d7", "\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728"));
                    return result;
                }
                if (!id.equals(newRole.getId())) {
                    result.setSuccess(false);
                    result.setMessage(I18nUtil.translate("i18n_alert_KyAoIMK_69f3a9d7", "\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728"));
                    return result;
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setResult(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u5bfc\u51faExcel", logType=2, operateType=6)
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(Role sysRole, HttpServletRequest request, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<Role> queryWrapper = QueryGenerator.initQueryWrapper(sysRole, request.getParameterMap());
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, sysRole);
            queryWrapper.in((Object)"id", selectionList);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        List pageList = this.roleService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u89d2\u8272\u5217\u8868");
        mv.addObject("entity", Role.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u89d2\u8272\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                Result result = this.roleService.importExcelCheckRoleCode(file, params);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u4fdd\u5b58\u6570\u636e\u89c4\u5219\u81f3\u89d2\u8272\u83dc\u5355\u5173\u8054", logType=2, operateType=2)
    @PostMapping(value={"/datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String roleId = jsonObject.getString("roleId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u89d2\u8272ID:" + roleId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RolePermission::getPermissionId, (Object)permissionId)).eq(RolePermission::getRoleId, (Object)roleId);
            RolePermission sysRolePermission = (RolePermission)this.rolePermissionService.getOne((Wrapper)query);
            if (sysRolePermission == null) {
                return Result.error(I18nUtil.translate("i18n_alert_VWsMKyntbWW_4190cc2f", "\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u83dc\u5355\u6743\u9650!"));
            }
            sysRolePermission.setDataRuleIds(dataRuleIds);
            this.rolePermissionService.updateById(sysRolePermission);
        }
        catch (Exception e) {
            log.error("SysRoleController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error(I18nUtil.translate("i18n_alert_sMKm_25b0066f", "\u4fdd\u5b58\u5931\u8d25"));
        }
        return Result.ok(I18nUtil.translate("i18n_alert_savaSuccess", "\u4fdd\u5b58\u6210\u529f!"));
    }

    @AutoLog(value="\u89d2\u8272\u7ba1\u7406-\u8be2\u83dc\u5355\u6743\u9650\u6811", logType=2, operateType=1)
    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList(HttpServletRequest request) {
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            ArrayList<Permission> list = null;
            String elsAccount = TenantContext.getTenant();
            if ("100000".equals(elsAccount)) {
                LambdaQueryWrapper query = new LambdaQueryWrapper();
                query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
                query.eq(Permission::getElsAccount, (Object)elsAccount);
                query.orderByAsc(Permission::getSortNo);
                list = this.permissionService.list((Wrapper)query);
            } else {
                List<PermissionVO> companyList = this.permissionService.getCompanyMenuList(elsAccount);
                list = new ArrayList<PermissionVO>();
                list.addAll(companyList);
            }
            for (Permission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            if (temp == null && ConvertUtils.isEmpty(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    @RequestMapping(value={"/getUserAdminRole"}, method={RequestMethod.GET})
    public Result<?> getUserAdminRole() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)sysUser.getElsAccount());
        queryWrapper.eq((Object)"role_code", (Object)"companyAdmin");
        queryWrapper.inSql((Object)"id", "select role_id from els_user_role where user_id='" + sysUser.getId() + "'");
        List list = this.roleService.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            return Result.ok(I18nUtil.translate("i18n_title_success", "\u6210\u529f"), "companyAdmin");
        }
        return Result.ok();
    }
}

