/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.enums.DictEnums;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.model.TreeSelectModel;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, Dict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private DictMapper dictMapper;
    @Resource
    private DictItemMapper dictItemMapper;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InterfaceUtil interfaceUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";
    private static final String TRANSLATE = "translate";

    @Override
    public List<DictModel> queryDictItemsByCode(String code, String elsAccount) {
        StringBuilder redisKey;
        List<DictModel> list;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if (CollectionUtil.isEmpty((Collection)(list = (List<DictModel>)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language)).toString())))) {
            log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryDictItemsByCode(code, elsAccount);
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, "100000");
            }
            this.redisUtil.set(redisKey.toString(), list, 7200L);
        }
        if ("zh".equals(language)) {
            return list;
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(item -> item.setText(I18nUtil.translateCache(item.getTextI18nKey(), item.getText())));
        }
        return list;
    }

    @Override
    public List<DictModel> queryDictItemsByCode(String code, String elsAccount, String status) {
        log.info("queryDictItemsByCode.dictCode : " + code);
        log.info("queryDictItemsByCode.busAccount : " + elsAccount);
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        log.info("queryDictItemsByCode.redisKey : " + redisKey);
        if (list == null || CollectionUtils.isEmpty((Collection)list)) {
            log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryDictItemsByCode(code, elsAccount);
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, SysUtil.getPurchaseAccount());
            }
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, "100000");
            }
            this.redisUtil.set(redisKey.toString(), list, 7200L);
        }
        log.info("queryDictItemsByCode.result : " + JSONObject.toJSONString(list));
        if (!CollectionUtils.isEmpty(list)) {
            if ("1".equals(status)) {
                list = list.parallelStream().filter(item -> "1".equals(item.getStatus())).collect(Collectors.toList());
            }
            list.forEach(item -> item.setText(I18nUtil.translate(item.getTextI18nKey(), item.getText())));
        }
        return list;
    }

    @Override
    public String queryDictTextByKey(String code, String value, String elsAccount) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language).append(COLON).append(TRANSLATE);
        Object o = this.redisUtil.get(redisKey.toString());
        List<DictModel> dictDTOList = null;
        if (o instanceof List) {
            dictDTOList = (List<DictModel>)o;
        }
        String desc = "";
        if (dictDTOList == null) {
            dictDTOList = this.queryDictItemsByCode(code, elsAccount);
            if (dictDTOList.isEmpty()) {
                return desc;
            }
            this.redisUtil.set(redisKey.toString(), dictDTOList, 1800L);
        }
        for (DictModel dictDTO : dictDTOList) {
            if (!dictDTO.getValue().equals(value)) continue;
            desc = I18nUtil.translate(dictDTO.getTextI18nKey(), dictDTO.getText());
            break;
        }
        return desc;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':text='+#text", sync=true)
    public String queryDictValueByText(String code, String text) {
        log.info("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String val = this.dictMapper.queryDictValueByText(code, text, TenantContext.getTenant());
        if (StringUtils.isBlank((String)val)) {
            val = this.dictMapper.queryDictValueByText(code, text, "100000");
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryDictValueByText(String code, String text, String busAccount) {
        String elsAccount = TenantContext.getTenant();
        try {
            TenantContext.setTenant(busAccount);
            String string = this.queryDictValueByText(code, text);
            return string;
        }
        finally {
            TenantContext.setTenant(elsAccount);
        }
    }

    @Override
    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(table).append(text).append(code);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        if (list == null) {
            log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryTableDictItemsByCode(table, text, code);
            this.redisUtil.set(redisKey.toString(), list, 1800L);
        }
        return list;
    }

    @Override
    public List<DictModel> queryTableDictItemsByCodeAndFilter(String table, String text, String code, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(code).append(filterSql);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        log.info("\u5b57\u5178\u7ffb\u8bd1,redisKey:" + redisKey.toString() + "-" + (list == null ? "null" : list.toString()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder builder = new StringBuilder(filterSql);
            if (!filterSql.contains("els_account")) {
                builder.append(" and els_account='").append(elsAccount).append("'");
            }
            if (CollectionUtil.isEmpty(list = this.dictMapper.queryTableDictItemsByCodeAndFilter(table, text, code, builder.toString()))) {
                builder = new StringBuilder(filterSql);
                if (!filterSql.contains("els_account")) {
                    builder.append(" and els_account='").append("100000").append("'");
                }
                list = this.dictMapper.queryTableDictItemsByCodeAndFilter(table, text, code, builder.toString());
            }
            this.redisUtil.set(redisKey.toString(), list, 1800L);
        }
        return list;
    }

    @Override
    @Cacheable(value={"sys:cache:dictTable"})
    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        List<DictModel> dicts = this.dictMapper.queryTableDictByKeys(table, text, code, keyArray);
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        block0: for (String key : keyArray) {
            for (DictModel dict : dicts) {
                if (!key.equals(dict.getValue())) continue;
                texts.add(dict.getText());
                continue block0;
            }
        }
        return texts;
    }

    @Override
    public boolean deleteByDictId(Dict sysDict) {
        sysDict.setDeleted(CommonConstant.DEL_FLAG_1);
        return this.updateById(sysDict);
    }

    @Override
    public boolean deleteBatchByIds(List<String> ids) {
        ArrayList<Dict> dictList = new ArrayList<Dict>();
        for (String id : ids) {
            Dict dict = new Dict();
            dict.setId(id);
            dict.setDeleted(CommonConstant.DEL_FLAG_1);
            dictList.add(dict);
        }
        return this.updateBatchById(dictList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(Dict sysDict, List<DictItem> sysDictItemList) {
        this.dictMapper.insert(sysDict);
        if (sysDictItemList != null) {
            for (DictItem entity : sysDictItemList) {
                entity.setDictId(sysDict.getId());
                this.dictItemMapper.insert(entity);
            }
        }
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    @Override
    public List<DictModel> queryAllUserBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    @Override
    public List<DictModel> queryTableDictItems(String table, String text, String code, String keyword) {
        return ((DictMapper)this.baseMapper).queryTableDictItems(table, text, code, "%" + keyword + "%");
    }

    @Override
    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField) {
        return ((DictMapper)this.baseMapper).queryTreeList(query, table, text, code, pidField, pid, hasChildField);
    }

    @Override
    public void deleteOneDictPhysically(String id) {
        ((DictMapper)this.baseMapper).deleteOneById(id);
        this.dictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(DictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDictDelFlag(int delFlag, String id) {
        ((DictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    @Override
    public List<Dict> queryDeleteList(String elsAccount) {
        return ((DictMapper)this.baseMapper).queryDeleteList(elsAccount);
    }

    @Override
    public List<String> queryTableKeyword(String table, String column, String value) {
        return ((DictMapper)this.baseMapper).queryTableKeyword(table, column, "%" + value + "%");
    }

    @Override
    public String queryTableDictTextByFilterSql(String table, String text, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(filterSql);
        String value = (String)this.redisUtil.get(redisKey.toString());
        if (StrUtil.isBlank((CharSequence)value)) {
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account")) {
                sql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString())))) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append("100000").append("' ");
                }
                value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString());
            }
            this.redisUtil.set(redisKey.toString(), value, 1800L);
        }
        return value;
    }

    @Override
    public String queryTableDictItemsByValue(String table, String text, String code, String filterSql, String val, String busAccount) {
        String elsAccount = busAccount;
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(code).append(filterSql);
        String value = (String)this.redisUtil.get(redisKey.toString());
        if (StrUtil.isBlank((CharSequence)value)) {
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account")) {
                sql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString())))) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append("100000").append("' ");
                }
                value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString());
            }
            this.redisUtil.set(redisKey.toString(), value, 1800L);
        }
        return value;
    }

    @Override
    public List<DictModel> queryTableDictListByFilterSql(String elsAccount, String table, String text, String value, String filterSql) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE);
        redisKey.append(COLON).append(elsAccount).append(COLON).append(table).append(COLON).append(text).append(COLON).append(value).append(COLON).append(filterSql);
        List<DictModel> result = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        if (CollectionUtil.isEmpty((Collection)result)) {
            SqlInjectionUtil.filterContent(table);
            SqlInjectionUtil.filterContent(text);
            SqlInjectionUtil.filterContent(value);
            SqlInjectionUtil.filterContent(filterSql);
            filterSql = StrUtil.isBlank((CharSequence)filterSql) ? " 1 = 1" : filterSql;
            StringBuilder currentSql = new StringBuilder(filterSql);
            currentSql.append(" and is_deleted = '0'");
            if (!filterSql.contains("id =") && !filterSql.contains("els_account")) {
                currentSql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (CollectionUtil.isEmpty(result = ((DictMapper)this.baseMapper).queryTableDictTextsByFilterSql(table, text, value, currentSql.toString()))) {
                StringBuilder adminSql = new StringBuilder(filterSql);
                if (!filterSql.contains("id =")) {
                    adminSql.append(" and is_deleted = '0'").append(" and els_account='").append("100000").append("' ");
                }
                result = ((DictMapper)this.baseMapper).queryTableDictTextsByFilterSql(table, text, value, adminSql.toString());
            }
            this.redisUtil.set(redisKey.toString(), result, 1800L);
        }
        return result;
    }

    @Override
    public String queryTableDictTextByFilterSql(String elsAccount, String key, String table, String text, String value, String filterSql) {
        List<DictModel> resultList = this.queryTableDictListByFilterSql(elsAccount, table, text, value, filterSql);
        String result = "";
        if (CollectionUtil.isNotEmpty(resultList)) {
            for (DictModel model : resultList) {
                if (model == null || !StrUtil.isNotBlank((CharSequence)model.getValue()) || !model.getValue().equals(key)) continue;
                result = model.getValue() + "_" + model.getText();
                break;
            }
            if (resultList.size() == 1 && StrUtil.isBlank((CharSequence)result)) {
                result = resultList.get(0).getText();
            }
        }
        return result;
    }

    @Override
    public Dict findDictByCode(String code) {
        Dict dict = (Dict)this.dictMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)code)).eq(Dict::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).eq(Dict::getElsAccount, (Object)TenantContext.getTenant()));
        if (null != dict) {
            return dict;
        }
        dict = (Dict)this.dictMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)code)).eq(Dict::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).eq(Dict::getElsAccount, (Object)"100000"));
        if (null != dict) {
            return dict;
        }
        return null;
    }

    @Override
    public void getDictByErp() {
        String elsAccount = TenantContext.getTenant();
        List<String> codes = Arrays.asList("getUnitData", "getCurrencyData", "getPayConditionData", "getSupplierGroup", "getSettlementTypeData", "getSupplierClassify", "getCustomerInfo", "getSettlementAccount");
        JSONObject custom = new JSONObject();
        custom.put("elsAccount", (Object)elsAccount);
        this.interfaceUtil.callInterface(elsAccount, codes, (Object)custom);
        HashMap<String, String> codeAndCustomParamMap = new HashMap<String, String>(){
            {
                this.put("getTradeData", DictEnums.TRADE.getFieldKeys());
            }
        };
        this.interfaceUtil.callInterface(elsAccount, (Map<String, String>)codeAndCustomParamMap);
    }

    @Override
    @Transactional
    public void addToEnterprise(String id) {
        Dict dict = (Dict)this.dictMapper.selectById((Serializable)((Object)id));
        List<DictItem> items = this.dictItemMapper.selectItemsByMainId(id);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"dict_code", (Object)dict.getDictCode());
        List oldDicts = this.dictMapper.selectList((Wrapper)queryWrapper);
        if (!oldDicts.isEmpty()) {
            String oldId = ((Dict)oldDicts.get(0)).getId();
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"dict_id", (Object)oldId);
            this.dictItemMapper.delete((Wrapper)delWrapper);
            this.dictMapper.deleteById((Serializable)((Object)oldId));
        }
        dict.setId(null);
        dict.setElsAccount(elsAccount);
        dict.setSourceType("2");
        dict.setCreateBy(subAccount);
        dict.setUpdateBy(subAccount);
        dict.setCreateTime(new Date());
        dict.setUpdateTime(new Date());
        this.dictMapper.insert(dict);
        for (DictItem item : items) {
            item.setId(null);
            item.setDictId(dict.getId());
            item.setElsAccount(elsAccount);
            item.setCreateBy(subAccount);
            item.setUpdateBy(subAccount);
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
        }
        if (!CollectionUtils.isEmpty(items)) {
            this.dictItemMapper.insertBatchSomeColumn(items);
        }
    }

    @Override
    public List<DictItem> findOpenbusinessType() {
        JSONObject companySet;
        LoginUser user = SysUtil.getLoginUser();
        String permissionScope = null;
        if (user != null && (companySet = user.getCompanySet()) != null) {
            permissionScope = companySet.getString("permissionScope");
        }
        ArrayList<DictItem> dictItems = new ArrayList<DictItem>();
        DictItem dictItem = new DictItem();
        dictItem.setItemValue("all");
        dictItem.setItemText(I18nUtil.translate("i18n_title_all", "\u5168\u90e8"));
        dictItems.add(dictItem);
        if (StrUtil.isNotBlank((CharSequence)permissionScope)) {
            LambdaQueryWrapper dictQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dictQueryWrapper.eq(Dict::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)"permissionScope");
            Dict dict = (Dict)((DictMapper)this.baseMapper).selectOne((Wrapper)dictQueryWrapper);
            if (dict != null) {
                List<DictItem> items = this.dictItemService.selectItemsByMainId(dict.getId());
                List scopeList = StrUtil.split((CharSequence)permissionScope, (CharSequence)",");
                for (DictItem item : items) {
                    if (!scopeList.contains(item.getItemValue())) continue;
                    dictItems.add(item);
                }
            }
        }
        return dictItems;
    }

    @Override
    public List<DictItem> findByElsAccount(String type, String elsAccount) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)type)).eq(Dict::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).eq(Dict::getElsAccount, (Object)elsAccount));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return this.dictItemMapper.selectItemsByMainId(((Dict)list.get(0)).getId());
    }
}

