/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSExcelBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportCheckDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.entity.ExcelHeader;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.enums.ExcelTemplateTypeEnum;
import com.els.modules.system.mapper.ExcelDetailMapper;
import com.els.modules.system.mapper.ExcelHeaderMapper;
import com.els.modules.system.rpc.service.BaseInvokeExcelImportRpcService;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ExcelHeaderService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDataCheckListener;
import com.els.modules.system.util.ExcelDataListener;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelGenerateRunner;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.system.util.ExcelRedisKeyGenerateUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ExcelHeaderVO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelHeaderServiceImpl
extends ServiceImpl<ExcelHeaderMapper, ExcelHeader>
implements ExcelHeaderService {
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    DictService dictService;
    @Resource
    private ExcelHeaderMapper excelHeaderMapper;
    @Resource
    private ExcelDetailMapper excelDetailMapper;
    @Autowired
    private RedisUtil redisUtil;
    private final String LOCK_PREFIX = "excel_import_";
    private final long EXPIRE_TIME = 50000L;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ExcelHeader excelHeader, List<ExcelDetail> excelDetailList) {
        this.excelHeaderMapper.insert(excelHeader);
        int i = 1;
        for (ExcelDetail entity : excelDetailList) {
            entity.setExcelId(excelHeader.getId());
            entity.setColumnIndex(i);
            this.excelDetailMapper.insert(entity);
            ++i;
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ExcelHeader excelHeader, List<ExcelDetail> excelDetailList) {
        this.excelHeaderMapper.updateById(excelHeader);
        this.excelDetailMapper.deleteByMainId(excelHeader.getId());
        int i = 1;
        Date date = new Date();
        for (ExcelDetail entity : excelDetailList) {
            entity.setExcelId(excelHeader.getId());
            entity.setColumnIndex(i);
            entity.setUpdateTime(date);
            this.excelDetailMapper.insert(entity);
            ++i;
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.excelDetailMapper.deleteByMainId(id);
        this.excelHeaderMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.excelDetailMapper.deleteByMainId(serializable.toString());
            this.excelHeaderMapper.deleteById(serializable);
        }
    }

    @Override
    public void getTemplate(HttpServletResponse res, String excelCode) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        if (excelHeader == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_VERAoWWWWWWjWWWWWIr_9a568bb2", "\u8bf7\u914d\u7f6e\u7f16\u7801[${0}]\u7684Excel\u6a21\u677f", excelCode));
        }
        if (ExcelTemplateTypeEnum.FIXED.getCode().contentEquals(excelHeader.getTemplateType())) {
            this.getFixedTemplate(res, excelHeader);
        } else {
            this.getDynamicTemplate(res, excelHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDynamicTemplate(HttpServletResponse res, ExcelHeader excelHeader) {
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ServletOutputStream outputStream = null;
        try {
            outputStream = res.getOutputStream();
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList)).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(new ArrayList(16));
        }
        catch (Exception e) {
            this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFixedTemplate(HttpServletResponse res, ExcelHeader excelHeader) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String filePath = excelHeader.getFixedTemplate();
        try {
            String localPath;
            String downloadFilePath;
            File file;
            res.setContentType("application/force-download");
            res.addHeader("Content-Disposition", "attachment;fileName=" + new String(excelHeader.getExcelName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            filePath = filePath.replace("..", "");
            if (filePath.endsWith(",")) {
                filePath = filePath.substring(0, filePath.length() - 1);
            }
            if ((file = new File(downloadFilePath = (localPath = this.uploadpath) + File.separator + filePath)).exists()) {
                int len;
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = res.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                    outputStream.flush();
                }
                res.flushBuffer();
            }
        }
        catch (Exception e) {
            this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> importExcel(String excelCode, MultipartFile file, Map<String, Object> otherRequestParam) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ExcelImportRpcService service = SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class).getExcelImportRpcService(excelHeader.getImplBean());
        try (InputStream inputStream = file.getInputStream();){
            ExcelDataListener excelDataListener = new ExcelDataListener(service, detailList, null, null, excelHeader.getExcelCode(), excelHeader.getExcelName(), TenantContext.getTenant(), null, otherRequestParam);
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("successCount", excelDataListener.getSuccessCount());
            errorMap.put("failCount", excelDataListener.getFailCount());
            errorMap.put("errorId", excelDataListener.getErrorExcelKey());
            if (StrUtil.isNotBlank((CharSequence)excelDataListener.getInterfaceMsg())) {
                errorMap.put("interfaceMsg", excelDataListener.getInterfaceMsg());
            }
            HashMap<String, Object> hashMap = errorMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    public List previewExcel(String dataKey, String excelCode, MultipartFile file) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        Map<String, String> colDictCodeMap = detailList.parallelStream().filter(detail -> ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())).collect(Collectors.toMap(ExcelDetail::getColumnCode, ExcelDetail::getDataFormat));
        ExcelImportRpcService service = SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class).getExcelImportRpcService(excelHeader.getImplBean());
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            ExcelDataListener excelDataListener = new ExcelDataListener(service, detailList, dataKey, null, excelHeader.getExcelCode(), excelHeader.getExcelName(), TenantContext.getTenant(), null, null);
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0)).doRead();
            ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
            if (CollUtil.isNotEmpty(excelImportDTO.getDataList())) {
                this.getDictTextByCode(excelImportDTO.getDataList(), colDictCodeMap);
            }
            if (CollUtil.isEmpty(excelImportDTO.getDataList()) && CharSequenceUtil.isNotBlank((CharSequence)excelDataListener.getErrorExcelKey())) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("errorExcelKey", excelImportDTO.getErrorExcelRunnerId());
                errorMap.put("successCount", excelDataListener.getSuccessCount());
                errorMap.put("failCount", excelDataListener.getFailCount());
                throw new ELSExcelBootException(I18nUtil.translate("i18n_alert_uNIrjWFxqjWVImSKuN_65704043", "\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"), errorMap);
            }
            List<Map<String, Object>> list = excelImportDTO.getDataList();
            return list;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> importPreviewExcelData(String dataKey, String excelCode, Map<String, Object> otherRequestParam) {
        String requestId = dataKey;
        String lockKey = "excel_import_" + dataKey;
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        try {
            if (this.redisUtil.tryGetDistributedLock(lockKey, requestId, 50000L)) {
                String tenant = TenantContext.getTenant();
                ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
                if (excelHeader == null) {
                    excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
                }
                ExcelImportRpcService service = SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class).getExcelImportRpcService(excelHeader.getImplBean());
                ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
                excelImportDTO.setOtherRequestParam(otherRequestParam);
                service.importExcel(excelImportDTO);
                TenantContext.setTenant(tenant);
                errorMap.put("successCount", Long.parseLong(String.valueOf(ObjectUtil.defaultIfNull((Object)this.redisUtil.get(ExcelRedisKeyGenerateUtil.generateImportSuccessCountKey(excelImportDTO.getExcelBusinessOptType(), excelImportDTO.getErrorExcelRunnerId())), (Object)0))));
                String key = ExcelRedisKeyGenerateUtil.generateImportKey(excelImportDTO.getExcelBusinessOptType(), TenantContext.getTenant(), excelImportDTO.getErrorExcelRunnerId());
                long mapLen = this.redisUtil.mapLen(key);
                this.redisUtil.del(dataKey);
                if (mapLen > 2L) {
                    errorMap.put("failCount", mapLen - 2L);
                    errorMap.put("errorId", excelImportDTO.getErrorExcelRunnerId());
                    SpringContextUtils.getBean(ExcelGenerateRunner.class).immediateExec(excelImportDTO.getErrorExcelRunnerId(), null, tenant);
                } else {
                    errorMap.put("failCount", 0);
                    SpringContextUtils.getBean(BackgroundFileTaskService.class).deleteFileTask(excelImportDTO.getErrorExcelRunnerId());
                }
                if (StrUtil.isNotBlank((CharSequence)excelImportDTO.getInterfaceMsg())) {
                    errorMap.put("interfaceMsg", excelImportDTO.getInterfaceMsg());
                }
                HashMap<String, Object> hashMap = errorMap;
                return hashMap;
            }
            throw new ELSBootException(I18nUtil.translate("i18n_alert_WFuNsWVSVBtk_f35bfc9d", "\u6570\u636e\u5bfc\u5165\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"));
        }
        finally {
            this.redisUtil.releaseDistributedLock(lockKey, requestId);
        }
    }

    @Override
    public ExcelHeaderVO getExcelConfig(QueryWrapper<ExcelHeader> queryWrapper) {
        ExcelHeader excelHeader = (ExcelHeader)((ExcelHeaderMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (excelHeader == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_VWERuNIr_57fd0ad9", "\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
        }
        ExcelHeaderVO excelHeaderVO = new ExcelHeaderVO();
        BeanUtils.copyProperties((Object)excelHeader, (Object)excelHeaderVO);
        List<ExcelDetail> excelDetailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        excelHeaderVO.setExcelDetailList(excelDetailList);
        return excelHeaderVO;
    }

    @Override
    public ExcelHeaderVO getExcelConfig(String excelCode) {
        ExcelHeader excelHeader;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ExcelHeader::getExcelCode, (Object)excelCode)).orderByDesc(BaseEntity::getUpdateTime);
        List header = ((ExcelHeaderMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (header.size() > 1) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_MKOmWWWWWIr_2fbe8b35", "\u5b58\u5728\u591a\u4e2aExcel\u6a21\u677f"));
        }
        ExcelHeader excelHeader2 = excelHeader = header.isEmpty() ? null : (ExcelHeader)header.get(0);
        if (excelHeader == null) {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ExcelHeader::getExcelCode, (Object)excelCode)).orderByDesc(BaseEntity::getUpdateTime);
            List excelHeaders = ((ExcelHeaderMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (excelHeaders.isEmpty()) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_VWERuNIr_57fd0ad9", "\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
            }
            if (header.size() > 1) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_MKOmWWWWWIr_2fbe8b35", "\u5b58\u5728\u591a\u4e2aExcel\u6a21\u677f"));
            }
            excelHeader = (ExcelHeader)excelHeaders.get(0);
            Assert.isTrue((excelHeader != null ? 1 : 0) != 0, (String)I18nUtil.translate("i18n_alert_VWERuNIr_57fd0ad9", "\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
        }
        ExcelHeaderVO excelHeaderVO = new ExcelHeaderVO();
        BeanUtils.copyProperties((Object)excelHeader, (Object)excelHeaderVO);
        List<ExcelDetail> excelDetailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        excelHeaderVO.setExcelDetailList(excelDetailList);
        return excelHeaderVO;
    }

    @Override
    @Transactional
    public void addToEnterprise(String id) {
        ExcelHeader excelHeader = (ExcelHeader)this.excelHeaderMapper.selectById((Serializable)((Object)id));
        List<ExcelDetail> details = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"excel_code", (Object)excelHeader.getExcelCode());
        queryWrapper.eq((Object)"impl_bean", (Object)excelHeader.getImplBean());
        queryWrapper.eq((Object)"template_type", (Object)excelHeader.getTemplateType());
        List headers = this.excelHeaderMapper.selectList((Wrapper)queryWrapper);
        if (!headers.isEmpty()) {
            String oldId = ((ExcelHeader)headers.get(0)).getId();
            this.excelDetailMapper.deleteByMainId(oldId);
            this.excelHeaderMapper.deleteById((Serializable)((Object)oldId));
        }
        excelHeader.setId(null);
        excelHeader.setElsAccount(elsAccount);
        excelHeader.setCreateBy(subAccount);
        excelHeader.setUpdateBy(subAccount);
        excelHeader.setCreateTime(new Date());
        excelHeader.setUpdateTime(new Date());
        this.excelHeaderMapper.insert(excelHeader);
        for (ExcelDetail detail : details) {
            detail.setId(null);
            detail.setExcelId(excelHeader.getId());
            detail.setElsAccount(elsAccount);
            detail.setCreateBy(subAccount);
            detail.setUpdateBy(subAccount);
            detail.setCreateTime(new Date());
            detail.setUpdateTime(new Date());
        }
        if (!details.isEmpty()) {
            this.excelDetailMapper.insertBatchSomeColumn(details);
        }
    }

    private void getDictTextByCode(List dataList, Map<String, String> colDictCodeMap) {
        for (Object e : dataList) {
            for (Map.Entry entry : ((Map)e).entrySet()) {
                String value;
                String col = (String)entry.getKey();
                String string = value = entry.getValue() != null ? String.valueOf(entry.getValue()) : null;
                if (!colDictCodeMap.containsKey(col) || value == null || StringUtils.isBlank((String)value)) continue;
                String dictCode = colDictCodeMap.get(col);
                String text = this.getDictTextByVal(dictCode, value);
                entry.setValue(text);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictTextByVal(String dictCode, String value) {
        String text;
        if (StringUtils.isBlank((String)dictCode)) {
            return value;
        }
        if (dictCode.contains("#") || dictCode.contains(",")) {
            String[] params = null;
            params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
            if (params.length < 3) {
                throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
            SqlInjectionUtil.filterContent(sqlInjCheck);
            if (params.length != 4) throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178\u4e0d\u5339\u914d"));
            String tableName = params[0];
            String textCol = params[1];
            String valueCol = params[2];
            String filterSql = params[3] + " and " + valueCol + " = '" + value + "'";
            SqlInjectionUtil.filterContent(filterSql);
            try {
                text = this.dictService.queryTableDictItemsByValue(tableName, valueCol, textCol, filterSql, value, TenantContext.getTenant());
                return StringUtils.isNotBlank((String)text) ? text : value;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                text = "";
            }
            return StringUtils.isNotBlank((String)text) ? text : value;
        } else {
            text = this.dictService.queryDictTextByKey(dictCode, value, TenantContext.getTenant());
        }
        return StringUtils.isNotBlank((String)text) ? text : value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExcelImportCheckDTO importExcelDataInteractive(String excelCode, MultipartFile file) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ExcelImportRpcService service = SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class).getExcelImportRpcService(excelHeader.getImplBean());
        try (InputStream inputStream = file.getInputStream();){
            ExcelDataCheckListener excelDataListener = new ExcelDataCheckListener(service, detailList, null, null, TenantContext.getTenant());
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
            ExcelImportCheckDTO excelImportCheckDTO = excelDataListener.getCheckDTO();
            return excelImportCheckDTO;
        }
        catch (Exception e) {
            if (!(e instanceof ELSExcelBootException)) throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
            throw (ELSExcelBootException)e;
        }
    }

    @Override
    public ExcelImportCheckDTO importExcelPreviewDataInteractive(String dataKey, String excelCode) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        ExcelImportRpcService service = SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class).getExcelImportRpcService(excelHeader.getImplBean());
        ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
        return service.interactiveCheck(excelImportDTO);
    }
}

