/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.ConvertUtils;
import com.els.modules.system.enums.PwComplexityVerifyEnum;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.util.AssertI18nUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.LocalDateTimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PwVerifyUtil {
    private PwVerifyUtil() {
    }

    public static void pwComplexityVerify(String pwComplexityItem, String pwString) {
        if (StringUtils.isBlank((CharSequence)pwComplexityItem)) {
            return;
        }
        PwVerifyUtil.pwComplexityVerify((Map)JSONObject.parseObject((String)pwComplexityItem, HashMap.class), pwString);
    }

    public static void pwComplexityVerify(Map<String, Integer> pwComplexityItem, String pwString) {
        if (pwComplexityItem.isEmpty()) {
            return;
        }
        Map<String, PwComplexityVerifyEnum> enumMap = PwComplexityVerifyEnum.getEnumMap();
        for (Map.Entry<String, Integer> entry : pwComplexityItem.entrySet()) {
            if (!enumMap.containsKey(entry.getKey()) || entry.getValue() == null || entry.getValue() == 0) continue;
            PwComplexityVerifyEnum pwComplexityVerifyEnum = enumMap.get(entry.getKey());
            AssertI18nUtil.isTrue(!pwComplexityVerifyEnum.verify(pwString), pwComplexityVerifyEnum.ii18nEnum());
        }
    }

    public static void pwMinLengthVerify(String pwString, int minLength) {
        AssertI18nUtil.isTrue(minLength != 0 && pwString.length() < minLength, I18nElsPwSecurityEnum.I18N_MIN_LENGTH, String.valueOf(minLength));
    }

    public static String pwModifyIntervalVerify(Date lastModifyDate, int modifyInterval) {
        if (modifyInterval == 0 || !LocalDateTimeUtil.compareMonthLater(lastModifyDate, modifyInterval)) {
            return null;
        }
        return I18nUtil.translate(I18nElsPwSecurityEnum.I18N_MODIFY_INTERVAL, String.valueOf(modifyInterval));
    }

    public static String pwComplexityVerifyStr(String pwComplexityItem, int minLength, String pwString) {
        if (StringUtils.isBlank((CharSequence)pwComplexityItem)) {
            return "";
        }
        Map resultMap = (Map)JSONObject.parseObject((String)pwComplexityItem, HashMap.class);
        if (resultMap.isEmpty()) {
            return "";
        }
        ArrayList<String> pwdErrList = new ArrayList<String>();
        Integer numCount = 0;
        Integer lowerCount = 0;
        Integer upperCount = 0;
        Integer specialCount = 0;
        if (!resultMap.isEmpty()) {
            if (resultMap.containsKey("includeNum") && (Integer)resultMap.get("includeNum") != 0) {
                numCount = (Integer)resultMap.get("includeNum");
            }
            if (resultMap.containsKey("includeLowerCase") && (Integer)resultMap.get("includeLowerCase") != 0) {
                lowerCount = (Integer)resultMap.get("includeLowerCase");
            }
            if (resultMap.containsKey("includeUpperCase") && (Integer)resultMap.get("includeUpperCase") != 0) {
                upperCount = (Integer)resultMap.get("includeUpperCase");
            }
            if (resultMap.containsKey("includeSymbol") && (Integer)resultMap.get("includeSymbol") != 0) {
                specialCount = (Integer)resultMap.get("includeSymbol");
            }
        }
        if (numCount == 1) {
            pwdErrList.add(I18nUtil.translate("i18n_title_number", "\u6570\u5b57"));
        }
        if (lowerCount == 1) {
            pwdErrList.add(I18nUtil.translate("i18n_alert_XMJI_2b16c040", "\u5c0f\u5199\u5b57\u6bcd"));
        }
        if (upperCount == 1) {
            pwdErrList.add(I18nUtil.translate("i18n_alert_fMJI_29c48c28", "\u5927\u5199\u5b57\u6bcd"));
        }
        if (specialCount == 1) {
            pwdErrList.add(I18nUtil.translate("i18n_field_zWJB_35a88aa0", "\u7279\u6b8a\u5b57\u7b26"));
        }
        String pwdErr = ConvertUtils.isNotEmpty(pwdErrList) ? pwdErrList.stream().collect(Collectors.joining("|")) : "";
        StringBuilder pwdErrStr = new StringBuilder();
        pwdErrStr.append(I18nUtil.translate("i18n_alert_wodsx_453b707f", "\u5bc6\u7801\u5e94\u5305\u542b")).append("(");
        pwdErrStr.append(pwdErr).append(")");
        if (minLength > 0) {
            pwdErrStr.append(",").append(I18nUtil.translate("i18n_alert_HzWWWWLIX_b360d107", "\u957f\u5ea6${0}\u4f4d\u4ee5\u4e0a", String.valueOf(minLength)));
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            PwComplexityVerifyEnum pwComplexityVerifyEnum;
            boolean verify;
            if (entry.getValue() == null || (Integer)entry.getValue() == 0 || (verify = (pwComplexityVerifyEnum = PwComplexityVerifyEnum.of((String)entry.getKey())).verify(pwString))) continue;
            return pwdErrStr.toString();
        }
        if (minLength != 0 && pwString.length() < minLength) {
            return pwdErrStr.toString();
        }
        return "";
    }
}

