/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.config.ElsStaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.justauth.JustAuthUtil;
import com.els.modules.justauth.cache.CustomRedisStateCache;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.service.ElsCompanyBusinessRuleService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.AuthCallbackVO;
import com.els.modules.system.vo.ElsCompanyBusinessRuleVO;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.system.vo.ElsSubAccountVO;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.AuthRequestBuilder;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/thirdLogin"})
@Api(tags={"\u7b2c\u4e09\u65b9\u767b\u5f55"})
public class ThirdLoginNewController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginNewController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Value(value="${els.service.address}")
    private String baseHost;
    @Resource
    private CustomRedisStateCache redisStateCache;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private ElsCompanyBusinessRuleService elsCompanyBusinessRuleService;
    @Autowired
    private ElsStaticConfig staticConfig;
    private static final String STATE_KEY = "sys:thirdLogin:state:";
    private static final String ACCOUNT_KEY = "sys:thirdLogin:account:";

    private AuthRequest getAuthRequest(String elsAccount, String source, String type, Boolean flag) {
        JustAuthConfig config = this.justAuthConfigService.getOneConfig(elsAccount, JustAuthUtil.getAuthConfigType(source));
        if (config == null) {
            throw new ELSBootException("\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e0d\u5b58\u5728\uff01");
        }
        String uri = "/user/qcLogin";
        if ("mobile".equals(type)) {
            uri = "/mobile";
        }
        if (flag.booleanValue()) {
            source = JustAuthUtil.getAuthType(source);
        }
        String redirectUri = this.baseHost + uri + "?type%3D" + source.toLowerCase();
        return AuthRequestBuilder.builder().source(source.toLowerCase()).authConfig(o -> AuthConfig.builder().clientId(config.getClientId()).clientSecret(config.getClientSecret()).agentId(config.getAgentId()).redirectUri(redirectUri).build()).authStateCache((AuthStateCache)this.redisStateCache).build();
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u4e8c\u7ef4\u7801\u6e32\u67d3")
    @GetMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response, HttpServletRequest request) throws IOException {
        String corpId;
        AuthRequest authRequest = this.getAuthRequest("100000", source, "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        if ("DINGTALK_ACCOUNT".startsWith(source.toUpperCase()) && StrUtil.isNotBlank((CharSequence)(corpId = request.getParameter("corpId")))) {
            authorizeUrl = authorizeUrl + "%26corpId%3D" + corpId;
        }
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u6388\u6743\u767b\u5f55")
    @GetMapping(value={"/render/{elsAccount}/{type}/{source}"})
    public void render2(@PathVariable(value="elsAccount") String elsAccount, @PathVariable(value="type") String type, @PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response, HttpServletRequest request) throws IOException {
        AuthRequest authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), type, true);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if ("DINGTALK_ACCOUNT".startsWith(source.toUpperCase())) {
            String corpId = request.getParameter("corpId");
            if (StrUtil.isNotBlank((CharSequence)corpId)) {
                authorizeUrl = authorizeUrl + "%26corpId%3D" + corpId;
            }
            log.info(":::\u9489\u9489\u7b2c\u4e09\u65b9\u5e94\u7528\u767b\u5f55:{}", (Object)corpId);
        }
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, object, 1800L);
        }
        this.redisUtil.set(ACCOUNT_KEY + state, elsAccount, 1800L);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u626b\u7801callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallbackVO callback) {
        AuthRequest authRequest;
        AuthResponse response;
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)((Object)callback)));
        String elsAccount = "100000";
        boolean flag = false;
        if (this.redisUtil.get(ACCOUNT_KEY + callback.getState()) != null) {
            elsAccount = (String)this.redisUtil.get(ACCOUNT_KEY + callback.getState());
            flag = true;
        }
        boolean success = (response = (authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), "pc", flag)).login((AuthCallback)callback)).getCode() == 2000;
        log.info("ThirdLoginMsg :{},code:{},{}", new Object[]{JSONObject.toJSONString((Object)response), response.getCode(), success});
        Result<JSONObject> result = new Result<JSONObject>();
        if (success) {
            boolean dingDingOrderUser;
            log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f");
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            StringBuffer uuid = new StringBuffer(data.getString("uuid"));
            boolean dingFlag = false;
            if ("DINGTALK_ACCOUNT".startsWith(source.toUpperCase()) && StrUtil.isNotBlank((CharSequence)callback.getCorpId())) {
                log.info(":::dingtalk corpId:{}", (Object)callback.getCorpId());
                uuid.append("-").append(callback.getCorpId());
                dingFlag = true;
            }
            ThirdLoginModel tlm = new ThirdLoginModel(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid.toString(), username, avatar);
            ThirdAccount thrid = this.getThirdAccounts(elsAccount, JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid.toString());
            ThirdAccount user = null;
            if (!dingFlag) {
                if (thrid == null) {
                    log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u65b0\u4fdd\u5b58\u7b2c\u4e09\u65b9\u7528\u6237");
                    user = this.saveThirdUser(tlm, elsAccount);
                } else {
                    user = thrid;
                }
            }
            boolean bl = dingDingOrderUser = dingFlag && thrid != null && ConvertUtils.isNotEmpty(thrid.getUserId());
            if (dingDingOrderUser || !dingFlag && ConvertUtils.isNotEmpty(user.getUserId())) {
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u51c6\u5907\u751f\u6210token");
                user = thrid == null ? user : thrid;
                String userId = user.getUserId();
                ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
                if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
                    throw new ELSBootException(I18nUtil.translate("i18n_alert_rjDIOyW_d35fed0b", "\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
                }
                JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
                try {
                    TenantContext.setTenant(account.getElsAccount());
                    this.userInfo(account, result, busObj);
                    log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c:{}", result);
                }
                finally {
                    TenantContext.clear();
                }
            } else if (dingFlag) {
                JSONObject obj = new JSONObject();
                result.setResult(obj);
                result.success("\u4e0d\u5b58\u5728\u8be5\u8d26\u53f7\u5bf9\u5e94\u7684\u4e0b\u5355\u7528\u6237\u4fe1\u606f\uff01");
            } else {
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)user.getId());
                result.setResult(obj);
                result.success("\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01");
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7:{}", result);
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return result;
    }

    private ThirdAccount getThirdAccounts(String busAccount, String source, String uuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
        query.eq(ThirdAccount::getThirdType, (Object)source);
        query.eq(ThirdAccount::getBusAccount, (Object)busAccount);
        List list = this.thirdAccountService.list((Wrapper)query).stream().filter(o -> CharSequenceUtil.isNotBlank((CharSequence)o.getUserId())).collect(Collectors.toList());
        log.info("\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u67e5\u8be2\u7528\u6237\u4fe1\u606f,busAccount:{},source:{},uuid:{},result:{}", new Object[]{busAccount, source, uuid, list});
        if (CollectionUtils.isNotEmpty(list)) {
            ThirdAccount thirdAccount = (ThirdAccount)list.get(0);
            if (CommonConstant.USER_FREEZE.equals(thirdAccount.getStatus())) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_rjDIOyW_d35fed0b", "\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            return thirdAccount;
        }
        return null;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign(elsAccount + "_" + subAccount, syspassword);
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 1800L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, adminFlag);
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(elsAccount);
        ElsTenant elsTenant = this.elsTenantService.findByElsAccount(elsAccount);
        list.add(new ElsCompanySetVO("companyShortName", elsTenant != null ? elsTenant.getCompanyShortName() : ""));
        list.add(new ElsCompanySetVO("companyLogo", elsTenant != null ? elsTenant.getCompanyLogo() : ""));
        JSONObject companySetObj = this.getObjBySet(list);
        List<ElsCompanyBusinessRuleVO> companyBusinessRuleVOList = this.elsCompanyBusinessRuleService.findByElsAccount(elsAccount);
        JSONArray businessRuleList = this.getBusinessRuleList(companyBusinessRuleVOList);
        companySetObj.put("businessRuleList", (Object)businessRuleList);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)sysUser, (Object)elsSubAccountVO);
        elsSubAccountVO.setSerivceUrl(this.staticConfig.getService().get("address"));
        Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(elsAccount);
        if (map != null) {
            elsSubAccountVO.setAliasName(map.get("alias"));
            elsSubAccountVO.setEnterpriseName(map.get("name"));
            elsSubAccountVO.setEnterpriseLogo(map.get("default_value") != null && "1".equals(map.get("default_value")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONArray getBusinessRuleList(List<ElsCompanyBusinessRuleVO> list) {
        JSONArray jsonArray = new JSONArray();
        JSONObject object = null;
        String type = null;
        String action = null;
        String defaultValue = null;
        for (ElsCompanyBusinessRuleVO ruleDTO : list) {
            object = new JSONObject();
            type = ruleDTO.getItemType();
            defaultValue = ruleDTO.getDefaultValue();
            if (!"switch".equals(type) || !"0".equals(defaultValue)) continue;
            action = ruleDTO.getBusinessType() + ":" + "hideBtn" + ":" + ruleDTO.getItemCode();
            object.put("action", (Object)action);
            object.put("status", (Object)defaultValue);
            object.put("type", (Object)type);
            object.put("describe", (Object)ruleDTO.getItemName());
            jsonArray.add((Object)object);
        }
        return jsonArray.isEmpty() ? new JSONArray() : jsonArray;
    }

    private Result<JSONObject> userInfo1(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign(elsAccount + "_" + subAccount, syspassword);
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        TenantContext.setTenant(elsAccount);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, adminFlag);
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(elsAccount);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)sysUser);
        obj.put("companySet", (Object)this.getObjBySet(list));
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetVO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetVO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm, String elsAccount) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource().toUpperCase());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        user.setBusAccount(elsAccount);
        this.thirdAccountService.saveThirdUser(user);
        return user;
    }
}

