/*
 * Decompiled with CFR 0.152.
 */
package com.els.config;

import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ElsTenantHandler
implements TenantHandler {
    private static final Logger log = LoggerFactory.getLogger(ElsTenantHandler.class);
    private static List<String> tenantTablePrefix = new ArrayList<String>();
    private static List<String> notTenantTable = new ArrayList<String>();
    private static final String NOT_TENANT_TABLES = "";

    public ElsTenantHandler() {
        Environment env = SpringContextUtils.getBean(Environment.class);
        String tenantTablePrefixString = env.getProperty("els.tenant-table-prefix", "purchase_,sale_");
        tenantTablePrefix = Arrays.asList(tenantTablePrefixString.split(","));
        String notTenantTableString = env.getProperty("els.not-tenant-table", NOT_TENANT_TABLES);
        notTenantTable = Arrays.asList(notTenantTableString.split(","));
    }

    public Expression getTenantId(boolean select) {
        String tenant = TenantContext.getTenant();
        if (null == tenant) {
            log.error(":::\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5f02\u5e38\u4e3a\u7a7a");
            tenant = SysUtil.getLoginUser().getElsAccount();
        }
        return new StringValue(tenant);
    }

    public String getTenantIdColumn() {
        return "els_account";
    }

    public boolean doTableFilter(String tableName) {
        for (String prefix : tenantTablePrefix) {
            if (!tableName.toLowerCase().contains(prefix) || notTenantTable.contains(tableName.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private Expression in(String ids) {
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)new Column(this.getTenantIdColumn()));
        ExpressionList itemsList = new ExpressionList();
        ArrayList<LongValue> inValues = new ArrayList<LongValue>(2);
        for (String id : ids.split(",")) {
            inValues.add(new LongValue(id));
        }
        itemsList.setExpressions(inValues);
        inExpression.setRightItemsList((ItemsList)itemsList);
        return inExpression;
    }
}

