/*
 * Decompiled with CFR 0.152.
 */
package com.els.aop;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class LogAOP {
    private static final Logger log = LoggerFactory.getLogger(LogAOP.class);

    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..))")
    public void executionService() {
    }

    @Before(value="executionService()")
    public void doBefore(JoinPoint joinPoint) {
        String requestId = IdWorker.getIdStr();
        MDC.put((String)"requestId", (String)requestId);
        log.info("=====>@Before\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)Arrays.toString(joinPoint.getArgs()));
    }

    @AfterReturning(pointcut="executionService()", returning="returnValue")
    public void doAfterReturning(JoinPoint joinPoint, Object returnValue) {
        log.info("=====>@AfterReturning\uff1a\u54cd\u5e94\u53c2\u6570\u4e3a\uff1a{}", returnValue);
        MDC.clear();
    }
}

