/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util.i18N;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.config.BaiduConfig;
import com.els.modules.system.util.encrypt.EncryptUtil;
import com.els.modules.system.util.i18N.HttpGet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;

public class TranslateUtilBD {
    private static BaiduConfig baiduConfig = (BaiduConfig)SpringUtil.getBean(BaiduConfig.class);

    private TranslateUtilBD() {
    }

    @Test
    public static void main(String[] args) {
        System.out.println(TranslateUtilBD.baiduFY("\u7f8e\u4e3d\n\u5e74\u5c11\u6709\u4e3a", "zh", "en"));
    }

    public static String baiduFY(String sourceStr, String from, String to) {
        if (!TranslateUtilBD.baiduParamsCheck()) {
            throw new RuntimeException("\u8bf7\u5728i18nInit.properties\u6587\u4ef6\u4e2d\u6dfb\u52a0\u6b63\u786e\u7684\u767e\u5ea6\u7ffb\u8bd1\u8d26\u53f7\u4fe1\u606f");
        }
        Map<String, String> params = TranslateUtilBD.baiduParams(sourceStr, from, to, baiduConfig.getAppId(), baiduConfig.getPas());
        String responseStr = HttpGet.get(baiduConfig.getRequestUrl(), params);
        JSONObject jsoo = JSONObject.parseObject((String)responseStr);
        if ("54004".equals(jsoo.get((Object)"error_code"))) {
            params = TranslateUtilBD.baiduParams(sourceStr, from, to, baiduConfig.getAppIdTao(), baiduConfig.getPasswdTao());
            responseStr = HttpGet.get(baiduConfig.getRequestUrl(), params);
            jsoo = JSONObject.parseObject((String)responseStr);
        }
        if (jsoo.containsKey((Object)"trans_result")) {
            JSONArray jsoa = jsoo.getJSONArray("trans_result");
            try {
                return jsoa.toJSONString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sourceStr;
    }

    private static Map<String, String> baiduParams(String query, String from, String to, String appId, String pas) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("from", from);
        params.put("to", to);
        params.put("appid", appId);
        String salt = String.valueOf(System.currentTimeMillis());
        params.put("salt", salt);
        String src = appId + query + salt + pas;
        params.put("sign", EncryptUtil.md5(src));
        return params;
    }

    private static boolean baiduParamsCheck() {
        if (baiduConfig == null) {
            baiduConfig = (BaiduConfig)SpringUtil.getBean(BaiduConfig.class);
        }
        return !StringUtils.isBlank((String)baiduConfig.getAppId()) && !StringUtils.isBlank((String)baiduConfig.getPas()) && !StringUtils.isBlank((String)baiduConfig.getRequestUrl()) && !StringUtils.isBlank((String)baiduConfig.getAppIdTao()) && !StringUtils.isBlank((String)baiduConfig.getPasswdTao());
    }
}

