/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.aspect;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.Enhance;
import com.els.common.service.EnhanceService;
import com.els.common.util.SpringContextUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnhanceAspect {
    @Pointcut(value="@annotation(com.els.common.aspect.annotation.Enhance)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Enhance enhance = method.getAnnotation(Enhance.class);
        String beanName = enhance.beanName();
        if (StrUtil.isNotBlank((CharSequence)beanName) && SpringContextUtils.getApplicationContext().containsBean(beanName)) {
            EnhanceService service = (EnhanceService)SpringContextUtils.getBean(beanName);
            service.executeBefore(point.getArgs());
            Object result = point.proceed();
            service.executeAfter(result);
            return result;
        }
        return point.proceed();
    }
}

