/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.PurchaseAttachmentRecord;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.mapper.PurchaseAttachmentRecordMapper;
import com.els.modules.attachment.service.PurchaseAttachmentRecordService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentVO;
import com.els.modules.attachment.vo.SupplierVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseAttachmentRecordServiceImpl
extends ServiceImpl<PurchaseAttachmentRecordMapper, PurchaseAttachmentRecord>
implements PurchaseAttachmentRecordService {
    @Autowired
    private SaleAttachmentService saleAttachmentService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void sendAttachment(AttachmentVO attachmentVO) {
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<PurchaseAttachment> attachmentList = attachmentVO.getAttachmentList();
        List<SupplierVO> supplierList = attachmentVO.getSupplierList();
        ArrayList<PurchaseAttachmentRecord> attachmentRecordList = new ArrayList<PurchaseAttachmentRecord>();
        ArrayList<SaleAttachment> saleAttachmentList = new ArrayList<SaleAttachment>();
        Date currentTime = new Date();
        for (SupplierVO supplierVO : supplierList) {
            for (PurchaseAttachment att : attachmentList) {
                PurchaseAttachmentRecord record = new PurchaseAttachmentRecord();
                record.setElsAccount(elsAccount);
                record.setToElsAccount(supplierVO.getToElsAccount());
                record.setSupplierCode(supplierVO.getSupplierCode());
                record.setSupplierName(supplierVO.getSupplierName());
                record.setHeadId(att.getId());
                record.setCreateBy(loginUser.getSubAccount());
                record.setCreateTime(currentTime);
                record.setUpdateBy(loginUser.getSubAccount());
                record.setUpdateTime(currentTime);
                record.setSendTime(currentTime);
                record.setReceiveStatus("0");
                record.setId(IdWorker.getIdStr());
                attachmentRecordList.add(record);
                SaleAttachment attachment = new SaleAttachment();
                BeanUtil.copyProperties((Object)att, (Object)attachment, (String[])new String[0]);
                SysUtil.setSysParam(attachment, record);
                attachment.setId(null);
                attachment.setRelationId(att.getId());
                attachment.setHeadId(record.getId());
                attachment.setElsAccount(supplierVO.getToElsAccount());
                saleAttachmentList.add(attachment);
            }
        }
        this.saleAttachmentService.saveBatch(saleAttachmentList, 200);
        this.saveBatch(attachmentRecordList, 200);
    }

    @Override
    public List<PurchaseAttachmentRecord> selectByMainId(String mainId) {
        return ((PurchaseAttachmentRecordMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void updateStatusById(String id) {
        PurchaseAttachmentRecord record = new PurchaseAttachmentRecord();
        record.setId(id);
        record.setReceiveTime(new Date());
        record.setReceiveStatus("1");
        ((PurchaseAttachmentRecordMapper)this.baseMapper).updateById(record);
    }
}

