/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.dashboard.entity.Dashboard;
import com.els.modules.dashboard.entity.DashboardChart;
import com.els.modules.dashboard.mapper.DashboardChartMapper;
import com.els.modules.dashboard.mapper.DashboardMapper;
import com.els.modules.dashboard.service.DashboardService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardServiceImpl
extends ServiceImpl<DashboardMapper, Dashboard>
implements DashboardService {
    @Autowired
    private DashboardMapper dashboardMapper;
    @Autowired
    private DashboardChartMapper dashboardChartMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(Dashboard dashboard, List<DashboardChart> dashboardChartList) {
        this.dashboardMapper.insert(dashboard);
        for (DashboardChart entity : dashboardChartList) {
            entity.setDashboardId(dashboard.getId());
            this.dashboardChartMapper.insert(entity);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(Dashboard dashboard, List<DashboardChart> dashboardChartList) {
        this.dashboardMapper.updateById(dashboard);
        this.dashboardChartMapper.deleteByMainId(dashboard.getId());
        for (DashboardChart entity : dashboardChartList) {
            entity.setDashboardId(dashboard.getId());
            this.dashboardChartMapper.insert(entity);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.dashboardChartMapper.deleteByMainId(id);
        this.dashboardMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.dashboardChartMapper.deleteByMainId(serializable.toString());
            this.dashboardMapper.deleteById(serializable);
        }
    }
}

