/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.mapper.PermissionDataMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.vo.PermissionDataVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionDataServiceImpl
extends ServiceImpl<PermissionDataMapper, PermissionData>
implements PermissionDataService {
    private static final String PERMISSION_DATA_KEY = "sys:permissionData:";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    @Override
    public void savePermissionData(PermissionData permissionData) {
        ((PermissionDataMapper)this.baseMapper).insert(permissionData);
    }

    @Override
    public void updatePermissionData(PermissionDataVO permissionData) {
        String elsAccount = permissionData.getElsAccount();
        String subAccount = permissionData.getSubAccount();
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        ((PermissionDataMapper)this.baseMapper).deleteByMainId(elsAccount, subAccount);
        for (PermissionData data : dataList) {
            data.setId(IdWorker.getIdStr());
            data.setUserId(permissionData.getId());
            data.setElsAccount(elsAccount);
            data.setSubAccount(subAccount);
            data.setDeleted(CommonConstant.DEL_FLAG_0);
            data.setCreateTime(new Date());
        }
        if (!CollectionUtil.isEmpty(dataList)) {
            ((PermissionDataMapper)this.baseMapper).insertBatchSomeColumn(dataList);
        }
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        this.redisUtil.del(redisKey);
        ElsSubAccount account = new ElsSubAccount();
        account.setId(permissionData.getId());
        account.setSensitiveFieldGroups(permissionData.getSensitiveFieldGroups());
        this.elsSubAccountService.updateById(account);
    }

    @Override
    public void delPermissionData(String id) {
        PermissionData data = (PermissionData)((PermissionDataMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (data != null) {
            ((PermissionDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
            String redisKey = this.getRedisKey(data.getElsAccount(), data.getSubAccount());
            this.redisUtil.del(redisKey);
        }
    }

    @Override
    public void delBatchPermissionData(List<String> idList) {
        ((PermissionDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount) {
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        List dataList = (List)this.redisUtil.get(redisKey);
        if (dataList == null) {
            dataList = ((PermissionDataMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"sub_account", (Object)subAccount));
            this.redisUtil.set(redisKey, dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.getPermissionDataList(elsAccount, subAccount);
        if (dataList != null) {
            dataList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        }
        return dataList;
    }

    private String getRedisKey(String elsAccount, String subAccount) {
        StringBuilder key = new StringBuilder(PERMISSION_DATA_KEY);
        key.append(elsAccount).append("_").append(subAccount);
        return key.toString();
    }

    @Override
    public void batchSave(List<PermissionData> dataList) {
        ((PermissionDataMapper)this.baseMapper).insertBatchSomeColumn(dataList);
        String elsAccount = TenantContext.getTenant();
        List list = dataList.parallelStream().map(o -> o.getSubAccount()).distinct().collect(Collectors.toList());
        for (String subAccount : list) {
            String key = this.getRedisKey(elsAccount, subAccount);
            this.redisUtil.del(key);
        }
    }
}

