/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.system.util.I18nUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ThirdTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdTokenUtil.class);
    private static final String WECHAT_MP_GET_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    private static final String WECHAT_MP_GET_TOKEN_KEY = "sys:thirdToken:weixin_mp";
    private static final String WECHAT_EP_GET_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String WECHAT_EP_GET_TOKEN_KEY = "sys:thirdToken:weixin_ep";
    private static final String DING_TALK_GET_TOKEN_URL = "https://oapi.dingtalk.com/gettoken";
    private static final String DING_TALK_GET_TOKEN_KEY = "sys:thirdToken:dingtalk";
    private static final String FEI_SHU_POST_TOKEN_URL = "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal";
    private static final String FEI_SHU_POST_TOKEN_KEY = "sys:thirdToken:feishu";
    private static RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);

    public static String getWechatMpToken(String busAccount) {
        String token = (String)redisUtil.get("sys:thirdToken:weixin_mp:" + busAccount);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        JustAuthConfigService justAuthConfigService = SpringContextUtils.getBean(JustAuthConfigService.class);
        JustAuthConfig config = justAuthConfigService.getOneConfig(busAccount, "WECHAT_MP");
        log.info("WeConfig:{}", (Object)config);
        String appid = config.getClientId();
        String secret = config.getClientSecret();
        JSONObject object = new JSONObject();
        object.put("appid", (Object)appid);
        object.put("secret", (Object)secret);
        String invokeUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set("sys:thirdToken:weixin_mp:" + busAccount, token, expiresIn - 1200);
        return token;
    }

    public static String getWechatEpToken(String busAccount, JustAuthConfig outConfig) {
        String token = (String)redisUtil.get("sys:thirdToken:weixin_ep:" + busAccount);
        JustAuthConfigService justAuthConfigService = SpringContextUtils.getBean(JustAuthConfigService.class);
        JustAuthConfig config = justAuthConfigService.getOneConfig(busAccount, "WECHAT_ENTERPRISE");
        BeanUtils.copyProperties((Object)config, (Object)outConfig);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        String appid = config.getClientId();
        String secret = config.getClientSecret();
        JSONObject object = new JSONObject();
        object.put("corpid", (Object)appid);
        object.put("corpsecret", (Object)secret);
        String invokeUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set("sys:thirdToken:weixin_ep:" + busAccount, token, (long)expiresIn - 1200L);
        return token;
    }

    public static String getDingtalkToken(String busAccount, JustAuthConfig outConfig) {
        String token = (String)redisUtil.get("sys:thirdToken:dingtalk:" + busAccount);
        JustAuthConfigService justAuthConfigService = SpringContextUtils.getBean(JustAuthConfigService.class);
        JustAuthConfig config = justAuthConfigService.getOneConfig(busAccount, "DINGTALK");
        BeanUtils.copyProperties((Object)config, (Object)outConfig);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        String appid = config.getClientId();
        String secret = config.getClientSecret();
        JSONObject object = new JSONObject();
        object.put("appkey", (Object)appid);
        object.put("appsecret", (Object)secret);
        String invokeUrl = "https://oapi.dingtalk.com/gettoken?" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set("sys:thirdToken:dingtalk:" + busAccount, token, (long)expiresIn - 10L);
        return token;
    }

    public static String getFeiShuToken(String busAccount) {
        String token = (String)redisUtil.get("sys:thirdToken:feishu:" + busAccount);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        JustAuthConfigService justAuthConfigService = SpringContextUtils.getBean(JustAuthConfigService.class);
        JustAuthConfig config = justAuthConfigService.getOneConfig(busAccount, "FEISHU");
        String appid = config.getClientId();
        String secret = config.getClientSecret();
        JSONObject object = new JSONObject();
        object.put("app_id", (Object)appid);
        object.put("app_secret", (Object)secret);
        String result = HttpUtil.post((String)FEI_SHU_POST_TOKEN_URL, (String)object.toJSONString());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"tenant_access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("tenant_access_token");
        int expiresIn = resultObj.getIntValue("expire");
        redisUtil.set("sys:thirdToken:feishu:" + busAccount, token, (long)expiresIn - 10L);
        return token;
    }

    public static void main(String[] args) {
        JSONObject object = new JSONObject();
        object.put("appid", (Object)"wx65e0b7fba748919f");
        object.put("secret", (Object)"b37570eb06988bf2c962b382d8aa16a9");
        System.out.println(SysUtil.getUrlParamByJson(object));
    }
}

