/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.mapper.SaleAttachmentMapper;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.system.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9500\u552e\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/saleAttachment"})
public class SaleAttachmentController
extends BaseController<SaleAttachment, SaleAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(SaleAttachmentController.class);
    @Autowired
    private SaleAttachmentService attachmentSaleService;
    @Autowired
    private SaleAttachmentMapper attachmentMapper;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleAttachment attachmentSale, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<SaleAttachment> queryWrapper = QueryGenerator.initQueryWrapper(attachmentSale, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.attachmentSaleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String materialNumber = request.getParameter("materialNumber");
        if (StringUtils.isBlank((CharSequence)businessType)) {
            return Result.error(I18nUtil.translate("i18n_alert_RRESAc_50983d0e", "\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        }
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowday = dtf.format(time);
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + TenantContext.getTenant() + File.separator + nowday);
        if (!file.exists()) {
            file.mkdirs();
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                String fileName;
                Map.Entry entity = iterator.next();
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                int suffixLocation = documentName.lastIndexOf(STR_DOT);
                if (suffixLocation > 0) {
                    String documentType = documentName.substring(suffixLocation + 1);
                    fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
                } else {
                    fileName = documentName + STR_SPLIT + System.currentTimeMillis();
                }
                String documentLocation = File.separator + bizPath + File.separator + TenantContext.getTenant() + File.separator + nowday + File.separator + fileName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = file.getPath() + File.separator + fileName;
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])uploadFile.getBytes(), (File)savefile);
                SaleAttachment attachment = new SaleAttachment();
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(TenantContext.getTenant());
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(documentLocation);
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setMaterialNumber(materialNumber);
                attachment.setUploadTime(new Date());
                this.attachmentSaleService.save(attachment);
                return Result.ok(attachment);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error(I18nUtil.translate("i18n_alert_XVKm_24addeea", "\u4e0a\u4f20\u5931\u8d25"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response) {
        SaleAttachment attachment = (SaleAttachment)this.attachmentSaleService.getById((Serializable)((Object)id));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String localPath = this.uploadpath;
            String downloadFilePath = localPath + File.separator + attachment.getFilePath();
            File file = new File(downloadFilePath);
            if (file.exists()) {
                int len;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.flush();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/downloadZipBySubstitute"})
    public void downloadZipBySubstitute(@RequestBody List<String> ids, HttpServletResponse response) throws IOException {
        List<SaleAttachment> attachmentList = this.attachmentMapper.selectWithoutElsAccountByIds(ids);
        this.download(attachmentList, response);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u4e0b\u8f7d", operateType=1)
    @PostMapping(value={"/downloadZip"})
    public void downloadZip(@RequestBody List<String> ids, HttpServletResponse response) throws IOException {
        List attachmentList = this.attachmentSaleService.listByIds(ids);
        this.download(attachmentList, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(List<SaleAttachment> attachmentList, HttpServletResponse response) throws IOException {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"downloadZip.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bufferedInputStream = null;
        int bufSize = 51200;
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (SaleAttachment attachment : attachmentList) {
            try {
                int length;
                String downloadFilePath = this.uploadpath + File.separator + attachment.getFilePath();
                File file = new File(downloadFilePath);
                Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate("i18n_alert_BIxMKSIqQG_748441c8", "\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), bufSize);
                byte[] data = new byte[bufSize];
                Integer count = (Integer)nameIndex.get(attachment.getFileName());
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                nameIndex.put(attachment.getFileName(), count);
                String fileName = attachment.getFileName();
                if (count > 1) {
                    int index = fileName.lastIndexOf(STR_DOT);
                    String name = fileName.substring(0, index);
                    String sux = fileName.substring(index);
                    fileName = name + "(" + count.toString() + ")" + sux;
                }
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOutputStream.putNextEntry(zipEntry);
                while ((length = bufferedInputStream.read(data)) != -1) {
                    zipOutputStream.write(data, 0, length);
                    response.flushBuffer();
                }
            }
            catch (Exception e) {
                log.error("{}\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)attachment.getFileName(), (Object)e.getMessage());
            }
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        SaleAttachment attachment = (SaleAttachment)this.attachmentSaleService.getById((Serializable)((Object)id));
        String elsAccount = this.getTenantId();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate("i18n_alert_uvCXVQIWxqQG_7e96bcc2", "\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate("i18n_alert_IhdjQIWxqQG_29a7fa21", "\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.attachmentSaleService.delAttachmentSale(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.attachmentSaleService.delBatchAttachmentSale(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleAttachment attachmentSale = (SaleAttachment)this.attachmentSaleService.getById((Serializable)((Object)id));
        return Result.ok(attachmentSale);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @ApiOperation(value="\u9644\u4ef6\u53d1\u9001", notes="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.attachmentSaleService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }
}

