/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.util.PermissionDataUtil;
import com.els.modules.system.util.PermissionFlagUtil;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionDataAspect {
    @Autowired
    private PermissionDataService permissionDataService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.PermissionDataView)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        JSONObject companySet;
        boolean optFlag = false;
        LoginUser user = SysUtil.getLoginUser();
        String permissionScope = null;
        if (user != null && (companySet = user.getCompanySet()) != null) {
            String flag = companySet.getString("dataPermissionShow");
            permissionScope = companySet.getString("permissionScope");
            if ("1".equals(flag)) {
                optFlag = true;
            }
        }
        if (!optFlag || StrUtil.isBlank(permissionScope)) {
            return point.proceed();
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionDataView permissionDataView = method.getAnnotation(PermissionDataView.class);
        String account = JwtUtil.getUserNameByToken(request);
        String businessType = permissionDataView.businessType();
        List scopeList = StrUtil.split((CharSequence)permissionScope, (CharSequence)",");
        if (scopeList.contains(businessType)) {
            List<PermissionData> dataList = this.permissionDataService.getPermissionDataList(account.split("_")[0], account.split("_")[1], businessType);
            PermissionDataUtil.setData(dataList);
            PermissionFlagUtil.setPermissionFlag("1");
        }
        return point.proceed();
    }
}

